/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class CSVBufferedReader
extends BufferedReader {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public CSVBufferedReader(Reader in) {
        super(in);
    }

    public String readLine() throws IOException {
        String line = super.readLine();
        if (line != null && line.startsWith("\"")) {
            String searchLine = line.substring(1, line.length());
            while (!this.findEndingQuote(searchLine)) {
                searchLine = super.readLine();
                if (searchLine == null) break;
                line = String.valueOf(line) + LINE_SEPARATOR + searchLine;
            }
        }
        return line;
    }

    private boolean findEndingQuote(String line) {
        return (line = line.replaceAll("\"\"", "")).indexOf("\"") > -1;
    }
}

