/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.internal.util.DatapoolSuggestedTypeChecker;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolConstants;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVBufferedReader;
import org.eclipse.hyades.test.ui.datapool.internal.util.CSVTokenizer;
import org.eclipse.hyades.test.ui.datapool.internal.util.CorruptCSVFileException;
import org.eclipse.hyades.test.ui.datapool.util.DatapoolUtilities;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.osgi.util.NLS;

public class CSVImportExportUtil {
    public static final String ASCII = "US-ASCII";
    public static final String ISONLATIN = "ISO-8859-1";
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF16LE = "UTF-16LE";
    public static final String UTF16BE = "UTF-16BE";
    private static final String SEPERATOR = ",";
    private static final String LINEFEED = "\n";
    private static final String CARRIAGE_RETURN = "\r";
    private static final CSVImportExportUtil instance = new CSVImportExportUtil();

    public static CSVImportExportUtil getInstance() {
        return instance;
    }

    private CSVImportExportUtil() {
    }

    public boolean validateCSVFile(String csvFilePath, boolean isFirstRowVariableInfo, boolean isFirstColumnEquivalenceClassInfo, String encoding) throws CorruptCSVFileException {
        return this.validateCSVFileWithDatapool(csvFilePath, null, isFirstRowVariableInfo, isFirstColumnEquivalenceClassInfo, false, encoding);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateCSVFileWithDatapool(String csvFilePath, IDatapool datapool, boolean isFirstRowVariableInfo, boolean isFirstColumnEquivalenceClassInfo, boolean isReplaceExistingRecords, String encoding) throws CorruptCSVFileException {
        validateDatapool = datapool != null && datapool.getEquivalenceClassCount() > 0 && datapool.getVariableCount() > 0;
        lineReader = null;
        lineReader = encoding == null || encoding.trim().length() == 0 ? new BufferedReader(new InputStreamReader(new FileInputStream(csvFilePath))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFilePath), encoding));
        line = lineReader.readLine();
        lineCount = 1;
        variableCount = -1;
        if (validateDatapool && (variableCount = datapool.getVariableCount()) > DatapoolConstants.MAXIMUM_VARIABLE_LIMIT) {
            throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_VARIABLE_LIMIT_EXCEEDED, (Object)DatapoolConstants.MAXIMUM_VARIABLE_LIMIT)}));
        }
        if (line == null) {
            throw new CorruptCSVFileException(UiPluginResourceBundle.DATA_COL_DLG_ERROR_EMPTY_CSV_FILE);
        }
        if (isFirstRowVariableInfo) {
            if (line.trim().length() == 0) {
                throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_MISSING_CVS_LINE}));
            }
            tokenizer = new CSVTokenizer(line);
            if (isFirstColumnEquivalenceClassInfo && (!tokenizer.hasMoreTokens() || tokenizer.nextToken().trim().length() > 0)) {
                throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_MISSING_EQUIVALENCE}));
            }
            variableNames = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                suggestedType = null;
                variableName = tokenizer.nextToken().trim();
                twoColonsIndex = variableName.indexOf("::");
                if (twoColonsIndex != -1) {
                    suggestedType = variableName.substring(twoColonsIndex + "::".length()).trim();
                    variableName = variableName.substring(0, twoColonsIndex).trim();
                }
                if (variableName.length() == 0) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_MISSING_VARIABLE}));
                }
                if (!DatapoolUtilities.getInstance().isVariableNameValid(variableName)) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_NAME_NOT_VALID}));
                }
                if (variableNames.contains(variableName)) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_NAME_NOT_UNIQUE}));
                }
                variableNames.add(variableName);
                if (suggestedType != null && !DatapoolUtilities.getInstance().isVariableTypeValid(suggestedType)) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_TYPE_NOT_VALID}));
                }
                if (!validateDatapool) continue;
                if (datapool.getVariableIndex(variableName) == -1) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_INVALID_VARIABLE}));
                }
                try {
                    variable = datapool.getVariable(variableNames.size() - 1);
                    if (variableName.equals(variable.getName()) && (suggestedType == null || DatapoolSuggestedTypeChecker.getInstance().isTypeMatch(suggestedType, variable.getSuggestedType()))) continue;
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DatapoolImportWizard_diffVariableInfoWarning}));
                }
                catch (Exception v0) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DatapoolImportWizard_diffVariableInfoWarning}));
                }
            }
            columnCount = variableNames.size();
            if (columnCount == 0) {
                throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_MISSING_VARIABLE}));
            }
            if (columnCount > DatapoolConstants.MAXIMUM_VARIABLE_LIMIT) {
                throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_VARIABLE_LIMIT_EXCEEDED, (Object)DatapoolConstants.MAXIMUM_VARIABLE_LIMIT)}));
            }
            if (variableCount == -1) {
                variableCount = columnCount;
            } else if (columnCount != variableCount) {
                throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_INCONSISTENT_COLUMN_COUNT, (Object)String.valueOf(columnCount))}));
            }
            line = lineReader.readLine();
            ++lineCount;
        }
        equivalenceClassNames = new HashMap<String, Integer>();
        defaultEquivalenceClassName = null;
        emptyLineCount = 0;
        while (line != null) {
            block51: {
                block50: {
                    if (line.trim().length() <= 0) break block50;
                    tokenizer = new CSVTokenizer(line);
                    if (isFirstColumnEquivalenceClassInfo) {
                        rowNumber = null;
                        equivalenceClassName = tokenizer.nextToken().trim();
                        twoColonsIndex = equivalenceClassName.indexOf("::");
                        if (twoColonsIndex != -1) {
                            rowNumber = equivalenceClassName.substring(twoColonsIndex + "::".length()).trim();
                            equivalenceClassName = equivalenceClassName.substring(0, twoColonsIndex).trim();
                        }
                        if (equivalenceClassName.length() == 0) {
                            throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_MISSING_EQUIVALENCE}));
                        }
                        if (!DatapoolUtilities.getInstance().isEquivalenceClassNameValid(equivalenceClassName)) {
                            throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_ROW_GRP_DLG_ERROR_NAME_NOT_VALID}));
                        }
                        if (equivalenceClassNames.containsKey(equivalenceClassName)) {
                            equivalenceClassNames.put(equivalenceClassName, new Integer((Integer)equivalenceClassNames.get(equivalenceClassName) + 1));
                        } else {
                            recordCount = 0;
                            if (validateDatapool) {
                                if (datapool.getEquivalenceClassIndex(equivalenceClassName) == -1) {
                                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_COL_DLG_ERROR_INVALID_EQUIVALENCE}));
                                }
                                equivalenceClass = datapool.getEquivalenceClass(datapool.getEquivalenceClassIndex(equivalenceClassName));
                                if (equivalenceClass != null) {
                                    recordCount = equivalenceClass.getRecordCount();
                                }
                            }
                            equivalenceClassNames.put(equivalenceClassName, new Integer(recordCount));
                            if (defaultEquivalenceClassName == null) {
                                defaultEquivalenceClassName = equivalenceClassName;
                            }
                        }
                        if (emptyLineCount > 0) {
                            equivalenceClassNames.put(defaultEquivalenceClassName, new Integer((Integer)equivalenceClassNames.get(defaultEquivalenceClassName) + emptyLineCount));
                            emptyLineCount = 0;
                        }
                        if (!isReplaceExistingRecords && rowNumber != null) {
                            try {
                                recordIndex = Integer.parseInt(rowNumber);
                                if (recordIndex > (Integer)equivalenceClassNames.get(equivalenceClassName)) {
                                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_INCONSISTENT_ROW_ORDER, (Object)rowNumber)}));
                                }
                                if (validateDatapool && (equivalenceClass = datapool.getEquivalenceClass(datapool.getEquivalenceClassIndex(equivalenceClassName))) != null && recordIndex < equivalenceClass.getRecordCount() && equivalenceClass.getRecord(recordIndex) != null) {
                                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), UiPluginResourceBundle.DATA_CSV_ERROR_RECORD_INDEX_DUP}));
                                }
                            }
                            catch (NumberFormatException v1) {
                                throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_INVALID_ROW_COUNT, (Object)rowNumber)}));
                            }
                        }
                    }
                    columnCount = 0;
                    if (true) ** GOTO lbl112
                }
                ++emptyLineCount;
                break block51;
                do {
                    ++columnCount;
                    tokenizer.nextToken();
lbl112:
                    // 2 sources

                } while (tokenizer.hasMoreTokens());
                if (columnCount > DatapoolConstants.MAXIMUM_VARIABLE_LIMIT) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_VARIABLE_LIMIT_EXCEEDED, (Object)DatapoolConstants.MAXIMUM_VARIABLE_LIMIT)}));
                }
                if (variableCount == -1) {
                    variableCount = columnCount;
                } else if (columnCount != variableCount) {
                    throw new CorruptCSVFileException(NLS.bind((String)UiPluginResourceBundle.DATA_CSV_LINE, (Object[])new String[]{String.valueOf(lineCount), NLS.bind((String)UiPluginResourceBundle.DATA_COL_DLG_ERROR_INCONSISTENT_COLUMN_COUNT, (Object)String.valueOf(columnCount))}));
                }
            }
            line = lineReader.readLine();
            ++lineCount;
        }
        try {
            if (lineReader == null) return true;
            lineReader.close();
            return true;
        }
        catch (IOException v2) {}
        return true;
        catch (FileNotFoundException v3) {
            try {
                throw new CorruptCSVFileException(UiPluginResourceBundle.DATA_COL_DLG_ERROR_MISSING_CSV_FILE);
                catch (IOException v4) {
                    throw new CorruptCSVFileException(UiPluginResourceBundle.DATA_COL_DLG_ERROR_CORRUPT_CSV_FILE);
                }
            }
            catch (Throwable var21_23) {
                try {
                    if (lineReader == null) throw var21_23;
                    lineReader.close();
                    throw var21_23;
                }
                catch (IOException v5) {}
                throw var21_23;
            }
        }
    }

    public void importCSV(IDatapool datapool, String csvFileName, boolean isFirstRowVariableInfo, boolean isFirstColumnEquivalenceClassInfo, String encoding) throws IOException {
        this.importCSV(datapool, csvFileName, isFirstRowVariableInfo, isFirstColumnEquivalenceClassInfo, encoding, -1, -1);
    }

    public void importCSV(IDatapool datapool, String csvFilePath, boolean isFirstRowVariableInfo, boolean isFirstColumnEquivalenceClassInfo, String encoding, int numberOfColumns, int numberOfRows) throws IOException {
        if (datapool != null && csvFilePath != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = encoding != null && encoding.trim().length() > 0 ? new CSVBufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFilePath), encoding.trim())) : new CSVBufferedReader(new InputStreamReader(new FileInputStream(csvFilePath)));
                String line = bufferedReader.readLine();
                int lineCounter = 1;
                if (isFirstRowVariableInfo) {
                    this.createVariablesFromFile(datapool, line, lineCounter, isFirstColumnEquivalenceClassInfo, numberOfColumns);
                    line = bufferedReader.readLine();
                    ++lineCounter;
                } else {
                    this.createVariables(datapool, line, isFirstColumnEquivalenceClassInfo, numberOfColumns);
                }
                int recordCounter = 0;
                while (line != null && (numberOfRows == -1 || recordCounter < numberOfRows)) {
                    this.createRecord(datapool, line, lineCounter, isFirstColumnEquivalenceClassInfo);
                    ++recordCounter;
                    line = bufferedReader.readLine();
                    ++lineCounter;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void appendFromCSV(IDatapool datapool, String csvFilePath, boolean isFirstRowVariableInfo, boolean isFirstColumnEquivalenceClassInfo, String encoding) throws IOException {
        if (datapool != null && csvFilePath != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = encoding != null && encoding.trim().length() > 0 ? new CSVBufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFilePath), encoding.trim())) : new CSVBufferedReader(new InputStreamReader(new FileInputStream(csvFilePath)));
                String line = bufferedReader.readLine();
                int lineCounter = 1;
                if (isFirstRowVariableInfo) {
                    line = bufferedReader.readLine();
                    ++lineCounter;
                }
                while (line != null) {
                    this.createRecord(datapool, line, lineCounter, isFirstColumnEquivalenceClassInfo);
                    line = bufferedReader.readLine();
                    ++lineCounter;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void exportCSV(IDatapool datapool, String csvFilePath, boolean includeVariableInfo, boolean includeEquivalenceClassInfo, boolean includeTags, String encoding) throws IOException {
        if (datapool != null && csvFilePath != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = encoding != null && encoding.trim().length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFilePath), encoding.trim())) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(csvFilePath)));
                if (includeVariableInfo) {
                    this.writeVariables(datapool, bufferedWriter, true, includeEquivalenceClassInfo);
                }
                this.writeRecords(datapool, bufferedWriter, includeEquivalenceClassInfo, includeTags);
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void createVariablesFromFile(IDatapool datapool, String variableString, int lineNumber, boolean ignoreFirst, int numberOfColumns) {
        boolean first = true;
        int counter = 1;
        CSVTokenizer tokenizer = new CSVTokenizer(variableString);
        while (tokenizer.hasMoreTokens() && (numberOfColumns == -1 || counter <= numberOfColumns)) {
            String nameTypePair = tokenizer.nextToken();
            if (ignoreFirst && first) {
                first = false;
                continue;
            }
            ++counter;
            int separatorIndex = nameTypePair.indexOf("::");
            String name = new String();
            String type = new String();
            if (separatorIndex == -1) {
                name = nameTypePair;
            } else {
                name = nameTypePair.substring(0, separatorIndex);
                type = nameTypePair.substring(separatorIndex + 2);
            }
            IDatapoolVariable variable = datapool.constructVariable();
            variable.setName(name);
            IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
            DatapoolSuggestedTypeChecker.getInstance().setVariableType(suggestedType, type);
            variable.setSuggestedType(suggestedType);
            datapool.appendVariable(variable);
        }
    }

    private void createVariables(IDatapool datapool, String varaibleString, boolean ignoreFirst, int numberOfColumns) {
        CSVTokenizer tokenizer = new CSVTokenizer(varaibleString);
        int counter = 1;
        if (ignoreFirst && tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        while (tokenizer.hasMoreTokens() && (numberOfColumns == -1 || counter <= numberOfColumns)) {
            tokenizer.nextToken();
            String name = NLS.bind((String)UiPluginResourceBundle.DATA_VARIABLE_NAME, (Object)String.valueOf(counter));
            IDatapoolVariable variable = datapool.constructVariable();
            variable.setName(name);
            datapool.appendVariable(variable);
            ++counter;
        }
    }

    private void createRecord(IDatapool datapool, String recordString, int lineNumber, boolean useSpecifiedEquivalenceClass) {
        CSVTokenizer tokenizer = new CSVTokenizer(recordString);
        IDatapoolEquivalenceClass equivalenceClass = null;
        int recordIndex = -1;
        if (useSpecifiedEquivalenceClass && tokenizer.hasMoreTokens() && tokenizer.currentToken().trim().length() > 0) {
            int equivalenceClassIndex;
            String equivalenceClassName = tokenizer.nextToken();
            int separatorIndex = equivalenceClassName.indexOf("::");
            if (separatorIndex != -1) {
                try {
                    recordIndex = Integer.parseInt(equivalenceClassName.substring(separatorIndex + "::".length()));
                }
                catch (NumberFormatException numberFormatException) {}
                equivalenceClassName = equivalenceClassName.substring(0, separatorIndex);
            }
            if ((equivalenceClassIndex = datapool.getEquivalenceClassIndex(equivalenceClassName)) == -1) {
                equivalenceClass = datapool.constructEquivalenceClass();
                equivalenceClass.setName(equivalenceClassName);
                datapool.appendEquivalenceClass(equivalenceClass);
            } else {
                equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex);
            }
        } else if (datapool.getEquivalenceClassCount() == 0) {
            equivalenceClass = datapool.constructEquivalenceClass();
            datapool.appendEquivalenceClass(equivalenceClass);
        } else {
            equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(Math.max(0, datapool.getDefaultEquivalenceClassIndex()));
        }
        ArrayList<String> cells = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            cells.add(tokenizer.nextToken());
        }
        IDatapoolRecord record = equivalenceClass.constructRecord((Object[])cells.toArray(new String[cells.size()]));
        int recordCount = equivalenceClass.getRecordCount();
        if (recordIndex > -1 && recordIndex < recordCount && equivalenceClass.getRecord(recordIndex) == null) {
            equivalenceClass.insertRecord(record, recordIndex);
        } else {
            equivalenceClass.appendRecord(record);
        }
    }

    private void writeVariables(IDatapool datapool, BufferedWriter writer, boolean includeTypes, boolean includeEquivalenceClasses) {
        String output = new String();
        int count = datapool.getVariableCount();
        if (count != 0) {
            if (includeEquivalenceClasses) {
                output = output.concat(SEPERATOR);
            }
            int i = 0;
            while (i < count) {
                IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
                String name = variable.getName();
                String separator = new String();
                if (i != count - 1) {
                    separator = SEPERATOR;
                }
                if (includeTypes) {
                    String type = variable.getSuggestedType().getSuggestedClassName();
                    String preprocessedOutput = name.concat("::").concat(type);
                    preprocessedOutput = this.processString(preprocessedOutput);
                    output = output.concat(preprocessedOutput).concat(separator);
                } else {
                    name = this.processString(name);
                    output = output.concat(name).concat(separator);
                }
                ++i;
            }
            output = output.concat(LINEFEED);
        } else {
            output = LINEFEED;
        }
        try {
            writer.write(output);
        }
        catch (IOException iOException) {}
    }

    private void writeRecords(IDatapool datapool, BufferedWriter writer, boolean includeEquivalenceClasses, boolean includeTags) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
            String equivalenceClassName = new String();
            if (includeEquivalenceClasses) {
                equivalenceClassName = equivalenceClass.getName();
                equivalenceClassName = equivalenceClassName.concat("::");
            }
            int j = 0;
            while (j < equivalenceClass.getRecordCount()) {
                IDatapoolRecord record = (IDatapoolRecord)equivalenceClass.getRecord(j);
                if (includeEquivalenceClasses) {
                    String preprocessedOutput = equivalenceClassName.concat(String.valueOf(j));
                    preprocessedOutput = this.processString(preprocessedOutput);
                    output.append(preprocessedOutput).append(SEPERATOR);
                }
                int count = record.getCellCount();
                int k = 0;
                while (k < count) {
                    IDatapoolCell cell = (IDatapoolCell)record.getCell(k);
                    String cellValue = new String();
                    cellValue = includeTags ? cell.getPersistedRepresentation() : cell.getStringValue();
                    output.append(this.processString(cellValue));
                    if (k != count - 1) {
                        output.append(SEPERATOR);
                    }
                    ++k;
                }
                output.append(CSVBufferedReader.LINE_SEPARATOR);
                ++j;
            }
            ++i;
        }
        try {
            writer.write(output.toString());
        }
        catch (IOException iOException) {}
    }

    private String processString(String value) {
        if (value == null) {
            return null;
        }
        if (value.indexOf("\"") > -1) {
            value = value.replaceAll("\"", "\"\"");
            return "\"" + value + "\"";
        }
        if (value.indexOf(SEPERATOR) > -1 || value.indexOf(LINEFEED) > -1 || value.indexOf(CARRIAGE_RETURN) > -1 || value.trim().length() < value.length()) {
            return "\"" + value + "\"";
        }
        return value;
    }
}

