/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.Enumeration;

public class CSVTokenizer
implements Enumeration {
    public static final String COMMA = ",";
    public static final String TWO_DOUBLEQUOTES = "\"\"";
    public static final String DOUBLEQUOTE = "\"";
    private static final String TWOQUOTES_SUB = "\u0000\u0000";
    String input = null;
    String nextToken = null;

    public CSVTokenizer(String input) {
        this.input = input;
        this.setNextToken();
    }

    public String currentToken() {
        return this.nextToken;
    }

    public String nextToken() {
        String returnToken = this.nextToken;
        this.setNextToken();
        return returnToken;
    }

    private void setNextToken() {
        if (this.input == null) {
            this.nextToken = null;
            return;
        }
        if (this.input.startsWith(DOUBLEQUOTE)) {
            this.input = this.input.substring(1);
            String searchString = this.input.replaceAll(TWO_DOUBLEQUOTES, TWOQUOTES_SUB);
            int endQuoteIndex = searchString.indexOf(DOUBLEQUOTE);
            if (endQuoteIndex == -1) {
                this.nextToken = searchString.replaceAll(TWOQUOTES_SUB, DOUBLEQUOTE);
                this.input = null;
            } else {
                int commaIndex = searchString.indexOf(COMMA, endQuoteIndex + 1);
                if (commaIndex == -1) {
                    this.nextToken = searchString.substring(0, endQuoteIndex).replaceAll(TWOQUOTES_SUB, DOUBLEQUOTE);
                    this.nextToken = String.valueOf(this.nextToken) + this.input.substring(endQuoteIndex + 1, this.input.length());
                    this.input = null;
                } else {
                    this.nextToken = searchString.substring(0, endQuoteIndex).replaceAll(TWOQUOTES_SUB, DOUBLEQUOTE);
                    this.nextToken = String.valueOf(this.nextToken) + this.input.substring(endQuoteIndex + 1, commaIndex);
                    this.input = this.input.substring(commaIndex + 1, this.input.length());
                }
            }
        } else {
            int i = this.input.indexOf(COMMA);
            if (i == -1) {
                this.nextToken = this.input;
                this.input = null;
            } else {
                this.nextToken = this.input.substring(0, i);
                this.input = this.input.substring(i + 1, this.input.length());
            }
        }
    }

    public boolean hasMoreTokens() {
        return this.nextToken != null;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public static int countTokens(String string, String token) {
        int tokenCount = 0;
        int tokenIndex = string.indexOf(token);
        while (tokenIndex != -1) {
            ++tokenCount;
            tokenIndex = string.indexOf(token, tokenIndex + token.length());
        }
        return tokenCount;
    }
}

