/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.ArrayList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.DPLVariable;

public class DatapoolUtil {
    private static final DatapoolUtil instance = new DatapoolUtil();

    public static DatapoolUtil getInstance() {
        return instance;
    }

    protected DatapoolUtil() {
    }

    public IDatapoolVariable[] getVariables(IDatapool datapool, String exclusionName) {
        if (datapool == null) {
            return null;
        }
        int variableCount = datapool.getVariableCount();
        ArrayList<IDatapoolVariable> tempList = new ArrayList<IDatapoolVariable>();
        int i = 0;
        while (i < variableCount) {
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
            String variableName = variable.getName();
            if (!variableName.equals(exclusionName)) {
                tempList.add(variable);
            }
            ++i;
        }
        int listSize = tempList.size();
        IDatapoolVariable[] returnList = new IDatapoolVariable[listSize];
        tempList.toArray(returnList);
        return returnList;
    }

    public IDatapoolEquivalenceClass[] getEquivalenceClasses(IDatapool datapool, String exclusionID) {
        if (datapool == null) {
            return null;
        }
        int equivalenceClassCount = datapool.getEquivalenceClassCount();
        ArrayList<IDatapoolEquivalenceClass> tempList = new ArrayList<IDatapoolEquivalenceClass>();
        int i = 0;
        while (i < equivalenceClassCount) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
            String equivalenceClassID = equivalenceClass.getId();
            if (!equivalenceClassID.equals(exclusionID)) {
                tempList.add(equivalenceClass);
            }
            ++i;
        }
        int listSize = tempList.size();
        IDatapoolEquivalenceClass[] returnList = new IDatapoolEquivalenceClass[listSize];
        tempList.toArray(returnList);
        return returnList;
    }

    public String getVariableTypeInfo(IDatapoolVariable variable) {
        if (variable == null) {
            return "";
        }
        if (variable instanceof DPLVariable) {
            return ((DPLVariable)variable).getType();
        }
        String type = new String();
        IDatapoolSuggestedType suggestedType = (IDatapoolSuggestedType)variable.getSuggestedType();
        if (suggestedType != null) {
            String className = suggestedType.getSuggestedClassName();
            if (className != null && className.length() > 0) {
                type = className;
            } else {
                switch (suggestedType.getSuggestedType()) {
                    case 2: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_BOOLEAN;
                        break;
                    }
                    case 1: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_NUMBER;
                        break;
                    }
                    case 3: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_ENUMERATION;
                        break;
                    }
                    case 4: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_COMPLEX;
                        break;
                    }
                    default: {
                        type = IDatapoolSuggestedType.TYPE_DISPLAY_STRING;
                    }
                }
            }
        }
        return type;
    }
}

