/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.util;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;

public class DatapoolUtilities {
    private static final DatapoolUtilities instance = new DatapoolUtilities();
    public static final String DATA_DLG_INVALID_NAME_CHARACTERS = "\t\n\r\"\\',./<>?;:|!@#%^&*()-=+[]{}`~";
    public static final String DATA_DLG_INVALID_TYPE_CHARACTERS = "\t\n\r\"\\' ,/<>?;:|!@#%^&*()-=+[]{}`~";
    public static final String DATA_DLG_INVALID_TYPE_FIRST_CHARACTER = "01234567890";

    public static DatapoolUtilities getInstance() {
        return instance;
    }

    protected DatapoolUtilities() {
    }

    public boolean hasInvalidCharacters(String value, String invalidCharacters) {
        if (invalidCharacters == null) {
            return false;
        }
        int i = 0;
        while (i < invalidCharacters.length()) {
            String character = invalidCharacters.substring(i, i + 1);
            if (value.lastIndexOf(character) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEquivalenceClassNameUnique(IDatapool datapool, String name, IDatapoolEquivalenceClass excludeEquivalenceClass) {
        if (datapool == null) {
            return true;
        }
        int i = 0;
        while (i < datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)datapool.getEquivalenceClass(i);
            if (!equivalenceClass.equals(excludeEquivalenceClass) && name.equals(equivalenceClass.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEquivalenceClassNameValid(String name) {
        if (name.length() == 0) {
            return false;
        }
        return !this.hasInvalidCharacters(name, DATA_DLG_INVALID_NAME_CHARACTERS);
    }

    public boolean isVariableNameUnique(IDatapool datapool, String name, IDatapoolVariable excludeVariable) {
        if (datapool == null) {
            return true;
        }
        int i = 0;
        while (i < datapool.getVariableCount()) {
            IDatapoolVariable variable = (IDatapoolVariable)datapool.getVariable(i);
            if (!variable.equals(excludeVariable) && name.equals(variable.getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isVariableNameValid(String name) {
        if (name.length() == 0) {
            return false;
        }
        return !this.hasInvalidCharacters(name, DATA_DLG_INVALID_NAME_CHARACTERS);
    }

    public boolean isVariableTypeValid(String type) {
        if (type.length() == 0) {
            return true;
        }
        if (this.hasInvalidCharacters(type.substring(0, 1), DATA_DLG_INVALID_TYPE_FIRST_CHARACTER)) {
            return false;
        }
        return !this.hasInvalidCharacters(type, DATA_DLG_INVALID_TYPE_CHARACTERS);
    }
}

