/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.dialog;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class EObjectResourceLabelProvider
extends LabelProvider {
    private Hashtable ovelayCache;
    private boolean useImages;
    private Image image;
    private Map imageMap;

    public EObjectResourceLabelProvider(boolean useImages, Image image) {
        this.useImages = useImages;
        this.image = image;
        this.ovelayCache = new Hashtable();
        this.imageMap = new HashMap();
    }

    public Image getImage(Object element) {
        if (!this.useImages || element == null) {
            return null;
        }
        if (element instanceof IAdaptable) {
            IWorkbenchAdapter adapter;
            if (this.imageMap == null || this.imageMap.isEmpty()) {
                this.imageMap = new HashMap();
            }
            if ((adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                ImageDescriptor myImageDesc = adapter.getImageDescriptor(element);
                Image myImage = (Image)this.imageMap.get(myImageDesc);
                if (myImage == null) {
                    myImage = myImageDesc.createImage();
                    this.imageMap.put(myImageDesc, myImage);
                }
                return myImage;
            }
        }
        if (this.image != null) {
            return this.image;
        }
        return null;
    }

    public String getText(Object element) {
        IWorkbenchAdapter adapter;
        if (element == null) {
            return "";
        }
        String text = null;
        if (element instanceof EObject) {
            text = element instanceof CMNNamedElement ? ((CMNNamedElement)element).getName() : EMFUtil.getWorkspaceFile((EObject)((EObject)element)).getName();
        } else if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
            text = adapter.getLabel(element);
        }
        if (text == null) {
            text = element.toString();
        }
        return text;
    }

    public void dispose() {
        if (this.ovelayCache != null) {
            for (Image image : this.ovelayCache.values()) {
                image.dispose();
            }
            this.ovelayCache.clear();
        }
        if (this.imageMap != null) {
            for (Image this.image : this.imageMap.values()) {
                this.image.dispose();
            }
            this.imageMap.clear();
        }
        super.dispose();
    }
}

