/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.extension.TestSuiteEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.TestObjectiveSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorPartExtended;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TestContextOverview
extends EditorForm {
    protected TestContextOverviewContribution tsoContributor;
    private TestSuiteEditorExtension editor;
    private NamedElementSection genericInfoSection;
    private TestObjectiveSection testObjectiveSection;
    private Object[] leftSections;
    private Object[] rightSections;
    private boolean hideGenericInformation = false;
    private boolean hideTestObjective = false;

    public TestContextOverview(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        super(baseEditorExtension, widgetFactory);
        this.editor = (TestSuiteEditorExtension)baseEditorExtension;
        this.setHeadingText(UiPluginResourceBundle.W_OVERVIEW);
    }

    public TestContextOverview(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory, TestContextOverviewContribution testContextOverviewContributor) {
        super(baseEditorExtension, widgetFactory);
        this.editor = (TestSuiteEditorExtension)baseEditorExtension;
        this.tsoContributor = testContextOverviewContributor;
        this.tsoContributor.setOverviewForm(this);
        this.setHeadingText(UiPluginResourceBundle.W_OVERVIEW);
    }

    public void dispose() {
        int i = 0;
        while (this.leftSections != null && i < this.leftSections.length) {
            if (this.leftSections[i] != null && this.leftSections[i] instanceof IDisposable) {
                ((IDisposable)this.leftSections[i]).dispose();
                this.leftSections[i] = null;
            }
            ++i;
        }
        i = 0;
        while (this.rightSections != null && i < this.rightSections.length) {
            if (this.rightSections[i] != null && this.rightSections[i] instanceof IDisposable) {
                ((IDisposable)this.rightSections[i]).dispose();
                this.rightSections[i] = null;
            }
            ++i;
        }
        if (this.genericInfoSection != null && this.genericInfoSection instanceof IDisposable) {
            this.genericInfoSection.dispose();
            this.genericInfoSection = null;
        }
        if (this.testObjectiveSection != null && this.testObjectiveSection instanceof IDisposable) {
            this.testObjectiveSection.dispose();
            this.testObjectiveSection = null;
        }
        super.dispose();
    }

    protected TPFTestSuite getTestContext() {
        return this.editor.getTestSuite();
    }

    public Control createControl() {
        Control control = super.createControl();
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), String.valueOf(UiPlugin.getID()) + ".tstf0001");
        return control;
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        if (this.tsoContributor == null || this.tsoContributor != null && this.tsoContributor.hideGenericInformation()) {
            this.hideGenericInformation = true;
        } else {
            Control control = this.createGenericInformation(leftColumn);
            control.setLayoutData((Object)new GridData(770));
            UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(control, String.valueOf(UiPlugin.getID()) + ".tstf0004");
        }
        if (this.tsoContributor == null || this.tsoContributor != null && this.tsoContributor.hideTestObjectiveSection()) {
            this.hideTestObjective = true;
        } else {
            this.createTestObjectiveSection(leftColumn);
        }
        if (this.tsoContributor != null) {
            Control control;
            this.leftSections = this.tsoContributor.createLeftSections((IEditorExtension)this.editor);
            this.rightSections = this.tsoContributor.createRightSections((IEditorExtension)this.editor);
            int i = 0;
            while (i < this.leftSections.length) {
                if (this.leftSections[i] instanceof FormSection) {
                    this.registerSection((FormSection)((Object)this.leftSections[i]));
                    control = ((FormSection)((Object)this.leftSections[i])).createControl(leftColumn, this.factory);
                    control.setLayoutData((Object)new GridData(770));
                }
                ++i;
            }
            i = 0;
            while (i < this.rightSections.length) {
                if (this.rightSections[i] instanceof FormSection) {
                    this.registerSection((FormSection)((Object)this.rightSections[i]));
                    control = ((FormSection)((Object)this.rightSections[i])).createControl(rightColumn, this.factory);
                    control.setLayoutData((Object)new GridData(770));
                }
                ++i;
            }
        }
    }

    protected Control createTestObjectiveSection(Composite arg) {
        Control retControl = null;
        this.testObjectiveSection = new TestObjectiveSection(this.getBaseEditorExtension(), this.getWidgetFactory());
        this.testObjectiveSection.setCollapsable(true);
        this.testObjectiveSection.setHeaderText(UiPluginResourceBundle.L_TEST_OBJECTIVE);
        this.testObjectiveSection.setDescription(UiPluginResourceBundle.L_TEST_OBJECTIVE_DSC);
        retControl = this.testObjectiveSection.createControl(arg, this.getWidgetFactory());
        return retControl;
    }

    protected Control createGenericInformation(Composite arg) {
        this.genericInfoSection = new NamedElementSection(this){
            private StyledText typeText;
            private StyledText fileText;

            protected void addCenterControls(Composite parent, FormWidgetFactory formWidgetFactory) {
                if (TestContextOverview.this.tsoContributor != null) {
                    TestContextOverview.this.tsoContributor.addCenterGenericInformation(parent, TestContextOverview.this.getWidgetFactory());
                }
            }

            protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
                Composite detailComposite = TestContextOverview.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                detailComposite.setLayout((Layout)gridLayout);
                detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                WidgetFactory detailWidgetFactory = TestContextOverview.this.getWidgetFactory();
                detailWidgetFactory.createLabel(detailComposite, UiPluginResourceBundle.L_TYPE);
                this.typeText = detailWidgetFactory.createStyledText(detailComposite, 65540);
                this.typeText.setEnabled(false);
                this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                detailWidgetFactory.createLabel(detailComposite, UiPluginResourceBundle.L_FILE);
                this.fileText = detailWidgetFactory.createStyledText(detailComposite, 65540);
                this.fileText.setEnabled(false);
                this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.typeText, String.valueOf(UiPlugin.getID()) + ".tstf0003");
                UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)this.fileText, String.valueOf(UiPlugin.getID()) + ".tstf0002");
                if (TestContextOverview.this.tsoContributor != null) {
                    TestContextOverview.this.tsoContributor.addSouthGenericInformation(detailComposite, TestContextOverview.this.getWidgetFactory());
                }
            }

            public void setInput(Object object) {
                String value;
                String name;
                super.setInput(object);
                if (this.getNameTextField() != null && (name = this.getNameTextField().getText()) != null && !name.equals("")) {
                    ((IHyadesEditorPartExtended)TestContextOverview.this.getBaseEditorExtension().getHyadesEditorPart()).setEditorTitle(name);
                }
                if ((value = TestContextOverview.this.getTestContext().getType()) != null) {
                    IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                this.fileText.setText(EMFUtil.getFilePath((EObject)TestContextOverview.this.getTestContext()));
            }
        };
        this.registerSection(this.genericInfoSection);
        this.genericInfoSection.setHeaderText(UiPluginResourceBundle.EDT_GENERAL_INFO);
        this.genericInfoSection.setDescription(UiPluginResourceBundle.EDT_GENERAL_DSC);
        Control retControl = this.genericInfoSection.createControl(arg, this.getWidgetFactory());
        return retControl;
    }

    public void load() {
        if (!this.hideGenericInformation) {
            this.genericInfoSection.setInput(this.getTestContext());
        }
        if (!this.hideTestObjective) {
            this.testObjectiveSection.setInput(this.getTestContext());
        }
        if (this.tsoContributor != null) {
            this.tsoContributor.setTestContext(this.getTestContext());
            if (!this.hideGenericInformation) {
                this.tsoContributor.initializeSouthGenericInformation();
                this.tsoContributor.initializeCenterGenericInformation();
            }
            this.tsoContributor.initializeLeftSections(this.leftSections);
            this.tsoContributor.initializeRightSections(this.rightSections);
        }
    }

    public boolean activated() {
        return true;
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.getTestContext());
    }
}

