/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class EObjectContainerContentProvider
extends AdapterImpl
implements ITreeContentProvider {
    private EStructuralFeature eStructuralFeature;
    private EObject container;
    private Viewer viewer;
    private EditorForm editorForm;
    private Map eStructuralFeatureByClass;

    public EObjectContainerContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
        this.eStructuralFeature = eStructuralFeature;
        this.editorForm = editorForm;
    }

    public void dispose() {
        if (this.container != null) {
            this.container.eAdapters().remove((Object)this);
            Object value = this.container.eGet(this.eStructuralFeature);
            if (value instanceof Collection) {
                EMFUtil.removeAdapter(((Collection)value).iterator(), (Adapter)this);
            } else if (value != null) {
                ((Notifier)value).eAdapters().remove((Object)this);
            }
            this.container = null;
        }
        this.viewer = null;
        this.eStructuralFeature = null;
        this.editorForm = null;
        if (this.eStructuralFeatureByClass != null) {
            this.eStructuralFeatureByClass.clear();
        }
    }

    protected EObject getContainer() {
        return this.container;
    }

    public void registerParent(Class cls, EStructuralFeature esf) {
        if (this.eStructuralFeatureByClass == null) {
            this.eStructuralFeatureByClass = new HashMap();
        }
        this.eStructuralFeatureByClass.put(cls, esf);
    }

    public void deregisterParent(Class cls) {
        if (this.eStructuralFeatureByClass != null) {
            this.eStructuralFeatureByClass.remove(cls);
        }
    }

    protected Object getRegisteredParentChild(Object parent) {
        if (this.eStructuralFeatureByClass != null) {
            for (Map.Entry entry : this.eStructuralFeatureByClass.entrySet()) {
                if (!((Class)entry.getKey()).isInstance(parent)) continue;
                if (parent instanceof EObject) {
                    return ((EObject)parent).eGet((EStructuralFeature)entry.getValue());
                }
                return null;
            }
        }
        return null;
    }

    public void inputChanged(Viewer theViewer, Object oldInput, Object newInput) {
        this.viewer = theViewer;
        if (this.container != null) {
            this.container.eAdapters().remove((Object)this);
            Object value = this.container.eGet(this.eStructuralFeature);
            this.deregisterInputAdapters(this.container, value);
            this.container = null;
        }
        if (newInput instanceof EObject) {
            EObject eObject = (EObject)newInput;
            if (this.eStructuralFeature.eContainer() == eObject.eClass()) {
                this.container = eObject;
                this.container.eAdapters().add((Object)this);
                this.registerInputAdapters(eObject, this.container.eGet(this.eStructuralFeature));
            }
        }
    }

    protected Viewer getViewer() {
        return this.viewer;
    }

    protected void deregisterInputAdapters(EObject oldInput, Object value) {
        if (value instanceof Collection) {
            EMFUtil.removeAdapter(((Collection)value).iterator(), (Adapter)this);
        } else if (value != null) {
            ((Notifier)value).eAdapters().remove((Object)this);
        }
    }

    protected void registerInputAdapters(EObject newInput, Object value) {
        if (value instanceof List) {
            EMFUtil.addAdapter(((List)value).iterator(), (Adapter)this);
        } else if (value != null) {
            ((Notifier)value).eAdapters().add((Object)this);
        }
    }

    public Object getParent(Object element) {
        if (this.container == element) {
            return null;
        }
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.container == null) {
            return new Object[0];
        }
        if (this.eStructuralFeature.isMany()) {
            ArrayList elements = new ArrayList();
            List list = (List)this.container.eGet(this.eStructuralFeature);
            for (Object next : list) {
                if (!(next instanceof EObject) || ((EObject)next).eIsProxy()) continue;
                elements.add(next);
            }
            return elements.toArray();
        }
        Object element = this.container.eGet(this.eStructuralFeature);
        if (element instanceof EObject && !((EObject)element).eIsProxy()) {
            return new Object[]{element};
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        if (this.container == null) {
            return false;
        }
        if (!this.eStructuralFeature.isMany()) {
            return false;
        }
        if (this.container == element) {
            List values = (List)this.container.eGet(this.eStructuralFeature);
            return !values.isEmpty();
        }
        Object child = this.getRegisteredParentChild(element);
        return child != null;
    }

    public Object[] getChildren(Object parentElement) {
        Object child = this.getRegisteredParentChild(parentElement);
        if (child != null) {
            if (child instanceof Collection) {
                Iterator it = ((Collection)child).iterator();
                ArrayList children = new ArrayList();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!(next instanceof EObject) || ((EObject)next).eIsProxy()) continue;
                    children.add(next);
                }
                return children.toArray();
            }
            if (child instanceof EObject && !((EObject)child).eIsProxy()) {
                return new Object[]{child};
            }
        }
        return new Object[0];
    }

    public void notifyChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                return;
            }
        }
        this.editorForm.getBaseEditorExtension().markDirty();
        this.adjustModel(msg);
        this.adjustAdapter(msg);
        this.updateViewer(msg);
    }

    protected void adjustModel(Notification msg) {
    }

    protected boolean shouldAdjustAdapter(Notification msg) {
        return msg.getNotifier() == this.container && msg.getFeature() == this.eStructuralFeature;
    }

    protected void adjustAdapter(Notification msg) {
        if (this.shouldAdjustAdapter(msg)) {
            switch (msg.getEventType()) {
                case 3: {
                    ((Notifier)msg.getNewValue()).eAdapters().add((Object)this);
                    break;
                }
                case 5: {
                    EMFUtil.addAdapter(((Collection)msg.getNewValue()).iterator(), (Adapter)this);
                    break;
                }
                case 4: {
                    ((Notifier)msg.getOldValue()).eAdapters().remove((Object)this);
                    break;
                }
                case 6: {
                    EMFUtil.removeAdapter(((Collection)msg.getOldValue()).iterator(), (Adapter)this);
                }
            }
        }
    }

    protected boolean shouldUpdateViewer(Notification msg) {
        return msg.getFeature() == this.eStructuralFeature;
    }

    protected void updateViewer(Notification msg) {
        if (this.getViewer() == null) {
            return;
        }
        if (!(this.getViewer() instanceof StructuredViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (msg.getNotifier() != this.container) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: {
                    this.attributeChanged(msg);
                    return;
                }
            }
        }
        if (!(this.getViewer() instanceof TreeViewer)) {
            this.getViewer().refresh();
            return;
        }
        if (this.shouldUpdateViewer(msg)) {
            Object parent = null;
            switch (msg.getEventType()) {
                case 3: {
                    parent = this.getParent(msg.getNewValue());
                    if (parent == null) {
                        parent = this.getViewer().getInput();
                    }
                    ((TreeViewer)this.getViewer()).add(parent, msg.getNewValue());
                    this.getViewer().setSelection((ISelection)new StructuredSelection(msg.getNewValue()), true);
                    break;
                }
                case 5: {
                    Object[] addedObjects = ((Collection)msg.getNewValue()).toArray();
                    parent = this.getParent(addedObjects[0]);
                    if (parent == null) {
                        parent = this.getViewer().getInput();
                    }
                    ((TreeViewer)this.getViewer()).add(parent, addedObjects);
                    this.getViewer().setSelection((ISelection)new StructuredSelection(addedObjects), true);
                    break;
                }
                case 4: {
                    ((TreeViewer)this.getViewer()).remove(msg.getOldValue());
                    Object value = ((EObject)msg.getNotifier()).eGet((EStructuralFeature)msg.getFeature());
                    if (value instanceof List) {
                        List values = (List)value;
                        if (values.isEmpty()) {
                            this.getViewer().getControl().setFocus();
                            break;
                        }
                        int position = msg.getPosition();
                        position = position < values.size() ? position : values.size() - 1;
                        this.getViewer().setSelection((ISelection)new StructuredSelection(values.get(position)), true);
                        break;
                    }
                    this.getViewer().getControl().setFocus();
                    break;
                }
                case 6: {
                    ((TreeViewer)this.getViewer()).remove(((Collection)msg.getOldValue()).toArray());
                    this.getViewer().getControl().setFocus();
                    break;
                }
                case 7: {
                    this.getViewer().refresh();
                }
            }
        }
    }

    protected void attributeChanged(Notification msg) {
        ((StructuredViewer)this.getViewer()).update(msg.getNotifier(), null);
    }
}

