/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.editor.form.util.EObjectTableContentProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StructuredViewerSection;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ExtensibleEObjectTableSection
extends StructuredViewerSection
implements ISelectionChangedListener,
IDoubleClickListener {
    private int tableStyle = 65538;
    private int numColumns;
    private IAction[] buttonActions;
    private EditorForm editorForm;
    private EStructuralFeature eStructuralFeature;
    private IContentProvider tableContentProvider;
    private ITableLabelProvider tableLabelProvider;

    public ExtensibleEObjectTableSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, int numOfColumns, IAction[] theButtonActions) {
        super(editorForm);
        this.editorForm = editorForm;
        this.eStructuralFeature = eStructuralFeature;
        this.numColumns = numOfColumns;
        this.buttonActions = theButtonActions;
        String[] buttonLabels = new String[this.buttonActions.length];
        int i = 0;
        while (i < this.buttonActions.length) {
            buttonLabels[i] = this.buttonActions[i].getText();
            ++i;
        }
        super.setButtonLabels(buttonLabels);
    }

    public void dispose() {
        this.eStructuralFeature = null;
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                this.buttonActions[i] = null;
            }
            ++i;
        }
        super.dispose();
    }

    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        StructuredViewerPart tablePart = new StructuredViewerPart(buttonLabels){

            protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
                Table table = new Table(parent, style);
                table.setLinesVisible(true);
                table.setHeaderVisible(false);
                int i = 0;
                while (i < ExtensibleEObjectTableSection.this.numColumns) {
                    TableColumn column = new TableColumn(table, 0);
                    column.setResizable(true);
                    ++i;
                }
                table.addControlListener(new ControlListener(){

                    public void controlMoved(ControlEvent e) {
                    }

                    public void controlResized(ControlEvent e) {
                        if (e.getSource() instanceof Table) {
                            Table table = (Table)e.getSource();
                            int width = table.getSize().x;
                            int gridLineWidth = table.getGridLineWidth();
                            TableColumn[] columns = table.getColumns();
                            if (columns.length == 3) {
                                columns[0].setWidth(width * 2 / 5);
                                columns[1].setWidth(width / 5);
                                columns[2].setWidth(width * 2 / 5 + gridLineWidth);
                            } else {
                                int i = 0;
                                while (i < columns.length) {
                                    columns[i].setWidth(width / columns.length);
                                    ++i;
                                }
                            }
                        }
                    }
                });
                parent.pack();
                TableViewer tableViewer = new TableViewer(table);
                tableViewer.addSelectionChangedListener((ISelectionChangedListener)ExtensibleEObjectTableSection.this);
                tableViewer.addDoubleClickListener((IDoubleClickListener)ExtensibleEObjectTableSection.this);
                return tableViewer;
            }

            public void buttonSelected(Button button, int index) {
                ExtensibleEObjectTableSection.this.buttonSelected(index);
                if (ExtensibleEObjectTableSection.this.isHandlingDefaultButton()) {
                    button.getShell().setDefaultButton(null);
                }
            }
        };
        return tablePart;
    }

    protected void buttonSelected(int index) {
        if (!this.isReadOnly() && index >= 0 && index < this.buttonActions.length) {
            this.buttonActions[index].run();
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.setFormWidgetFactory(factory);
        Composite container = this.createClientContainer(parent, 2, this.getFormWidgetFactory());
        this.createViewerPartControl(container, this.getTableStyle(), 2, this.getFormWidgetFactory());
        this.getTableViewer().getControl().setFocus();
        this.adjustClient(parent);
        this.getFormWidgetFactory().paintBordersFor(container);
        return container;
    }

    protected void adjustClient(Composite parent) {
        this.getTableViewer().setContentProvider(this.getContentProvider());
        this.getTableViewer().setLabelProvider(this.getLabelProvider());
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                this.getTablePart().setButtonEnabled(i, this.buttonActions[i].isEnabled());
            }
            ++i;
        }
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
        if (this.buttonActions == null || this.buttonActions.length < 1) {
            return;
        }
        int i = 0;
        while (i < this.buttonActions.length) {
            if (this.buttonActions[i] != null) {
                if (this.buttonActions[i] instanceof SelectionListenerAction) {
                    ((SelectionListenerAction)this.buttonActions[i]).selectionChanged(structuredSelection);
                }
                this.getTablePart().setButtonEnabled(i, this.buttonActions[i].isEnabled());
            }
            ++i;
        }
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.tableContentProvider = contentProvider;
    }

    protected IContentProvider getContentProvider() {
        if (this.tableContentProvider == null) {
            this.tableContentProvider = new EObjectTableContentProvider(this.editorForm, this.eStructuralFeature);
        }
        return this.tableContentProvider;
    }

    protected EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public IBaseLabelProvider getLabelProvider() {
        if (this.tableLabelProvider == null) {
            return new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class);
        }
        return this.tableLabelProvider;
    }

    public void setLabelProvider(ITableLabelProvider provider) {
        this.tableLabelProvider = provider;
    }

    public void setTableStyle(int tableStyle) {
        this.tableStyle = tableStyle;
    }

    public int getTableStyle() {
        return this.tableStyle;
    }

    public StructuredViewerPart getTablePart() {
        return this.getViewerPart();
    }

    public TableViewer getTableViewer() {
        return (TableViewer)this.getTablePart().getViewer();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged((IStructuredSelection)event.getSelection());
    }

    public void doubleClick(DoubleClickEvent event) {
        if (!this.isReadOnly()) {
            this.handleDoubleClick((IStructuredSelection)event.getSelection());
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        return element.toString();
    }
}

