/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementLink;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NamedElementsSection
extends FormSection
implements IDisposable {
    protected IEditorExtension editorExtension;
    protected int destinationPage;
    private String moreButtonText;
    private String moreButtonToolTip;
    protected FormWidgetFactory factory;
    protected Composite hyperlinksParent;
    private NamedElementListAdapter adapter;

    public NamedElementsSection(IEditorExtension editorExtension, int destinationPage) {
        this.editorExtension = editorExtension;
        this.destinationPage = destinationPage;
        this.moreButtonText = UiPluginResourceBundle.ACT_MORE;
        this.moreButtonToolTip = UiPluginResourceBundle.ACT_MORE;
    }

    public void dispose() {
        this.editorExtension = null;
        this.factory = null;
        this.hyperlinksParent = null;
        if (this.adapter != null) {
            if (this.adapter.getTarget() != null) {
                this.adapter.getTarget().eAdapters().remove((Object)this.adapter);
            }
            this.adapter.dispose();
        }
        super.dispose();
    }

    public void setMoreButtonToolTip(String text) {
        this.moreButtonToolTip = text == null ? UiPluginResourceBundle.ACT_MORE : text;
    }

    public void setMoreButtonText(String text) {
        this.moreButtonText = text == null ? UiPluginResourceBundle.ACT_MORE : text;
    }

    public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory) {
        this.factory = formWidgetFactory;
        Composite container = formWidgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        container.setLayoutData((Object)GridDataUtil.createFill());
        this.hyperlinksParent = formWidgetFactory.createComposite(container);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 2;
        this.hyperlinksParent.setLayout((Layout)gridLayout);
        this.hyperlinksParent.setLayoutData((Object)GridDataUtil.createFill());
        this.hyperlinksParent.getAccessible().addAccessibleListener((AccessibleListener)this);
        Composite buttonContainer = formWidgetFactory.createComposite(container);
        buttonContainer.setLayoutData((Object)new GridData(1040));
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        buttonContainer.setLayout((Layout)gridLayout);
        Button moreButton = formWidgetFactory.createButton(buttonContainer, this.moreButtonText, 8);
        moreButton.setLayoutData((Object)new GridData(130));
        moreButton.setToolTipText(this.moreButtonToolTip);
        moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedElementsSection.this.editorExtension.getHyadesEditorPart().setActivePage(NamedElementsSection.this.destinationPage);
            }
        });
        return container;
    }

    public void initialize(EObject container, EStructuralFeature namedElementFeature, String statusLinePrefix) {
        if (!CommonPackage.eINSTANCE.getCMNNamedElement().isSuperTypeOf((EClass)namedElementFeature.getEType())) {
            return;
        }
        if (!namedElementFeature.isMany()) {
            return;
        }
        this.adapter = new NamedElementListAdapter(namedElementFeature, statusLinePrefix);
        container.eAdapters().add((Object)this.adapter);
        this.adapter.setTarget((Notifier)container);
        this.adapter.refreshComposite(container);
    }

    public void initialize(EObject container, EStructuralFeature namedElementFeature, String statusLinePrefix, ILabelProvider labelProvider) {
        if (!CommonPackage.eINSTANCE.getCMNNamedElement().isSuperTypeOf((EClass)namedElementFeature.getEType())) {
            return;
        }
        if (!namedElementFeature.isMany()) {
            return;
        }
        this.adapter = new NamedElementListAdapter(namedElementFeature, statusLinePrefix);
        this.adapter.setLabelProvider(labelProvider);
        container.eAdapters().add((Object)this.adapter);
        this.adapter.setTarget((Notifier)container);
        this.adapter.refreshComposite(container);
    }

    public Control createControl(Composite parent, FormWidgetFactory formWidgetFactory, String headerText, String headerDescription) {
        this.setCollapsable(true);
        this.setHeaderText(headerText);
        this.setDescription(headerDescription);
        Control control = this.createControl(parent, formWidgetFactory);
        control.setLayoutData((Object)new GridData(1810));
        return control;
    }

    private class NamedElementListAdapter
    extends AdapterImpl
    implements IDisposable {
        private EStructuralFeature feature;
        private String statusLinePrefix;
        private ILabelProvider labelProvider;

        public NamedElementListAdapter(EStructuralFeature feature, String statusLinePrefix) {
            this.feature = feature;
            this.statusLinePrefix = statusLinePrefix;
        }

        public void dispose() {
            this.feature = null;
            this.setTarget(null);
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() != this.feature) {
                return;
            }
            switch (msg.getEventType()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.refreshComposite((EObject)msg.getNotifier());
                }
            }
        }

        protected void refreshComposite(EObject notifier) {
            this.disposeChildren(NamedElementsSection.this.hyperlinksParent);
            EList namedElements = (EList)notifier.eGet(this.feature);
            for (CMNNamedElement element : namedElements) {
                if (element.eIsProxy()) continue;
                NamedElementLink link = new NamedElementLink(NamedElementsSection.this.editorExtension, NamedElementsSection.this.destinationPage);
                link.setHoverMessagePrefix(this.statusLinePrefix);
                link.setLabelProvider(this.labelProvider);
                link.create(NamedElementsSection.this.factory, NamedElementsSection.this.hyperlinksParent, element);
            }
            NamedElementsSection.this.hyperlinksParent.pack(true);
            Composite parent = NamedElementsSection.this.hyperlinksParent.getParent();
            parent.setSize(parent.computeSize(parent.getSize().x, -1));
            parent.getParent().setSize(parent.getParent().computeSize(parent.getParent().getSize().x, -1));
        }

        protected void disposeChildren(Composite parent) {
            Control[] children = parent.getChildren();
            int i = 0;
            int maxi = children.length;
            while (i < maxi) {
                children[i].dispose();
                ++i;
            }
        }

        public void setLabelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
        }
    }
}

