/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class WidgetFactory
extends FormWidgetFactory
implements IDisposable {
    public WidgetFactory() {
        this(Display.getCurrent());
    }

    public WidgetFactory(Display display) {
        super(display);
    }

    public StyledText createStyledText(Composite parent, int style) {
        try {
            StyledText styledText = new StyledText(parent, style);
            styledText.setBackground(this.getBackgroundColor());
            styledText.setForeground(this.getForegroundColor());
            this.addEditPopupMenu(styledText);
            return styledText;
        }
        catch (Throwable t) {
            UiPlugin.logError(t);
            return null;
        }
    }

    public StyledText createStyledText(Composite parent, int style, final String accessibleName) {
        StyledText text = this.createStyledText(parent, style);
        text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = accessibleName;
            }
        });
        return text;
    }

    public Menu addEditPopupMenu(StyledText text) {
        try {
            Menu menu = new Menu((Control)text);
            text.setMenu(menu);
            MenuItem cutItem = new MenuItem(menu, 0);
            cutItem.setText(UiPluginResourceBundle.command_Cut);
            cutItem.setData((Object)text);
            cutItem.setEnabled(text.isEnabled() && text.getEditable());
            cutItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        ((StyledText)obj).cut();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem copyItem = new MenuItem(menu, 0);
            copyItem.setText(UiPluginResourceBundle.command_Copy);
            copyItem.setData((Object)text);
            copyItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        ((StyledText)obj).copy();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem pasteItem = new MenuItem(menu, 0);
            pasteItem.setText(UiPluginResourceBundle.command_Paste);
            pasteItem.setData((Object)text);
            pasteItem.setEnabled(text.isEnabled() && text.getEditable());
            pasteItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        ((StyledText)obj).paste();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            new MenuItem(menu, 2);
            MenuItem deleteItem = new MenuItem(menu, 0);
            deleteItem.setText(UiPluginResourceBundle.command_Delete);
            deleteItem.setData((Object)text);
            deleteItem.setEnabled(text.isEnabled() && text.getEditable());
            deleteItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        StyledText styledText = (StyledText)obj;
                        styledText.invokeAction(127);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem selectAllItem = new MenuItem(menu, 0);
            selectAllItem.setText(UiPluginResourceBundle.command_SelectAll);
            selectAllItem.setData((Object)text);
            selectAllItem.setEnabled(text.isEnabled() && text.getEditable());
            selectAllItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        StyledText styledText = (StyledText)obj;
                        styledText.setSelection(0, styledText.getText().length());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            menu.addListener(22, new Listener(){

                public void handleEvent(Event event) {
                    MenuItem[] menuItems = ((Menu)event.widget).getItems();
                    int i = 0;
                    while (i < menuItems.length) {
                        MenuItem item = menuItems[i];
                        Object obj = item.getData();
                        if (obj != null && obj instanceof StyledText) {
                            if (item.getText().equals(UiPluginResourceBundle.command_SelectAll)) {
                                item.setEnabled(((StyledText)obj).isEnabled() && ((StyledText)obj).getEditable() && ((StyledText)obj).getCharCount() > 0);
                            } else if (item.getText().equals(UiPluginResourceBundle.command_Paste)) {
                                Clipboard clip = new Clipboard(Display.getCurrent());
                                if (clip.getContents((Transfer)TextTransfer.getInstance()) != null && clip.getContents((Transfer)TextTransfer.getInstance()).toString().length() > 0) {
                                    item.setEnabled(true);
                                } else {
                                    item.setEnabled(false);
                                }
                            } else {
                                item.setEnabled(((StyledText)obj).isEnabled() && ((StyledText)obj).getEditable() && ((StyledText)obj).getSelectionCount() > 0);
                            }
                        }
                        ++i;
                    }
                }
            });
            return menu;
        }
        catch (Throwable t) {
            UiPlugin.logError(t);
            return null;
        }
    }

    public CCombo createCCombo(Composite parent, int style) {
        try {
            CCombo combo = new CCombo(parent, style);
            combo.setBackground(this.getBackgroundColor());
            combo.setForeground(this.getForegroundColor());
            return combo;
        }
        catch (Throwable t) {
            UiPlugin.logError(t);
            return null;
        }
    }
}

