/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.actions;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.forms.actions.ExpandTreeAction;
import org.eclipse.hyades.test.ui.forms.actions.TreeSelectionAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;

public class CollapseTreeAction
extends TreeSelectionAction {
    private ExpandTreeAction expandAction;

    public CollapseTreeAction(String text, TreeViewer treeViewer) {
        super(text, treeViewer);
        this.setToolTipText(UiPluginResourceBundle.TestLogViewer_CollapseSelection);
        this.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", "collapseall.gif"));
        this.setDisabledImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("d", "collapseall.gif"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        if (!selection.isEmpty()) {
            Object element = selection.getFirstElement();
            if (this.getViewer().getExpandedState(element)) {
                return true;
            }
        }
        return false;
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        if (event.getElement() == ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement()) {
            this.setEnabled(false);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        if (event.getElement() == ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement()) {
            this.setEnabled(true);
        }
    }

    public void setExpandAction(ExpandTreeAction expandAction) {
        this.expandAction = expandAction;
    }

    public void run() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        if (structuredSelection != null && !structuredSelection.isEmpty()) {
            this.getViewer().collapseToLevel(structuredSelection.getFirstElement(), -1);
            this.setEnabled(false);
            if (this.expandAction != null) {
                this.expandAction.setEnabled(true);
            }
        }
    }
}

