/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.actions;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.forms.actions.VerdictTypesPullDownAction;
import org.eclipse.hyades.test.ui.forms.base.IVerdictTypeSelectionListener;
import org.eclipse.hyades.test.ui.forms.util.ITestLogVerdictTraversal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.SelectionListenerAction;

public class VerdictNavigationAction
extends SelectionListenerAction
implements IVerdictTypeSelectionListener {
    protected ITestLogVerdictTraversal verdictCollection;
    private int currentVerdictType;
    private TPFVerdictEvent currentVerdict;
    private StructuredViewer viewer;

    public VerdictNavigationAction(VerdictTypesPullDownAction verdictTypesAction, ITestLogVerdictTraversal collection, StructuredViewer structuredViewer) {
        super(null);
        this.currentVerdictType = verdictTypesAction.getCurrentVerdictType();
        this.verdictCollection = collection;
        verdictTypesAction.addVerdictTypeSelectionListener(this);
        this.setStructuredViewer(structuredViewer);
        this.setEnabled(this.verdictCollection.contains(this.currentVerdictType));
    }

    public void setStructuredViewer(StructuredViewer structuredViewer) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.viewer = structuredViewer;
        structuredViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public StructuredViewer getStructuredViewer() {
        return this.viewer;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.currentVerdict = !selection.isEmpty() && selection.getFirstElement() instanceof TPFVerdictEvent ? (TPFVerdictEvent)selection.getFirstElement() : null;
        if (!super.updateSelection(selection)) {
            return false;
        }
        return this.verdictCollection.contains(this.currentVerdictType);
    }

    public void verdictTypeSelected(int type) {
        this.currentVerdictType = type;
    }

    public int getCurrentVerdictType() {
        return this.currentVerdictType;
    }

    public TPFVerdictEvent getCurrentVerdictSelection() {
        return this.currentVerdict;
    }

    public static void revealEvent(TPFVerdictEvent verdictEvent, TreeViewer treeViewer) {
        ArrayList<TPFVerdictEvent> containerEvents = new ArrayList<TPFVerdictEvent>();
        TPFVerdictEvent currentEvent = verdictEvent;
        EObject currentEventContainer = currentEvent.eContainer();
        while (currentEventContainer != null) {
            if (!(currentEventContainer instanceof TPFExecutionHistory)) {
                containerEvents.add(0, currentEvent);
                currentEvent = currentEventContainer;
            }
            currentEventContainer = currentEventContainer.eContainer();
        }
        treeViewer.setSelection((ISelection)new TreeSelection(new TreePath(containerEvents.toArray())), true);
    }
}

