/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class ExecutionResultEventDetailsPart
extends AbstractFormPart
implements IDetailsPage,
IHyperlinkListener {
    private FormPage formPage = null;
    private Composite parent = null;
    private Section commonPropertiesSection = null;
    private Hyperlink modelElementLink = null;
    private Text testTypeText = null;
    private Text testFileText = null;
    private Text verdictText = null;
    private Text startTimeText = null;
    private Text stopTimeText = null;

    public ExecutionResultEventDetailsPart(FormPage formPage) {
        this.formPage = formPage;
    }

    public void createContents(Composite parent) {
        if (parent != this.parent) {
            if (this.parent == null) {
                this.getManagedForm().addPart((IFormPart)this);
            }
            this.parent = parent;
            this.disposeContent();
            this.commonPropertiesSection = FormsUtil.createSection(this.getManagedForm(), parent, UiPluginResourceBundle.TTL_PROPERTIES, "");
            Composite commonSectionClient = (Composite)this.commonPropertiesSection.getClient();
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            this.modelElementLink = toolkit.createHyperlink(commonSectionClient, "", 64);
            this.modelElementLink.addHyperlinkListener((IHyperlinkListener)this);
            this.modelElementLink.setLayoutData((Object)new GridData());
            this.modelElementLink.setText(UiPluginResourceBundle.NO_INTF_TO_INV);
            this.modelElementLink.setToolTipText(UiPluginResourceBundle.NO_INTF_TO_INV);
            toolkit.createLabel(commonSectionClient, UiPluginResourceBundle.LBL_TYPE);
            this.testTypeText = toolkit.createText(commonSectionClient, "", 65540);
            this.testTypeText.setLayoutData((Object)new GridData(768));
            this.testTypeText.setEditable(false);
            toolkit.createLabel(commonSectionClient, UiPluginResourceBundle.LBL_FILE);
            this.testFileText = toolkit.createText(commonSectionClient, "", 65540);
            this.testFileText.setLayoutData((Object)new GridData(768));
            this.testFileText.setEditable(false);
            toolkit.createLabel(commonSectionClient, UiPluginResourceBundle.LBL_VERD);
            this.verdictText = toolkit.createText(commonSectionClient, "", 65540);
            this.verdictText.setLayoutData((Object)new GridData(768));
            this.verdictText.setEditable(false);
            toolkit.createLabel(commonSectionClient, UiPluginResourceBundle.LBL_START);
            this.startTimeText = toolkit.createText(commonSectionClient, "", 65540);
            this.startTimeText.setLayoutData((Object)new GridData(768));
            this.startTimeText.setEditable(false);
            toolkit.createLabel(commonSectionClient, UiPluginResourceBundle.LBL_STOP);
            this.stopTimeText = toolkit.createText(commonSectionClient, "", 65540);
            this.stopTimeText.setLayoutData((Object)new GridData(768));
            this.stopTimeText.setEditable(false);
            toolkit.paintBordersFor(commonSectionClient);
        }
    }

    public void initialize(IManagedForm managedForm) {
        super.initialize(managedForm);
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void setFocus() {
    }

    public void commit(boolean onSave) {
        if (onSave) {
            super.commit(onSave);
        }
    }

    public void dispose() {
        this.getManagedForm().removePart((IFormPart)this);
        super.dispose();
        this.disposeContent();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            Object object = structuredSelection.getFirstElement();
            if (object instanceof TPFExecutionResult && ((TPFExecutionResult)object).getTest() != null) {
                TPFExecutionResult executionResult = (TPFExecutionResult)object;
                TPFTest test = executionResult.getTest();
                this.modelElementLink.setVisible(true);
                if (test != null && test.eResource() != null) {
                    if (test.getName() != null) {
                        this.modelElementLink.setText(test.getName());
                        this.modelElementLink.setToolTipText(test.getName());
                    } else {
                        this.modelElementLink.setText(UiPluginResourceBundle.W_TEST);
                        this.modelElementLink.setToolTipText(UiPluginResourceBundle.W_TEST);
                    }
                    this.modelElementLink.setData((Object)executionResult);
                } else {
                    this.modelElementLink.setText(UiPluginResourceBundle.NO_INTF_TO_INV);
                    this.modelElementLink.setToolTipText(UiPluginResourceBundle.NO_INTF_TO_INV);
                    this.modelElementLink.setData(null);
                }
                TPFTestSuite testSuite = null;
                testSuite = test instanceof TPFTestSuite ? (TPFTestSuite)test : ((TPFTestCase)test).getTestSuite();
                if (testSuite != null) {
                    String value = testSuite.getType();
                    if (value != null) {
                        IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                        if (descriptor != null && descriptor.getName() != null) {
                            value = descriptor.getName();
                        }
                        this.testTypeText.setText(value);
                    } else {
                        this.testTypeText.setText("");
                    }
                    this.testFileText.setText(EMFUtil.getFilePath((EObject)testSuite));
                } else {
                    this.testTypeText.setText("");
                    this.testFileText.setText("");
                }
                TestLogVerdictTraversalQuery query = (TestLogVerdictTraversalQuery)((TestLogViewer)this.formPage.getEditor()).getTestLogVerdictTraversal();
                if (query.getCount(4) != 0) {
                    this.verdictText.setText(executionResult.getVerdict().getLabel());
                } else {
                    this.verdictText.setText(UiPluginResourceBundle.LogOverview_NoVerdict);
                }
                this.startTimeText.setText(EventUtil.getTime(EventUtil.getStartTimeStamp(executionResult)));
                this.stopTimeText.setText(EventUtil.getTime(EventUtil.getStopTimeStamp(executionResult)));
            } else {
                this.modelElementLink.setVisible(false);
                this.testTypeText.setText("");
                this.testFileText.setText("");
                this.verdictText.setText("");
                this.startTimeText.setText("");
                this.stopTimeText.setText("");
            }
            Composite commonSectionClient = (Composite)this.commonPropertiesSection.getClient();
            commonSectionClient.getParent().layout(true);
            commonSectionClient.getParent().getParent().layout(true);
        }
    }

    public void linkActivated(HyperlinkEvent e) {
        Object data;
        if (e.widget == this.modelElementLink && (data = this.modelElementLink.getData()) != null && data instanceof TPFExecutionResult) {
            TPFTest eObject = ((TPFExecutionResult)data).getTest();
            IEditorPart editorPart = TestUIUtil.openEditor(eObject.eResource(), null, false);
            if (editorPart instanceof ISelectionProvider) {
                ((ISelectionProvider)editorPart).setSelection((ISelection)new StructuredSelection((Object)eObject));
            }
            return;
        }
        IActionBars actionBars = this.formPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setErrorMessage(UiPluginResourceBundle._ERROR_MSG_UN_OPEN_OBJ);
        }
    }

    public void linkEntered(HyperlinkEvent e) {
        IActionBars actionBars = this.formPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(this.modelElementLink.getText());
        }
    }

    public void linkExited(HyperlinkEvent e) {
        IActionBars actionBars = this.formPage.getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
            manager.setErrorMessage("");
        }
    }

    private void disposeContent() {
        if (this.commonPropertiesSection != null && !this.commonPropertiesSection.isDisposed()) {
            ((Composite)this.commonPropertiesSection.getClient()).dispose();
            this.modelElementLink = null;
            this.testTypeText = null;
            this.testFileText = null;
            this.verdictText = null;
            this.startTimeText = null;
            this.stopTimeText = null;
            this.commonPropertiesSection.dispose();
            this.commonPropertiesSection = null;
        }
    }
}

