/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import java.util.List;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.forms.base.ExecutionResultDetailsPart;
import org.eclipse.hyades.test.ui.forms.base.VerdictSummaryChart;
import org.eclipse.hyades.test.ui.forms.editor.page.LogEventsPage;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.VerdictCategory;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EventLabelProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class LogOverviewDetailsPart
extends ExecutionResultDetailsPart
implements ISelectionChangedListener {
    private SashForm parentSash;
    private Section verdictListSection;
    private ILabelProvider eventLabelProvider;
    private VerdictCategory currentVerdictCategory;
    protected static int MAX_VERDICT_NUMBER = 20;

    public LogOverviewDetailsPart(FormPage page) {
        super(page);
    }

    public void createContents(Composite parent) {
        this.parentSash = new SashForm(parent, 512);
        this.toolkit.adapt((Control)this.parentSash, false, false);
        this.parentSash.setLayoutData((Object)new GridData(1808));
        this.createCommonPropSection((Composite)this.parentSash);
        this.createVerdictListSection((Composite)this.parentSash);
        this.parentSash.setWeights(new int[]{35, 65});
        this.mForm.addPart((IFormPart)this);
    }

    public SashForm getParent() {
        return this.parentSash;
    }

    protected void createVerdictListSection(Composite parent) {
        this.verdictListSection = FormsUtil.createSection(this.mForm, parent, UiPluginResourceBundle.LogOverview_VerdictListTitle, UiPluginResourceBundle.LogOverview_VerdictListDescription);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        Composite client = (Composite)this.verdictListSection.getClient();
        client.setLayout((Layout)gridLayout);
        client.setLayoutData((Object)GridDataUtil.createFill());
        this.toolkit.paintBordersFor(client);
    }

    public Section getVerdictListSection() {
        return this.verdictListSection;
    }

    protected ILabelProvider getVerdictEventLabelProvider() {
        if (this.eventLabelProvider == null) {
            this.eventLabelProvider = new EventLabelProvider();
        }
        return this.eventLabelProvider;
    }

    public void setInput(VerdictCategory category) {
        Composite verdictListSectionClient = (Composite)this.verdictListSection.getClient();
        if (category == null) {
            ((FormText)this.verdictListSection.getDescriptionControl()).setText(UiPluginResourceBundle.LogOverview_NoVerdictInLog, false, false);
            Control[] children = verdictListSectionClient.getChildren();
            if (children != null) {
                int counter = 0;
                while (counter < children.length) {
                    children[counter].dispose();
                    children[counter] = null;
                    ++counter;
                }
            }
        } else if (this.currentVerdictCategory == null || !this.currentVerdictCategory.equals(category)) {
            this.currentVerdictCategory = category;
            Control[] children = verdictListSectionClient.getChildren();
            if (children != null) {
                int counter = 0;
                while (counter < children.length) {
                    children[counter].dispose();
                    children[counter] = null;
                    ++counter;
                }
            }
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginTop = 0;
            Composite verdictListComposite = this.toolkit.createComposite(verdictListSectionClient);
            verdictListComposite.setLayout((Layout)gridLayout);
            verdictListComposite.setLayoutData((Object)GridDataUtil.createFill());
            List verdicts = category.getVerdicts();
            int size = Math.min(category.getNumVerdicts(), MAX_VERDICT_NUMBER);
            int counter = 0;
            while (counter < size) {
                if (!category.isIgnoredVerdict(counter)) {
                    String eventText = this.getVerdictEventLabelProvider().getText(verdicts.get(counter));
                    ImageHyperlink hyperlink = this.toolkit.createImageHyperlink(verdictListComposite, 0);
                    hyperlink.setData(verdicts.get(counter));
                    hyperlink.addHyperlinkListener((IHyperlinkListener)this);
                    hyperlink.setText(eventText);
                    hyperlink.setToolTipText(eventText);
                    hyperlink.setImage(category.getImage());
                }
                ++counter;
            }
            Button moreButton = this.toolkit.createButton(verdictListSectionClient, UiPluginResourceBundle.ACT_MORE, 8);
            moreButton.setLayoutData((Object)new GridData(130));
            moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent s) {
                    LogOverviewDetailsPart.this.formPage.getEditor().setActivePage("org.eclipse.tptp.test.ui.logviewer.events");
                }
            });
            verdictListSectionClient.layout(true);
        }
    }

    public void linkActivated(HyperlinkEvent e) {
        if (e.widget instanceof ImageHyperlink && e.widget.getData() instanceof TPFVerdictEvent) {
            this.formPage.getEditor().setActivePage("org.eclipse.tptp.test.ui.logviewer.events");
            LogEventsPage page = (LogEventsPage)this.formPage.getEditor().getActivePageInstance();
            page.lazySelectVerdictEvent((TPFVerdictEvent)e.widget.getData());
        } else {
            super.linkActivated(e);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object sel;
        if (event.getSource() instanceof VerdictSummaryChart && (sel = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof VerdictCategory) {
            this.setInput((VerdictCategory)sel);
        }
    }
}

