/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.test.ui.forms.base.ExecutionEventDetailsPart;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TimedEventDetailsPart
extends ExecutionEventDetailsPart {
    private Text endTime;
    private Text duration;

    public TimedEventDetailsPart() {
    }

    public TimedEventDetailsPart(FormPage page) {
        super(page);
    }

    protected void createDetailsContents(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.createLabel(parent, UiPluginResourceBundle.LBL_END_TIME);
        this.endTime = toolkit.createText(parent, "", 65540);
        this.endTime.setLayoutData((Object)new GridData(768));
        this.endTime.setEditable(false);
        toolkit.createLabel(parent, UiPluginResourceBundle.LBL_DURATION);
        this.duration = toolkit.createText(parent, "", 65540);
        this.duration.setLayoutData((Object)new GridData(768));
        this.duration.setEditable(false);
        toolkit.paintBordersFor(parent);
    }

    protected void setInput(Object object) {
        super.setInput(object);
        if (object instanceof TPFTimedEvent) {
            TPFTimedEvent timedEvent = (TPFTimedEvent)object;
            this.endTime.setText(EventUtil.getTime(timedEvent.getEndTimestamp()));
            this.duration.setText(EventUtil.getDuration(timedEvent.getTimestamp(), timedEvent.getEndTimestamp()));
        } else {
            this.endTime.setText("");
            this.duration.setText("");
        }
    }
}

