/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.base;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.base.ExecutionEventDetailsPart;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class VerdictEventDetailsPart
extends ExecutionEventDetailsPart
implements IOpenEventListener {
    private Text verdictText;
    private TPFVerdictEvent verdictEvent;
    private String stackTraceAsText;
    private static final String TRACE_LINE_PATTERN = "at ";
    private static final String STACK_FRAME_PATTERN_WIN = "\r\n\tat ";
    private static final String STACK_FRAME_PATTERN_LINUX = "\n\tat ";
    private static final String JUNIT_FRAMEWORK_STACK_PATTERN = "junit.framework.";

    public VerdictEventDetailsPart() {
    }

    public VerdictEventDetailsPart(FormPage page) {
        super(page);
    }

    protected void createDetailsContents(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.createLabel(parent, UiPluginResourceBundle.LBL_VERD);
        this.verdictText = toolkit.createText(parent, "", 65540);
        this.verdictText.setLayoutData((Object)new GridData(768));
        this.verdictText.setEditable(false);
        toolkit.paintBordersFor(parent);
    }

    protected void setInput(Object object) {
        super.setInput(object);
        if (object instanceof TPFVerdictEvent) {
            this.verdictEvent = (TPFVerdictEvent)object;
            if (this.verdictEvent.getVerdict() != null) {
                this.verdictText.setText(this.verdictEvent.getVerdict().getLabel());
            } else {
                this.verdictText.setText("");
            }
        } else {
            this.verdictText.setText("");
            this.verdictText.setEditable(false);
        }
    }

    protected void setMessageText(String text) {
        if (this.isStackTrace(text)) {
            if (!(this.messageText instanceof Table)) {
                if (this.messageText != null) {
                    this.messageText.dispose();
                    this.messageText = null;
                }
                Composite parent = (Composite)this.commonPropSection.getClient();
                this.messageText = this.createStackTraceControl(parent, this.getManagedForm().getToolkit());
                this.getManagedForm().getToolkit().paintBordersFor(parent);
            }
            this.setStackTraceInput(text);
        } else {
            super.setMessageText(text);
        }
    }

    private boolean isStackTrace(String text) {
        return text != null && (text.indexOf(STACK_FRAME_PATTERN_WIN) > -1 || text.indexOf(STACK_FRAME_PATTERN_LINUX) > -1);
    }

    private Control createStackTraceControl(Composite parent, FormToolkit toolkit) {
        Table stackTrace = toolkit.createTable(parent, 65540);
        GridData data = GridDataUtil.createHorizontalFill();
        data.heightHint = stackTrace.getItemHeight() * 10;
        stackTrace.setLayoutData((Object)data);
        OpenStrategy handler = new OpenStrategy((Control)stackTrace);
        handler.addOpenListener((IOpenEventListener)this);
        toolkit.paintBordersFor(parent);
        this.createStackTracePopupMenu(stackTrace);
        return stackTrace;
    }

    private void createStackTracePopupMenu(Table stackTrace) {
        Menu popUpMenu = new Menu((Decorations)stackTrace.getShell(), 8);
        stackTrace.setMenu(popUpMenu);
        MenuItem copyItem = new MenuItem(popUpMenu, 8);
        copyItem.setText(UiPluginResourceBundle.TestLogViewer_CopyStackTrace);
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = new Clipboard(VerdictEventDetailsPart.this.getFormPage().getSite().getShell().getDisplay());
                try {
                    clipboard.setContents(new Object[]{VerdictEventDetailsPart.this.stackTraceAsText}, new Transfer[]{TextTransfer.getInstance()});
                }
                finally {
                    clipboard.dispose();
                }
            }
        });
    }

    private void setStackTraceInput(String trace) {
        int end;
        this.stackTraceAsText = trace;
        if (!(this.messageText instanceof Table) || !this.isStackTrace(trace)) {
            return;
        }
        Table stackTrace = (Table)this.messageText;
        stackTrace.removeAll();
        int n = end = trace.indexOf(STACK_FRAME_PATTERN_WIN) == -1 ? trace.indexOf(STACK_FRAME_PATTERN_LINUX) : trace.indexOf(STACK_FRAME_PATTERN_WIN);
        if (end > -1) {
            this.addStackItem(stackTrace, trace.substring(0, end), false);
        }
        boolean junitFrameworkStack = true;
        while (end != -1) {
            int start = end;
            end = trace.indexOf(STACK_FRAME_PATTERN_WIN) == -1 ? trace.indexOf(STACK_FRAME_PATTERN_LINUX, start + STACK_FRAME_PATTERN_LINUX.length()) : trace.indexOf(STACK_FRAME_PATTERN_WIN, start + STACK_FRAME_PATTERN_WIN.length());
            String line = end == -1 ? trace.substring(start) : trace.substring(start, end);
            if (junitFrameworkStack && line.indexOf(JUNIT_FRAMEWORK_STACK_PATTERN) == -1) {
                junitFrameworkStack = false;
            }
            if (junitFrameworkStack) continue;
            this.addStackItem(stackTrace, line, true);
        }
    }

    private void addStackItem(Table stackTrace, String text, boolean isException) {
        TableItem item = new TableItem(stackTrace, 0);
        String normalizedText = text.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ').trim();
        if (Window.getDefaultOrientation() == 0x4000000) {
            item.setText(TextProcessor.process((String)normalizedText, (String)" .():$"));
        } else {
            item.setText(normalizedText);
        }
        if (isException) {
            item.setImage(TestUIImages.INSTANCE.getImage("stkfrm_obj.gif"));
        } else {
            item.setImage(TestUIImages.INSTANCE.getImage("exc_catch.gif"));
        }
    }

    private void openStackFrame(String traceLine) {
        try {
            String testName = traceLine;
            testName = testName.substring(testName.indexOf(TRACE_LINE_PATTERN));
            testName = testName.substring(TRACE_LINE_PATTERN.length(), testName.lastIndexOf(40)).trim();
            testName = testName.substring(0, testName.lastIndexOf(46));
            int innerSeparatorIndex = testName.indexOf(36);
            if (innerSeparatorIndex != -1) {
                testName = testName.substring(0, innerSeparatorIndex);
            }
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.lastIndexOf(41));
            int line = Integer.valueOf(lineNumber);
            String cuName = traceLine.substring(traceLine.lastIndexOf(40) + 1, traceLine.lastIndexOf(58));
            this.openCompilationUnitAtLine(cuName, testName, line);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
        }
    }

    private void openCompilationUnitAtLine(String cuName, String className, int line) throws CoreException {
        IJavaElement javaElement = org.eclipse.hyades.test.core.util.JavaUtil.findElement((IJavaProject)this.getJavaProject(), (String)cuName, (String)className);
        if (javaElement != null) {
            JavaUtil.revealJavaElementAtLine((IJavaElement)javaElement, (int)line);
        }
    }

    private IJavaProject getJavaProject() {
        IFile file;
        if (this.verdictEvent != null && (file = EMFUtil.getWorkspaceFile((EObject)this.verdictEvent)) != null) {
            return JavaCore.create((IProject)file.getProject());
        }
        return null;
    }

    public void handleOpen(SelectionEvent e) {
        if (!(this.messageText instanceof Table)) {
            return;
        }
        TableItem[] selection = ((Table)this.messageText).getSelection();
        if (selection.length > 0) {
            this.openStackFrame(selection[0].getText());
        }
    }
}

