/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.Guid;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.util.ResourceCache;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.util.EObjectEditorInput;
import org.eclipse.hyades.test.ui.navigator.EObjectProxyNode;
import org.eclipse.hyades.test.ui.util.RCPFileEditorInput;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.adapter.ISynchronizedEditorAdapter;
import org.eclipse.hyades.ui.internal.editor.EditorSynchronizer;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.FileEditorInput;

public abstract class BaseFormEditor
extends FormEditor
implements ISynchronizedEditorAdapter,
ISelectionProvider {
    private Class editorObjectClass;
    private EObject editorEObject;
    private ResourceSet sharedResourceSet;
    private Adapter thisAdapter;
    private URI cachedURI;
    EditorSynchronizer editorSynchronizer;
    private ListenerList selectionChangedListeners;
    private boolean isReadOnly = false;

    public BaseFormEditor(Class editorObjectClass) {
        this.editorObjectClass = editorObjectClass;
        this.selectionChangedListeners = new ListenerList();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.setSelectionProvider((ISelectionProvider)this);
        EObject eObject = null;
        if (input instanceof EObjectEditorInput) {
            eObject = this.getEObjectContent(((EObjectEditorInput)input).getEObject());
        } else if (input instanceof IFileEditorInput) {
            eObject = this.getFileContent(((IFileEditorInput)input).getFile());
        } else if (input instanceof ILocationProvider) {
            ILocationProvider javaFileEditorInput = (ILocationProvider)input;
            eObject = this.getFileContent(javaFileEditorInput.getPath((Object)javaFileEditorInput).toFile());
        } else if (input instanceof RCPFileEditorInput) {
            eObject = this.getFileContent(((RCPFileEditorInput)input).getIOFile());
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            eObject = this.getFileContent(path.toFile());
        } else if (input instanceof IURIEditorInput) {
            eObject = this.getFileContent(new File(((IURIEditorInput)input).getURI()));
        }
        if (eObject == null) {
            throw new PartInitException(UiPluginResourceBundle._ERROR_EDT_INPUT);
        }
        this.setEditorObject(eObject);
        this.editorSynchronizer = new EditorSynchronizer((IEditorPart)this);
        this.isReadOnly = EditorSynchronizer.isReadOnly((FileEditorInput)this.editorSynchronizer.getEditorFile());
    }

    public Object getAdapter(Class adapter) {
        if (ISynchronizedEditorAdapter.class == adapter) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        if (this.getSite() != null) {
            this.getSite().setSelectionProvider(null);
        }
        if (this.editorSynchronizer != null) {
            this.editorSynchronizer.dispose();
            this.editorSynchronizer = null;
        }
        if (this.sharedResourceSet != null) {
            EMFUtil.removeAdapters((Iterator)this.sharedResourceSet.getAllContents(), (Adapter)this.thisAdapter);
            this.sharedResourceSet.eAdapters().remove((Object)this.thisAdapter);
            this.sharedResourceSet = null;
            ResourceCache.getInstance().releaseSharedResource(this.cachedURI);
        }
        if (this.selectionChangedListeners != null) {
            this.selectionChangedListeners.clear();
            this.selectionChangedListeners = null;
        }
        super.dispose();
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(UiPlugin.getDefault().getFormColors(display));
    }

    public void setEditorObject(EObject editorObject) {
        this.editorEObject = editorObject;
        if (this.editorObjectClass.isInstance(editorObject)) {
            if (editorObject instanceof CMNNamedElement) {
                this.setEditorTitle(((CMNNamedElement)editorObject).getName());
            } else {
                this.setEditorTitle(editorObject.toString());
            }
        }
        int i = 0;
        while (i < this.pages.size()) {
            IManagedForm mform;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && (mform = ((IFormPage)page).getManagedForm()) != null) {
                mform.setInput((Object)editorObject);
            }
            ++i;
        }
    }

    public EObject getEditorObject() {
        return this.editorEObject;
    }

    public void setEditorTitle(String title) {
        this.setPartName(title);
    }

    public String getEditorTitle() {
        return this.getPartName();
    }

    protected Class getEditorObjectClass() {
        return this.editorObjectClass;
    }

    protected EObject getEObjectContent(EObject eObject) {
        this.cachedURI = eObject.eResource().getURI();
        if (this.getEditorObjectClass().isInstance(eObject)) {
            this.sharedResourceSet = ResourceCache.getInstance().createResourceSet();
            this.sharedResourceSet.getResources().add((Object)eObject.eResource());
            return eObject;
        }
        return null;
    }

    protected EObject getFileContent(IFile file) {
        this.cachedURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        return this.getFileContent(this.cachedURI);
    }

    protected EObject getFileContent(File file) {
        this.cachedURI = URI.createFileURI((String)file.getAbsolutePath());
        return this.getFileContent(this.cachedURI);
    }

    private EObject getFileContent(URI uri) {
        Resource resource = ResourceCache.getInstance().getSharedResource(uri);
        if (resource.getContents().size() != 1 || !this.getEditorObjectClass().isInstance(resource.getContents().get(0))) {
            return null;
        }
        this.sharedResourceSet = resource.getResourceSet();
        return (EObject)resource.getContents().get(0);
    }

    public ResourceSet getResourceSet() {
        return this.sharedResourceSet;
    }

    public void doSave(IProgressMonitor monitor) {
        this.save(monitor);
        this.commitFormPages(true);
        super.editorDirtyStateChanged();
    }

    protected void save(IProgressMonitor monitor) {
        Resource[] resources = (Resource[])this.getResourceSet().getResources().toArray((Object[])new Resource[this.getResourceSet().getResources().size()]);
        int length = resources.length;
        int counter = 0;
        monitor.beginTask("", length);
        int i = 0;
        int maxi = resources.length;
        while (i < maxi) {
            if (resources[i].isModified()) {
                this.logSaveMessage(monitor, resources[i], length, counter++);
                try {
                    EMFUtil.save((Resource)resources[i]);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
    }

    private void commitFormPages(boolean onSave) {
        int i = 0;
        while (i < this.pages.size()) {
            IManagedForm mform;
            Object page = this.pages.get(i);
            if (page instanceof IFormPage && (mform = ((IFormPage)page).getManagedForm()) != null && mform.isDirty()) {
                mform.commit(true);
            }
            ++i;
        }
    }

    protected IFormPage[] getPages() {
        ArrayList formPages = new ArrayList();
        int i = 0;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                formPages.add(page);
            }
            ++i;
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    protected void logSaveMessage(IProgressMonitor monitor, Resource resource, int total, int current) {
        monitor.subTask("");
    }

    protected void handleException(Exception exception) {
        UiPlugin.logError(exception);
        String filePath = EMFUtil.getFilePath((EObject)this.getEditorObject());
        UIUtil.openSaveFileErrorDialog((Shell)this.getSite().getShell(), (String)filePath, (Throwable)exception);
    }

    protected boolean reloadEditorObject() {
        Resource resource = this.getEditorObject().eResource();
        try {
            resource.unload();
            resource.load(EMFUtil.RESOURCE_OPTIONS);
            if (!resource.getContents().isEmpty()) {
                this.setEditorObject((EObject)resource.getContents().get(0));
            } else {
                this.setEditorObject(null);
            }
        }
        catch (Exception e) {
            UiPlugin.logError(e);
        }
        return false;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof TestNavigator) {
            EObjectProxyNode proxy;
            URI uri;
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return;
            }
            EObject obj2Select = null;
            Object first = structuredSelection.getFirstElement();
            if (this.getEditorObjectClass().isInstance(first)) {
                URI uri2 = EMFUtil.getObjectURI((Object)first);
                if (uri2 == null) {
                    return;
                }
                ResourceSet resSet = this.getResourceSet();
                Resource res = resSet.getResource(uri2.trimFragment(), false);
                if (res != null) {
                    String id = uri2.fragment();
                    TreeIterator i = res.getAllContents();
                    while (i.hasNext()) {
                        EObject eObject = (EObject)i.next();
                        if (!id.equals(EcoreUtil.getID((EObject)eObject)) || !this.getEditorObjectClass().isInstance(eObject)) continue;
                        obj2Select = eObject;
                    }
                }
            } else if (first instanceof EObjectProxyNode && (uri = (proxy = (EObjectProxyNode)first).getOriginatorURI()) != null) {
                obj2Select = this.getResourceSet().getEObject(uri, false);
            }
            if (obj2Select == null) {
                return;
            }
        }
    }

    public void doSaveAs() {
        block7: {
            IPath newFilePath;
            IFile originalFile;
            SaveAsDialog dialog = new SaveAsDialog(this.getEditorSite().getShell());
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput && (originalFile = ((IFileEditorInput)editorInput).getFile()) != null) {
                dialog.setOriginalFile(originalFile);
            }
            dialog.create();
            if (dialog.open() == 0 && (newFilePath = dialog.getResult()) != null) {
                IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
                try {
                    Resource resource = this.editorEObject.eResource();
                    if (resource == null || !(this.editorEObject instanceof CMNNamedElement)) break block7;
                    CMNNamedElement namedElement = (CMNNamedElement)this.editorEObject;
                    URI originalURI = resource.getURI();
                    String originalId = namedElement.getId();
                    String originalName = namedElement.getName();
                    try {
                        namedElement.eSetDeliver(false);
                        resource.setURI(URI.createPlatformResourceURI((String)newFilePath.toString(), (boolean)false));
                        namedElement.setId(new Guid().toString());
                        namedElement.setName(newFilePath.removeFileExtension().lastSegment());
                        EMFUtil.save((Resource)resource);
                    }
                    finally {
                        resource.setURI(originalURI);
                        namedElement.setId(originalId);
                        namedElement.setName(originalName);
                        namedElement.eSetDeliver(true);
                    }
                    TestUIUtil.openEditor(newFile, this.getEditorSite().getId());
                    ResourceCache.getInstance().releaseSharedResource(this.cachedURI);
                }
                catch (Exception e) {
                    TestCorePlugin.getDefault().logError((Throwable)e);
                }
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean doSaveEditorFile(boolean wasDeleted) {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
        return false;
    }

    public boolean editorFileChanged() {
        this.reload();
        return false;
    }

    public boolean editorFileDeleted() {
        return false;
    }

    public boolean editorFileWriteAccessChanged(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return false;
    }

    public void handle(List changedFiles, List removedFiles) {
    }

    public boolean reload() {
        EObject editorObject;
        Object selection;
        String fragment = null;
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getSelection();
        if (structuredSelection != null && structuredSelection.size() == 1 && (selection = structuredSelection.getFirstElement()) instanceof EObject) {
            fragment = ((EObject)selection).eResource().getURIFragment((EObject)selection);
        }
        if (!this.reloadEditorObject() && (editorObject = this.getEditorObject()) instanceof EObject && fragment != null) {
            EObject selection2 = editorObject.eResource().getEObject(fragment);
            structuredSelection = selection2 != null ? new StructuredSelection((Object)selection2) : StructuredSelection.EMPTY;
            this.setSelection((ISelection)structuredSelection);
        }
        return true;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public abstract ISelection getSelection();

    public abstract void setSelection(ISelection var1);

    public void fireSelectionChanged(SelectionChangedEvent event) {
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, event.getSelection()));
            ++i;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }
}

