/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.editor.page;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.base.ExecutionResultDetailsPart;
import org.eclipse.hyades.test.ui.forms.base.GeneralInfoSectionPart;
import org.eclipse.hyades.test.ui.forms.base.LogOverviewDetailsPart;
import org.eclipse.hyades.test.ui.forms.base.TestLogVerdictTraversalQuery;
import org.eclipse.hyades.test.ui.forms.base.VerdictSummaryChart;
import org.eclipse.hyades.test.ui.forms.editor.BaseFormEditor;
import org.eclipse.hyades.test.ui.forms.editor.TestLogViewer;
import org.eclipse.hyades.test.ui.forms.util.FormsUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;

public class LogOverviewPage
extends FormPage {
    public static final String PAGE_ID = "org.eclipse.tptp.test.ui.logviewer.overview";
    private TPFExecutionResult input;
    private SashForm sashForm;
    private SashForm overviewSash;
    private SashForm detailsSash;
    private ExecutionResultDetailsPart detailsPart;
    private boolean isBIRTAvailable = false;
    private Section chartSection;
    private VerdictSummaryChart chart;

    public LogOverviewPage(FormEditor editor) {
        super(editor, PAGE_ID, UiPluginResourceBundle.W_OVERVIEW);
    }

    protected void createFormContent(IManagedForm managedForm) {
        try {
            Bundle birtChartBundle = Platform.getBundle((String)"org.eclipse.birt.chart.engine");
            if (birtChartBundle != null) {
                this.isBIRTAvailable = birtChartBundle.getState() == 4 || birtChartBundle.getState() == 8 || birtChartBundle.getState() == 32;
            }
        }
        catch (Throwable throwable) {}
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(UiPluginResourceBundle.W_TEST_LOG);
        scrolledForm.getBody().setLayout((Layout)layout);
        this.sashForm = new SashForm(scrolledForm.getBody(), 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.adapt((Control)this.sashForm, false, false);
        this.sashForm.setMenu(scrolledForm.getBody().getMenu());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.createOverviewPart(managedForm, (Composite)this.sashForm);
        this.createDetailsPart(managedForm, (Composite)this.sashForm);
        this.createToolBarActions(managedForm);
        scrolledForm.updateToolBar();
        EObject input = ((BaseFormEditor)this.getEditor()).getEditorObject();
        TestLogVerdictTraversalQuery query = (TestLogVerdictTraversalQuery)((TestLogViewer)this.getEditor()).getTestLogVerdictTraversal();
        managedForm.setInput((Object)input);
        if (this.chart != null && input instanceof TPFExecutionResult) {
            try {
                boolean isChartDrawn = this.chart.setInput((TPFExecutionResult)input, query);
                if (!isChartDrawn && this.chartSection != null) {
                    this.chartSection.setExpanded(false);
                    if (this.detailsPart instanceof LogOverviewDetailsPart) {
                        ((LogOverviewDetailsPart)this.detailsPart).setInput(null);
                        Section verdictListSection = ((LogOverviewDetailsPart)this.detailsPart).getVerdictListSection();
                        if (verdictListSection != null) {
                            verdictListSection.setExpanded(false);
                        }
                    }
                }
            }
            catch (Throwable t) {
                UiPlugin.logError(t);
            }
        }
    }

    protected void createOverviewPart(IManagedForm managedForm, Composite parent) {
        this.overviewSash = new SashForm(parent, 512);
        managedForm.getToolkit().adapt((Control)this.overviewSash, false, false);
        this.overviewSash.setLayoutData((Object)new GridData(1808));
        new GeneralInfoSectionPart(this, (Composite)this.overviewSash);
        if (this.isBIRTAvailable) {
            this.chartSection = FormsUtil.createSection(managedForm, (Composite)this.overviewSash, UiPluginResourceBundle.LogOverview_VerdictSummaryTitle, UiPluginResourceBundle.LogOverview_VerdictSummaryDescription);
            this.overviewSash.setWeights(new int[]{35, 65});
            Composite client = (Composite)this.chartSection.getClient();
            this.chart = new VerdictSummaryChart(client, 0);
            this.chart.setChartSection(this.chartSection);
            this.chart.setLayoutData(new GridData(1808));
        }
    }

    protected void createDetailsPart(IManagedForm managedForm, Composite parent) {
        if (this.isBIRTAvailable) {
            this.detailsPart = new LogOverviewDetailsPart(this);
            this.detailsPart.initialize(managedForm);
            this.detailsPart.createContents(parent);
            this.detailsSash = ((LogOverviewDetailsPart)this.detailsPart).getParent();
            this.addSelectionChangedListener((LogOverviewDetailsPart)this.detailsPart);
        } else {
            this.detailsPart = new ExecutionResultDetailsPart(this);
            this.detailsPart.initialize(managedForm);
            this.detailsPart.createContents(parent);
        }
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        final ScrolledForm form = managedForm.getForm();
        Action haction = new Action(null, 8){

            public void run() {
                LogOverviewPage.this.sashForm.setOrientation(256);
                LogOverviewPage.this.overviewSash.setOrientation(512);
                if (LogOverviewPage.this.detailsSash != null) {
                    LogOverviewPage.this.detailsSash.setOrientation(512);
                }
                form.reflow(true);
            }
        };
        haction.setChecked(true);
        haction.setToolTipText(UiPluginResourceBundle.Editor_horizontal_orientation);
        haction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", "th_horizontal.gif"));
        Action vaction = new Action(null, 8){

            public void run() {
                LogOverviewPage.this.sashForm.setOrientation(512);
                LogOverviewPage.this.overviewSash.setOrientation(256);
                if (LogOverviewPage.this.detailsSash != null) {
                    LogOverviewPage.this.detailsSash.setOrientation(256);
                }
                form.reflow(true);
            }
        };
        vaction.setChecked(false);
        vaction.setToolTipText(UiPluginResourceBundle.Editor_vertical_orientation);
        vaction.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("e", "th_vertical.gif"));
        form.getToolBarManager().add((IAction)haction);
        form.getToolBarManager().add((IAction)vaction);
    }

    public VerdictSummaryChart getVerdictSummaryChart() {
        return this.chart;
    }

    public ISelection getSelection() {
        return this.chart == null ? null : this.chart.getSelection();
    }

    public void setSelection(ISelection selection) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.chart != null) {
            this.chart.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.chart != null) {
            this.chart.removeSelectionChangedListener(listener);
        }
    }

    public boolean selectReveal(Object object) {
        if (object == this.input) {
            if (this.getEditor().getActivePageInstance() != this) {
                this.getEditor().setActivePage(PAGE_ID);
            }
            return true;
        }
        return false;
    }
}

