/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.forms.extensions.provisional;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class VerdictCategory {
    private String text;
    private RGB color;
    private Image icon;
    private List verdictList;
    private List ignoredVerdictIndices;

    public VerdictCategory() {
    }

    public VerdictCategory(List verdictList, String text, RGB color, Image image) {
        this.verdictList = verdictList;
        this.text = text;
        this.color = color;
        this.icon = image;
        this.ignoredVerdictIndices = new ArrayList();
    }

    public VerdictCategory(List verdictList, String text, RGB color, Image image, List ignoredVerdictIndices) {
        this(verdictList, text, color, image);
        if (ignoredVerdictIndices != null) {
            this.ignoredVerdictIndices = ignoredVerdictIndices;
        }
    }

    public RGB getColor() {
        return this.color;
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getNumVerdicts() {
        return this.verdictList.size() - this.ignoredVerdictIndices.size();
    }

    public boolean isIgnoredVerdict(int index) {
        return this.ignoredVerdictIndices.contains(new Integer(index));
    }

    public List getVerdicts() {
        return this.verdictList;
    }

    public void setVerdicts(List verdictList) {
        this.verdictList = verdictList;
    }

    public void setImage(Image icon) {
        this.icon = icon;
    }

    public Image getImage() {
        return this.icon;
    }
}

