/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddTestSuiteChildAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.IWizardElement;
import org.eclipse.hyades.ui.internal.wizard.selection.SelectionWizard;
import org.eclipse.hyades.ui.internal.wizard.selection.WizardElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;

public class AddTestCaseAction
extends AddTestSuiteChildAction {
    private static Map testCaseTypesByTestSuiteType;

    public AddTestCaseAction() {
        super(UiPluginResourceBundle.BTN_ADD);
        this.setToolTipText(UiPluginResourceBundle.ACT_TST_CASE_ADD_TIP);
        this.setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor("testcase_obj.gif"));
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((IAction)this, String.valueOf(UiPlugin.getID()) + ".atca0001");
    }

    protected boolean updateSelection(IStructuredSelection structuredSelection) {
        this.setActionPerformed(false);
        TPFTestSuite testSuite = this.getTestSuite(structuredSelection);
        if (testSuite == null) {
            return false;
        }
        String testSuiteType = testSuite.getType();
        if (testSuiteType == null) {
            return false;
        }
        HashSet<String> testCaseTypes = null;
        if (testCaseTypesByTestSuiteType == null) {
            testCaseTypesByTestSuiteType = new HashMap();
        } else {
            testCaseTypes = (HashSet<String>)testCaseTypesByTestSuiteType.get(testSuiteType);
        }
        if (testCaseTypes == null) {
            testCaseTypes = new HashSet<String>();
            testCaseTypesByTestSuiteType.put(testSuiteType, testCaseTypes);
            IAssociationMapping testSuiteTypeValidatorMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators");
            IAssociationDescriptor[] typeValidatorDescriptors = testSuiteTypeValidatorMapping.getAssociationDescriptors(testSuiteType);
            if (typeValidatorDescriptors.length == 0) {
                return false;
            }
            IAssociationMapping testCaseWizardMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
            String[] mappingTypes = testCaseWizardMapping.getTypes();
            int i = 0;
            int maxi = mappingTypes.length;
            while (i < maxi) {
                int j = 0;
                int maxj = typeValidatorDescriptors.length;
                while (j < maxj) {
                    ITypeValidator typeValidator = (ITypeValidator)typeValidatorDescriptors[j].createImplementationClassInstance();
                    if (typeValidator.isValidType(mappingTypes[i])) {
                        testCaseTypes.add(mappingTypes[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return !testCaseTypes.isEmpty();
    }

    public void run() {
        this.setActionPerformed(false);
        TPFTestSuite testSuite = this.getTestSuite(this.getStructuredSelection());
        Set testCaseTypes = (Set)testCaseTypesByTestSuiteType.get(testSuite.getType());
        ArrayList<WizardElement> wizardElements = new ArrayList<WizardElement>(testCaseTypes.size());
        IAssociationMapping testCaseWizardMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("newTestCaseWizards");
        for (String testCaseType : testCaseTypes) {
            IAssociationDescriptor[] wizardDescriptors = testCaseWizardMapping.getAssociationDescriptors(testCaseType);
            int j = 0;
            int maxj = wizardDescriptors.length;
            while (j < maxj) {
                Object wizard = wizardDescriptors[j].createImplementationClassInstance();
                if (wizard instanceof ITestCaseWizard) {
                    WizardElement wizardElement = new WizardElement((IWizard)((ITestCaseWizard)wizard));
                    wizardElement.setId(wizardDescriptors[j].getId());
                    wizardElement.setLabel(wizardDescriptors[j].getName());
                    wizardElement.setDescription(wizardDescriptors[j].getDescription());
                    wizardElement.setImageDescriptor(wizardDescriptors[j].getImageDescriptor());
                    wizardElements.add(wizardElement);
                }
                ++j;
            }
        }
        SelectionWizard selectionWizard = new SelectionWizard(wizardElements.toArray(new IWizardElement[wizardElements.size()]), UiPluginResourceBundle.WIZ_SEL_TST_CASE);
        selectionWizard.setWindowTitle(UiPluginResourceBundle.WIZ_TST_CASE_TTL);
        this.openWizard(testSuite, (HyadesWizard)selectionWizard, "TestCaseSelectionWizard");
    }
}

