/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.hyades.models.common.configuration.CFGCategory;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.HyadesClasspathCategory;
import org.eclipse.hyades.models.common.configuration.HyadesRootDirectroyCategory;
import org.eclipse.hyades.models.common.configuration.util.Common_ConfigurationCategoryUtil;
import org.eclipse.hyades.models.common.configuration.util.ICategory;
import org.eclipse.hyades.models.common.configuration.util.ICategoryEnumeration;
import org.eclipse.hyades.test.ui.internal.dialog.DialogMessages;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComparablePropertyInputDialog
extends Dialog {
    private String title = null;
    private CCombo[] comboBoxes = null;
    private ICategory[] categories = null;
    private CFGComparableProperty property = null;

    public ComparablePropertyInputDialog(Shell shell, String title) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.comboBoxes = new CCombo[3];
        this.categories = Common_ConfigurationCategoryUtil.getInstance().getCategories();
    }

    public CFGComparableProperty getProperty() {
        return this.property;
    }

    public void setProperty(CFGComparableProperty property) {
        this.property = property;
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout zeroMarginsLayout = new GridLayout();
        zeroMarginsLayout.marginWidth = 0;
        zeroMarginsLayout.marginHeight = 0;
        GridData fixedWidthLayoutData = new GridData(1808);
        fixedWidthLayoutData.widthHint = 200;
        GridLayout compositeLayout = new GridLayout(3, false);
        compositeLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        compositeLayout.marginTop = this.convertVerticalDLUsToPixels(7);
        compositeLayout.marginBottom = 0;
        compositeLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        compositeLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite propertyNameComposite = new Composite(composite, 0);
        propertyNameComposite.setLayout((Layout)zeroMarginsLayout);
        propertyNameComposite.setLayoutData((Object)fixedWidthLayoutData);
        Label propertyNameLabel = new Label(propertyNameComposite, 64);
        propertyNameLabel.setText(UiPluginResourceBundle.DLG_PROPERTY_NAME);
        propertyNameLabel.setLayoutData((Object)new GridData(800));
        String[] categoryDisplayNames = new String[this.categories.length];
        int selectionIndex = -1;
        String propertyName = null;
        if (this.property != null && this.property.getName() != null) {
            propertyName = this.property.getName();
        }
        int counter = 0;
        while (counter < this.categories.length) {
            categoryDisplayNames[counter] = this.categories[counter].getDisplayName();
            if (propertyName != null && selectionIndex == -1 && propertyName.equals(this.categories[counter].getName())) {
                selectionIndex = counter;
            }
            ++counter;
        }
        this.comboBoxes[0] = new CCombo(propertyNameComposite, 2048);
        this.comboBoxes[0].setItems(categoryDisplayNames);
        if (selectionIndex != -1) {
            this.comboBoxes[0].select(selectionIndex);
        } else if (propertyName != null) {
            this.comboBoxes[0].setText(propertyName);
        }
        this.comboBoxes[0].setLayoutData((Object)new GridData(800));
        this.comboBoxes[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ComparablePropertyInputDialog.this.comboBoxes[0].getSelectionIndex();
                if (index < 0) {
                    return;
                }
                ICategory catg = ComparablePropertyInputDialog.this.categories[index];
                String[] names = ComparablePropertyInputDialog.this.getEnumerationDisplayNames(catg);
                LinkedList<String> items = new LinkedList<String>(Arrays.asList(names));
                items.addAll(ComparablePropertyInputDialog.this.getSelector(catg));
                ComparablePropertyInputDialog.this.comboBoxes[2].setItems(items.toArray(new String[items.size()]));
            }
        });
        this.comboBoxes[0].addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComparablePropertyInputDialog.this.validateInput();
            }
        });
        this.comboBoxes[0].getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.DLG_PROPERTY_NAME;
            }
        });
        Composite operatorComposite = new Composite(composite, 0);
        operatorComposite.setLayout((Layout)zeroMarginsLayout);
        operatorComposite.setLayoutData((Object)new GridData(1040));
        Label operatorLabel = new Label(operatorComposite, 64);
        operatorLabel.setText(UiPluginResourceBundle.DLG_OPERATOR);
        operatorLabel.setLayoutData((Object)new GridData(800));
        this.comboBoxes[1] = new CCombo(operatorComposite, 2056);
        this.comboBoxes[1].setItems(new String[]{"=", "!=", ">", "<", ">=", "<="});
        if (this.property != null && this.property.getOperator() != null) {
            this.comboBoxes[1].setText(this.property.getOperator());
        } else {
            this.comboBoxes[1].select(0);
        }
        this.comboBoxes[1].setLayoutData((Object)new GridData(800));
        this.comboBoxes[1].addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComparablePropertyInputDialog.this.validateInput();
            }
        });
        this.comboBoxes[1].getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.DLG_OPERATOR;
            }
        });
        Composite propertyValueComposite = new Composite(composite, 0);
        propertyValueComposite.setLayout((Layout)zeroMarginsLayout);
        propertyValueComposite.setLayoutData((Object)fixedWidthLayoutData);
        Label propertyValueLabel = new Label(propertyValueComposite, 64);
        propertyValueLabel.setText(UiPluginResourceBundle.DLG_PROPERTY_VALUE);
        propertyValueLabel.setLayoutData((Object)new GridData(800));
        this.comboBoxes[2] = new CCombo(propertyValueComposite, 2048);
        if (this.property != null && this.property.getValue() != null) {
            this.comboBoxes[2].setText(this.property.getValue());
        }
        this.comboBoxes[2].setLayoutData((Object)new GridData(800));
        this.comboBoxes[2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = ComparablePropertyInputDialog.this.comboBoxes[2].getText();
                String selectedPath = null;
                if (DialogMessages.SELECT_FILE.equals(value)) {
                    FileDialog dialog = new FileDialog(ComparablePropertyInputDialog.this.getShell(), 4096);
                    selectedPath = dialog.open();
                } else if (DialogMessages.SELECT_DIR.equals(value)) {
                    DirectoryDialog dialog = new DirectoryDialog(ComparablePropertyInputDialog.this.getShell());
                    selectedPath = dialog.open();
                }
                if (selectedPath != null && (selectedPath = selectedPath.trim()).length() > 0) {
                    ComparablePropertyInputDialog.this.comboBoxes[2].add(selectedPath, 0);
                    ComparablePropertyInputDialog.this.comboBoxes[2].setText(selectedPath);
                }
            }
        });
        this.comboBoxes[2].addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ComparablePropertyInputDialog.this.validateInput();
            }
        });
        this.comboBoxes[2].getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = UiPluginResourceBundle.DLG_PROPERTY_VALUE;
            }
        });
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.comboBoxes[0].getText();
            ICategory category = null;
            int index = this.comboBoxes[0].indexOf(name);
            if (index > -1) {
                category = this.categories[index];
                name = category.getName();
            }
            String operator = this.comboBoxes[1].getText();
            String value = this.comboBoxes[2].getText();
            if (this.property == null) {
                this.property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            }
            this.property.setName(name);
            if (category instanceof CFGCategory) {
                this.property.setType((CFGCategory)category);
            }
            if (operator != null && operator.length() > 0) {
                this.property.setOperator(operator);
            }
            if (value != null && value.length() > 0) {
                this.property.setValue(value);
            }
        } else {
            this.property = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void validateInput() {
        String name = this.comboBoxes[0].getText();
        String operator = this.comboBoxes[1].getText();
        String value = this.comboBoxes[2].getText();
        if (name == null || name.length() < 1 || operator == null || operator.length() < 1 || value == null || value.length() < 1) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    private String[] getEnumerationDisplayNames(ICategory category) {
        ICategoryEnumeration[] cat = Common_ConfigurationCategoryUtil.getInstance().getCategoryEnumeration(category);
        if (cat == null) {
            return new String[0];
        }
        ArrayList names = new ArrayList();
        int i = 0;
        while (i < cat.length) {
            List values = cat[i].getIEnumerationValues();
            int j = 0;
            while (j < values.size()) {
                names.add(values.get(j));
                ++j;
            }
            ++i;
        }
        return names.toArray(new String[names.size()]);
    }

    private List getSelector(ICategory category) {
        LinkedList<String> names = new LinkedList<String>();
        if (category instanceof HyadesClasspathCategory || category instanceof HyadesRootDirectroyCategory) {
            names.add(DialogMessages.SELECT_DIR);
        }
        if (category instanceof HyadesClasspathCategory) {
            names.add(DialogMessages.SELECT_FILE);
        }
        return names;
    }
}

