/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.util.DatapoolEncryptManager;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolActionHandlerListener;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPartExtended;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.DataTableForm;
import org.eclipse.hyades.test.ui.internal.editor.form.DatapoolForm;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditActionsExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.common.ui.internal.util.UIUtil;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class DatapoolEditorExtension
extends BaseEditorExtension
implements IDatapoolPartExtended,
IEditActionsExtension {
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Datapool";
    private DatapoolForm datapoolForm;
    private ArrayList equivalenceClassPages = new ArrayList();
    private int activePageIndex = -1;
    private IFindReplaceTarget findReplaceTarget;
    private IDatapoolListener datapoolListener = new DatapoolListener();
    private static final int PAGE_OVERVIEW = 0;

    public void dispose() {
        this.datapoolForm.getWidgetFactory().dispose();
        this.datapoolForm.dispose();
        for (Object page : this.equivalenceClassPages) {
            if (page == null) continue;
            ((DataTableForm)page).dispose();
        }
        this.equivalenceClassPages.clear();
        super.dispose();
    }

    public void createPages() {
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        WidgetFactory widgetFactory = new WidgetFactory();
        this.datapoolForm = new DatapoolForm(this, widgetFactory);
        hyadesEditorPart.addPage(this.datapoolForm.createControl());
        hyadesEditorPart.setPageText(0, UiPluginResourceBundle.W_OVERVIEW);
        this.datapoolForm.updateTitle();
        DPLDatapool dp = this.getDatapool();
        int i = 0;
        while (i < dp.getEquivalenceClassCount()) {
            this.addEquivalenceClassPage(i);
            ++i;
        }
        if (dp.getEquivalenceClassCount() > 0) {
            int defaultIndex = dp.getDefaultEquivalenceClassIndex();
            defaultIndex = defaultIndex == -1 ? 0 : defaultIndex;
            hyadesEditorPart.setActivePage(this.getEquivalenceClassPageIndex(defaultIndex));
        }
        dp.addDatapoolListener(this.datapoolListener);
    }

    public void addEquivalenceClassPage(int newECIndex) {
        IDatapoolEquivalenceClass eqClass = (IDatapoolEquivalenceClass)this.getDatapool().getEquivalenceClass(newECIndex);
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        DataTableForm dataTableForm = new DataTableForm(this, new WidgetFactory(), eqClass);
        dataTableForm.initialize(eqClass);
        int index = hyadesEditorPart.addPage(dataTableForm.createControl());
        hyadesEditorPart.setPageText(index, eqClass.getName());
        this.equivalenceClassPages.add(newECIndex, dataTableForm);
    }

    public void removeEquivalenceClassPage(int equivalenceClassIndex) {
        DataTableForm tableForm = (DataTableForm)this.equivalenceClassPages.remove(equivalenceClassIndex);
        if (tableForm != null) {
            tableForm.dispose();
        }
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        int pageIndex = this.getEquivalenceClassPageIndex(equivalenceClassIndex);
        hyadesEditorPart.removePage(pageIndex);
    }

    private void moveEquivalenceClassPage(int sourceECIndex, int targetECIndex) {
        int start = Math.min(sourceECIndex, targetECIndex);
        int i = this.getDatapool().getEquivalenceClassCount() - 1;
        while (i >= start) {
            this.removeEquivalenceClassPage(i);
            --i;
        }
        i = start;
        while (i < this.getDatapool().getEquivalenceClassCount()) {
            this.addEquivalenceClassPage(i);
            ++i;
        }
    }

    public int getEquivalenceClassPageIndex(int equivalenceClassIndex) {
        return 0 + equivalenceClassIndex + 1;
    }

    private int getEquivalenceClassIndexFromPageIndex(int pageIndex) {
        return pageIndex - 1;
    }

    public DPLDatapool getDatapool() {
        return (DPLDatapool)this.getHyadesEditorPart().getEditorObject();
    }

    public IStructuredSelection getSelection() {
        switch (this.getHyadesEditorPart().getActivePage()) {
            case 0: {
                return new StructuredSelection((Object)this.getDatapool());
            }
        }
        return StructuredSelection.EMPTY;
    }

    public boolean pageActivated(int index) {
        if (index != this.activePageIndex) {
            this.activePageIndex = index;
            IWorkbenchPage activeWorkbenchPage = UIUtil.getActiveWorkbenchPage();
            if (activeWorkbenchPage != null) {
                try {
                    activeWorkbenchPage.showView("org.eclipse.ui.views.PropertySheet", null, 2);
                }
                catch (PartInitException partInitException) {}
            }
            if (index == 0) {
                return this.datapoolForm.activated();
            }
            if (index > 0) {
                int equivalenceClassIndex = this.getEquivalenceClassIndexFromPageIndex(index);
                DataTableForm dataTableForm = (DataTableForm)this.equivalenceClassPages.get(equivalenceClassIndex);
                if (this.getHyadesEditorPart().getControl(index) == null) {
                    this.getHyadesEditorPart().setControl(index, dataTableForm.createControl());
                }
                dataTableForm.getDatapoolTable().refresh(false);
                ((FindReplaceTarget)this.getFindReplaceTarget()).updatePage(index);
                IDatapoolEquivalenceClass equivalenceClass = (IDatapoolEquivalenceClass)this.getDatapool().getEquivalenceClass(equivalenceClassIndex);
                if (equivalenceClass != null) {
                    this.datapoolForm.setSelection((ISelection)new StructuredSelection((Object)equivalenceClass));
                }
                return dataTableForm.activated();
            }
            return false;
        }
        return true;
    }

    protected boolean reloadEditorObject() {
        this.getDatapool().removeDatapoolListener(this.datapoolListener);
        boolean ret = super.reloadEditorObject();
        this.getDatapool().addDatapoolListener(this.datapoolListener);
        return ret;
    }

    public void refreshContent(Object data) {
        if (!(data instanceof IDatapool)) {
            return;
        }
        if (data == this.getDatapool() && ((IDatapool)data).getEquivalenceClassCount() == this.equivalenceClassPages.size()) {
            this.datapoolForm.load();
            this.datapoolForm.updateTitle();
            int i = 0;
            while (i < ((IDatapool)data).getEquivalenceClassCount()) {
                Object page = this.equivalenceClassPages.get(i);
                if (page != null) {
                    IDatapoolEquivalenceClass ec = (IDatapoolEquivalenceClass)((IDatapool)data).getEquivalenceClass(i);
                    ((DataTableForm)page).load(ec);
                    this.getHyadesEditorPart().setPageText(this.getEquivalenceClassPageIndex(i), ec.getName());
                }
                ++i;
            }
        } else {
            this.getHyadesEditorPart().setEditorObject(data);
            int previousActivePage = this.activePageIndex;
            this.datapoolForm.load();
            this.datapoolForm.updateTitle();
            int i = this.equivalenceClassPages.size() - 1;
            while (i >= 0) {
                Object page = this.equivalenceClassPages.get(i);
                if (page != null) {
                    this.removeEquivalenceClassPage(i);
                }
                --i;
            }
            int count = ((IDatapool)data).getEquivalenceClassCount();
            int i2 = 0;
            while (i2 < count) {
                this.addEquivalenceClassPage(i2);
                ++i2;
            }
            if (previousActivePage > -1 && previousActivePage < count + 1) {
                this.getHyadesEditorPart().setActivePage(previousActivePage);
            }
        }
    }

    public boolean isReadOnly() {
        return this.getHyadesEditorPart().isReadOnly();
    }

    public IActionBars getActionBars() {
        return this.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
    }

    public void notifyEdit() {
    }

    public IEditorPart getEditorPart() {
        return this.getHyadesEditorPart().getEditorPart();
    }

    public IFindReplaceTarget getFindReplaceTarget() {
        int activePage = this.getHyadesEditorPart().getActivePage();
        if (activePage <= 0) {
            return null;
        }
        if (this.findReplaceTarget == null) {
            this.findReplaceTarget = new FindReplaceTarget(activePage);
        }
        return this.findReplaceTarget;
    }

    public DatapoolTable getCurrentDatapoolTable() {
        int equivalenceClassIndex = this.getEquivalenceClassIndexFromPageIndex(this.activePageIndex);
        if (equivalenceClassIndex > -1 && equivalenceClassIndex < this.equivalenceClassPages.size()) {
            DataTableForm dataTable = (DataTableForm)this.equivalenceClassPages.get(equivalenceClassIndex);
            return dataTable.getDatapoolTable();
        }
        return null;
    }

    public void connectPart(IWorkbenchPart part) {
        DatapoolActionHandlerListener.INSTANCE.connectPart(part);
    }

    public void save() {
        if (super.getProgressMonitor() != null) {
            try {
                super.save(super.getProgressMonitor());
            }
            catch (Exception e) {
                UiPlugin.logError(e);
            }
        }
    }

    protected class DatapoolListener
    implements IDatapoolListener {
        protected DatapoolListener() {
        }

        public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex) {
        }

        public void equivalenceClassAdded(IDatapool datapool, int newEquivalenceClassIndex) {
            DatapoolEditorExtension.this.addEquivalenceClassPage(newEquivalenceClassIndex);
        }

        public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName) {
        }

        public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex) {
            DatapoolEditorExtension.this.getHyadesEditorPart().setPageText(DatapoolEditorExtension.this.getEquivalenceClassPageIndex(equivalenceClassIndex), ((IDatapoolEquivalenceClass)datapool.getEquivalenceClass(equivalenceClassIndex)).getName());
        }

        public void equivalenceClassMoved(IDatapool datapool, int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
            DatapoolEditorExtension.this.moveEquivalenceClassPage(sourceEquivalenceClassIndex, targetEquivalenceClassIndex);
        }

        public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex) {
            DatapoolEditorExtension.this.removeEquivalenceClassPage(equivalenceClassIndex);
        }

        public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex) {
        }

        public void recordAdded(IDatapool datapool, int EquivClassIndex, int newRecordIndex) {
        }

        public void recordChanged(IDatapool datapool, int EquivClassIndex, int recordIndex) {
        }

        public void recordMoved(IDatapool datapool, int EquivClassIndex, int sourceRecordIndex, int targetRecordIndex) {
        }

        public void recordRemoved(IDatapool datapool, int EquivClassIndex, int recordIndex) {
        }

        public void save(IDatapool datapool) {
        }

        public void variableAdded(IDatapool datapool, int newVariableIndex) {
        }

        public void variableChanged(IDatapool datapool, int variableIndex, String oldName) {
        }

        public void variableChanged(IDatapool datapool, int variableIndex) {
        }

        public void variableMoved(IDatapool datapool, int sourceVariableIndex, int targetVariableIndex) {
        }

        public void variableRemoved(IDatapool datapool, int variableIndex) {
        }
    }

    class FindReplaceTarget
    implements IFindReplaceTarget,
    IFindReplaceTargetExtension,
    IFindReplaceTargetExtension3 {
        private int previousActivePage = -1;
        private DatapoolTable datapoolTable = null;
        private Table table = null;
        private Pattern pattern = null;
        private Matcher matcher = null;
        private boolean isGlobalScope = true;
        private int fRetainCaseMode = 0;
        private static final int RC_MIXED = 0;
        private static final int RC_UPPER = 1;
        private static final int RC_LOWER = 2;
        private static final int RC_FIRSTUPPER = 3;

        public FindReplaceTarget(int activePage) {
            this.updatePage(activePage);
        }

        public void updatePage(int activePage) {
            if (this.previousActivePage != activePage) {
                this.previousActivePage = activePage;
                this.datapoolTable = ((DataTableForm)DatapoolEditorExtension.this.equivalenceClassPages.get(DatapoolEditorExtension.this.getEquivalenceClassIndexFromPageIndex(activePage))).getDatapoolTable();
                this.table = this.datapoolTable.getViewer().getTable();
            }
        }

        public void beginSession() {
            this.isGlobalScope = true;
        }

        public void endSession() {
            this.isGlobalScope = true;
        }

        public IRegion getScope() {
            if (!this.isGlobalScope) {
                return new Region(0, this.table.getItemCount());
            }
            return null;
        }

        public void setScope(IRegion scope) {
            this.isGlobalScope = scope == null;
        }

        public Point getLineSelection() {
            return new Point(0, this.table.getItemCount());
        }

        public Point getSelection() {
            Point tableCursorPosition = this.datapoolTable.getCursorPosition();
            return new Point(tableCursorPosition.x * this.table.getColumnCount() + tableCursorPosition.y + 1, 1);
        }

        public String getSelectionText() {
            TableCursor tableCursor = this.datapoolTable.getTableCursor();
            if (tableCursor != null && !tableCursor.isDisposed()) {
                return tableCursor.getRow().getText(tableCursor.getColumn());
            }
            return null;
        }

        public void setSelection(int offset, int length) {
        }

        public void setScopeHighlightColor(Color color) {
        }

        public void setReplaceAllMode(boolean replaceAll) {
        }

        public boolean canPerformFind() {
            return this.datapoolTable.getEquivalenceClass() != null && this.datapoolTable.getEquivalenceClass().getRecordCount() > 0 && DatapoolEditorExtension.this.getDatapool().getVariableCount() > 0;
        }

        public boolean isEditable() {
            return !DatapoolEditorExtension.this.getHyadesEditorPart().isReadOnly();
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            return this.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord, false);
        }

        public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
            block18: {
                if (findString == null || findString.length() <= 0) break block18;
                int patternFlags = 0;
                if (regExSearch) {
                    patternFlags |= 8;
                }
                if (!caseSensitive) {
                    patternFlags |= 2;
                    patternFlags |= 0x40;
                }
                if (wholeWord) {
                    findString = "\\b" + findString + "\\b";
                } else if (!regExSearch) {
                    findString = this.asRegPattern(findString);
                }
                if (this.pattern == null || !this.pattern.pattern().equals(findString) || this.pattern.flags() != patternFlags) {
                    this.pattern = Pattern.compile(findString, patternFlags);
                }
                if (searchForward) {
                    int startingRow = 0;
                    int startingColumn = 0;
                    if (offset > 0) {
                        startingRow = (offset - 1) / this.table.getColumnCount();
                        startingColumn = offset - 1 - startingRow * this.table.getColumnCount();
                    }
                    int row = startingRow;
                    while (row < this.table.getItemCount()) {
                        if (this.isGlobalScope || this.table.isSelected(row)) {
                            int column = row == startingRow ? startingColumn : 0;
                            while (column < this.table.getColumnCount()) {
                                if (this.matchTableCellText(row, column)) {
                                    return row * this.table.getColumnCount() + column + 1;
                                }
                                ++column;
                            }
                        }
                        ++row;
                    }
                } else {
                    int startingRow = this.table.getItemCount() - 1;
                    int startingColumn = this.table.getColumnCount() - 1;
                    if (offset > 0) {
                        startingRow = (offset - 1) / this.table.getColumnCount();
                        startingColumn = offset - 1 - startingRow * this.table.getColumnCount();
                    }
                    int row = startingRow;
                    while (row >= 0) {
                        if (this.isGlobalScope || this.table.isSelected(row)) {
                            int column = row == startingRow ? startingColumn : this.table.getColumnCount() - 1;
                            while (column >= 0) {
                                if (this.matchTableCellText(row, column)) {
                                    return row * this.table.getColumnCount() + column + 1;
                                }
                                --column;
                            }
                        }
                        --row;
                    }
                }
            }
            return -1;
        }

        public void replaceSelection(String text) {
            this.replaceSelection(text, false);
        }

        public void replaceSelection(String text, boolean regExReplace) {
            IDatapoolCell selectedCell;
            String replaceWithText = text;
            if (regExReplace) {
                try {
                    replaceWithText = this.interpretReplaceEscapes(text, this.matcher.group());
                }
                catch (Exception e) {
                    UiPlugin.logError(e);
                }
            }
            String replacedText = null;
            replacedText = this.matcher != null ? this.matcher.replaceAll(replaceWithText) : replaceWithText;
            TableCursor tableCursor = this.datapoolTable.getTableCursor();
            TableItem selectedTableItem = tableCursor.getRow();
            if (selectedTableItem != null && !selectedTableItem.isDisposed() && (selectedCell = this.datapoolTable.getSelectedCell()) != null) {
                selectedCell.setCellValue((Object)replacedText);
                selectedTableItem.setText(tableCursor.getColumn(), replacedText);
                tableCursor.redraw();
                this.datapoolTable.getIDatapoolPart().markDirty();
            }
        }

        private boolean matchTableCellText(int row, int column) {
            IDatapoolCell[] cells;
            TableItem tableItem;
            if (column != 0 && (tableItem = this.table.getItem(row)) != null && !tableItem.isDisposed() && (cells = (IDatapoolCell[])tableItem.getData("data")) != null && column <= cells.length && cells[column - 1] != null && !DatapoolEncryptManager.isVariableEncrypted((IDatapoolVariable)cells[column - 1].getCellVariable())) {
                this.matcher = this.pattern.matcher(tableItem.getText(column));
                if (this.matcher.find()) {
                    if (!Arrays.asList(this.table.getSelection()).contains(tableItem)) {
                        this.table.setSelection(row);
                    }
                    TableCursor cursor = this.datapoolTable.getTableCursor();
                    cursor.setSelection(row, column);
                    cursor.redraw();
                    return true;
                }
            }
            return false;
        }

        private String asRegPattern(String string) {
            StringBuffer out = new StringBuffer(string.length());
            boolean quoting = false;
            int i = 0;
            int length = string.length();
            while (i < length) {
                char ch = string.charAt(i);
                if (ch == '\\') {
                    if (quoting) {
                        out.append("\\E");
                        quoting = false;
                    }
                    out.append("\\\\");
                } else {
                    if (!quoting) {
                        out.append("\\Q");
                        quoting = true;
                    }
                    out.append(ch);
                }
                ++i;
            }
            if (quoting) {
                out.append("\\E");
            }
            return out.toString();
        }

        private String interpretReplaceEscapes(String replaceText, String foundText) {
            int length = replaceText.length();
            boolean inEscape = false;
            StringBuffer buf = new StringBuffer(length);
            this.fRetainCaseMode = 0;
            int i = 0;
            while (i < length) {
                char ch = replaceText.charAt(i);
                if (inEscape) {
                    i = this.interpretReplaceEscape(ch, i, buf, replaceText, foundText);
                    inEscape = false;
                } else if (ch == '\\') {
                    inEscape = true;
                } else if (ch == '$') {
                    buf.append(ch);
                    if (i + 2 < length) {
                        char ch1 = replaceText.charAt(i + 1);
                        char ch2 = replaceText.charAt(i + 2);
                        if (ch1 == '0' && '0' <= ch2 && ch2 <= '9') {
                            buf.append("0\\");
                            ++i;
                        }
                    }
                } else {
                    this.interpretRetainCase(buf, ch);
                }
                ++i;
            }
            if (inEscape) {
                buf.append('\\');
            }
            return buf.toString();
        }

        private int interpretReplaceEscape(char ch, int i, StringBuffer buf, String replaceText, String foundText) {
            int length = replaceText.length();
            switch (ch) {
                case 'r': {
                    buf.append('\r');
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    break;
                }
                case 't': {
                    buf.append('\t');
                    break;
                }
                case 'f': {
                    buf.append('\f');
                    break;
                }
                case 'a': {
                    buf.append('\u0007');
                    break;
                }
                case 'e': {
                    buf.append('\u001b');
                    break;
                }
                case 'R': {
                    buf.append(System.getProperty("line.separator", "\n"));
                    break;
                }
                case '0': {
                    char ch1;
                    buf.append('$').append(ch);
                    if (i + 1 >= length || '0' > (ch1 = replaceText.charAt(i + 1)) || ch1 > '9') break;
                    buf.append('\\');
                    break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    buf.append('$').append(ch);
                    break;
                }
                case 'c': {
                    if (i + 1 < length) {
                        char ch1 = replaceText.charAt(i + 1);
                        this.interpretRetainCase(buf, (char)(ch1 ^ 0x40));
                        ++i;
                        break;
                    }
                    throw new PatternSyntaxException("Illegal control escape sequence \\c", replaceText, i);
                }
                case 'x': {
                    if (i + 2 < length) {
                        int parsedInt;
                        try {
                            parsedInt = Integer.parseInt(replaceText.substring(i + 1, i + 3), 16);
                            if (parsedInt < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PatternSyntaxException("Illegal hexadecimal escape sequence " + replaceText.substring(i - 1, i + 3), replaceText, i);
                        }
                        this.interpretRetainCase(buf, (char)parsedInt);
                        i += 2;
                        break;
                    }
                    throw new PatternSyntaxException("Illegal hexadecimal escape sequence " + replaceText.substring(i - 1, length), replaceText, i);
                }
                case 'u': {
                    if (i + 4 < length) {
                        int parsedInt;
                        try {
                            parsedInt = Integer.parseInt(replaceText.substring(i + 1, i + 5), 16);
                            if (parsedInt < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new PatternSyntaxException("Illegal Unicode escape sequence " + replaceText.substring(i - 1, i + 5), replaceText, i);
                        }
                        this.interpretRetainCase(buf, (char)parsedInt);
                        i += 4;
                        break;
                    }
                    throw new PatternSyntaxException("Illegal Unicode escape sequence " + replaceText.substring(i - 1, length), replaceText, i);
                }
                case 'C': {
                    if (foundText.toUpperCase().equals(foundText)) {
                        this.fRetainCaseMode = 1;
                        break;
                    }
                    if (foundText.toLowerCase().equals(foundText)) {
                        this.fRetainCaseMode = 2;
                        break;
                    }
                    if (Character.isUpperCase(foundText.charAt(0))) {
                        this.fRetainCaseMode = 3;
                        break;
                    }
                    this.fRetainCaseMode = 0;
                    break;
                }
                default: {
                    buf.append('\\').append(ch);
                }
            }
            return i;
        }

        private void interpretRetainCase(StringBuffer buf, char ch) {
            if (this.fRetainCaseMode == 1) {
                buf.append(Character.toUpperCase(ch));
            } else if (this.fRetainCaseMode == 2) {
                buf.append(Character.toLowerCase(ch));
            } else if (this.fRetainCaseMode == 3) {
                buf.append(Character.toUpperCase(ch));
                this.fRetainCaseMode = 0;
            } else {
                buf.append(ch);
            }
        }
    }
}

