/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DeploymentTestSuitesSection;
import org.eclipse.hyades.test.ui.internal.editor.util.DeploymentCompatibilityConverter;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DeploymentForm
extends ConfigurableObjectOverviewForm {
    private int mapPageIndex;
    private NamedElementsSection artifactsSection;
    private NamedElementsSection locationsSection;
    private DeploymentTestSuitesSection testSuitesSection;

    public DeploymentForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory) {
        super(deploymentEditorExtension, widgetFactory);
        this.setHeadingText(UiPluginResourceBundle.W_DEPLOYMENT);
    }

    public void dispose() {
        if (this.artifactsSection != null) {
            this.artifactsSection.dispose();
            this.artifactsSection = null;
        }
        if (this.locationsSection != null) {
            this.locationsSection.dispose();
            this.locationsSection = null;
        }
        if (this.testSuitesSection != null) {
            this.testSuitesSection.dispose();
            this.testSuitesSection = null;
        }
        super.dispose();
    }

    public void setLocationPageIndex(int index) {
        this.mapPageIndex = index;
    }

    public Control createControl() {
        Control control = super.createControl();
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), String.valueOf(UiPlugin.getID()) + ".depf0001");
        return control;
    }

    protected void createEditorFormContents(Composite parent) {
        super.createEditorFormContents(parent);
        IConfigurationElement[] propertyGroupExtensions = ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getPropertyGroupExtensions();
        if (propertyGroupExtensions != null && propertyGroupExtensions.length > 0) {
            super.createPropertyGroupExtensionsSection(this.getLeftColumnContainer());
        }
        this.artifactsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.mapPageIndex);
        this.artifactsSection.setMoreButtonText(UiPluginResourceBundle.EDT_DEP_ART_LBL_MORE);
        this.registerSection(this.artifactsSection);
        this.artifactsSection.createControl(this.getRightColumnContainer(), this.factory, UiPluginResourceBundle.W_ARTIFACTS, UiPluginResourceBundle.EDT_DEP_ART_DSC);
        this.locationsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.mapPageIndex);
        this.locationsSection.setMoreButtonText(UiPluginResourceBundle.EDT_DEP_LOC_LBL_MORE);
        this.registerSection(this.locationsSection);
        this.locationsSection.createControl(this.getRightColumnContainer(), this.factory, UiPluginResourceBundle.W_LOCS, UiPluginResourceBundle.EDT_DEP_LOC_DSC);
        this.testSuitesSection = new DeploymentTestSuitesSection();
        this.registerSection(this.testSuitesSection);
        this.testSuitesSection.createControl(this.getRightColumnContainer(), this.factory, UiPluginResourceBundle.W_TST_SUITE, UiPluginResourceBundle.EDT_DEP_TSUITE_DSC);
    }

    protected void setGeneralInfoSectionHelp(Control control) {
        UiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(control, String.valueOf(UiPlugin.getID()) + ".depf0003");
    }

    public void load() {
        super.load();
        boolean isOld = false;
        TPFDeployment deployment = (TPFDeployment)this.getDataObject();
        this.artifactsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
        this.testSuitesSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
        if (!deployment.getLocations().isEmpty()) {
            boolean toConvert = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)UiPluginResourceBundle.DLG_UPGRADE_DEP, (String)UiPluginResourceBundle.DLG_UPGRADE_DSC);
            if (toConvert) {
                try {
                    DeploymentCompatibilityConverter.convert(deployment);
                    this.getBaseEditorExtension().markDirty();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                isOld = true;
            }
        }
        if (isOld) {
            this.locationsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), null);
        } else {
            this.locationsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), null);
        }
    }

    public void openLocationEditor(CFGLocation location) {
        IFile file = EMFUtil.getWorkspaceFile((EObject)location);
        UIUtil.openEditor((IFile)file, (String)"org.eclipse.hyades.test.ui.editor.LocationEditorPart", (boolean)false);
    }

    protected void createGeneralInfoSection(Composite parent) {
        super.createGeneralInfoSection(parent);
        this.getGeneralInfoSection().setDescription(UiPluginResourceBundle.EDT_DEP_GENERAL_DSC);
    }
}

