/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.testprofile.TPFTimedEvent;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TimedEventDetailPage
extends AbstractDetailPage {
    private StyledText endTime;
    private StyledText duration;
    private TPFTimedEvent timedEvent;

    public void dispose() {
        this.timedEvent = null;
    }

    public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context) {
        this.context = context;
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_END_TIME);
        this.endTime = widgetFactory.createStyledText(composite, 65540);
        this.endTime.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.endTime.setEditable(false);
        widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_DURATION);
        this.duration = widgetFactory.createStyledText(composite, 65540);
        this.duration.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.duration.setEditable(false);
        widgetFactory.paintBordersFor(composite);
        return composite;
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.timedEvent = null;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        boolean objectIsSet = false;
        if (object instanceof TPFTimedEvent) {
            this.timedEvent = (TPFTimedEvent)object;
            if (this.timedEvent != null) {
                objectIsSet = true;
                this.endTime.setText(EventUtil.getTime(this.timedEvent.getEndTimestamp()));
                this.duration.setText(EventUtil.getDuration(this.timedEvent.getTimestamp(), this.timedEvent.getEndTimestamp()));
            }
        }
        if (!objectIsSet) {
            this.endTime.setText("");
            this.duration.setText("");
            this.endTime.setEditable(false);
            this.duration.setEditable(false);
        }
    }

    public Object getInput() {
        return this.timedEvent;
    }
}

