/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.EventForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class VerdictEventDetailPage
extends AbstractDetailPage
implements IHyperlinkListener {
    private static final String STACK_FRAME_PATTERN = "at ";
    private StyledText verdictText;
    private StyledText reasonText;
    private SelectableFormLabel firstCausedByErrorLink;
    private Table stackTrace;
    private Composite stackGroup;
    private TPFVerdictEvent verdictEvent;

    public void dispose() {
        this.verdictEvent = null;
    }

    public Control createControl(Composite parent, FormWidgetFactory factory, IDetailPageContext context) {
        this.context = context;
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataUtil.createFill());
        widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_VERD);
        this.verdictText = widgetFactory.createStyledText(composite, 65540);
        this.verdictText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.verdictText.setEditable(false);
        widgetFactory.createLabel(composite, UiPluginResourceBundle.LBL_REASON);
        this.reasonText = widgetFactory.createStyledText(composite, 65540);
        this.reasonText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.reasonText.setEditable(false);
        this.stackGroup = widgetFactory.createComposite(composite);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 1;
        this.stackGroup.setLayout((Layout)gl);
        this.stackGroup.setLayoutData((Object)GridDataUtil.createFill());
        widgetFactory.createLabel(this.stackGroup, UiPluginResourceBundle.LBL_FAILURE_TRACE);
        this.stackTrace = widgetFactory.createTable(this.stackGroup, 4);
        GridData data = GridDataUtil.createFill();
        data.heightHint = this.stackTrace.getItemHeight() * 8;
        this.stackTrace.setLayoutData((Object)data);
        OpenStrategy handler = new OpenStrategy((Control)this.stackTrace);
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                if (VerdictEventDetailPage.this.stackTrace.getSelection().length != 0) {
                    VerdictEventDetailPage.this.openStackFrame(VerdictEventDetailPage.this.getStackTraceSelectedText());
                }
            }
        });
        widgetFactory.paintBordersFor(this.stackGroup);
        this.firstCausedByErrorLink = widgetFactory.createSelectableLabel(composite, "");
        this.firstCausedByErrorLink.setText(UiPluginResourceBundle.W_FIRSTCAUSELINK);
        this.firstCausedByErrorLink.setToolTipText(UiPluginResourceBundle.TIP_CAUSE_LINK);
        widgetFactory.turnIntoHyperlink((Control)this.firstCausedByErrorLink, this);
        this.firstCausedByErrorLink.setVisible(false);
        composite.layout();
        widgetFactory.paintBordersFor(composite);
        return composite;
    }

    private String getStackTraceSelectedText() {
        return this.stackTrace.getSelection()[0].getText();
    }

    private void openStackFrame(String traceLine) {
        try {
            String testName = traceLine;
            testName = testName.substring(testName.indexOf(STACK_FRAME_PATTERN));
            testName = testName.substring(STACK_FRAME_PATTERN.length(), testName.lastIndexOf(40)).trim();
            testName = testName.substring(0, testName.lastIndexOf(46));
            int innerSeparatorIndex = testName.indexOf(36);
            if (innerSeparatorIndex != -1) {
                testName = testName.substring(0, innerSeparatorIndex);
            }
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1, lineNumber.lastIndexOf(41));
            int line = Integer.valueOf(lineNumber);
            String cuName = traceLine.substring(traceLine.lastIndexOf(40) + 1, traceLine.lastIndexOf(58));
            this.openCompilationUnitAtLine(cuName, testName, line);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
        }
    }

    private void openCompilationUnitAtLine(String cuName, String className, int line) throws CoreException {
        IJavaElement javaElement = org.eclipse.hyades.test.core.util.JavaUtil.findElement((IJavaProject)this.getJavaProject(), (String)cuName, (String)className);
        if (javaElement != null) {
            JavaUtil.revealJavaElementAtLine((IJavaElement)javaElement, (int)line);
        }
    }

    private IJavaProject getJavaProject() {
        IFile file;
        if (this.verdictEvent != null && (file = EMFUtil.getWorkspaceFile((EObject)this.verdictEvent)) != null) {
            return JavaCore.create((IProject)file.getProject());
        }
        return null;
    }

    public void setInput(Object object) {
        IStructuredSelection structuredSelection;
        this.verdictEvent = null;
        if (object instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)object).size() == 1) {
            object = structuredSelection.getFirstElement();
        }
        boolean objectIsSet = false;
        if (object instanceof TPFVerdictEvent) {
            this.verdictEvent = (TPFVerdictEvent)object;
            if (this.verdictEvent != null) {
                objectIsSet = true;
                if (this.verdictEvent.getVerdict() != null) {
                    this.verdictText.setText(this.verdictEvent.getVerdict().getLabel());
                } else {
                    this.verdictText.setText("");
                }
                if (this.verdictEvent.getReason() != null) {
                    this.reasonText.setText(this.verdictEvent.getReason().getLabel());
                } else {
                    this.reasonText.setText("");
                }
                if (this.verdictEvent.getCausedBy() != null && !this.verdictEvent.getCausedBy().isEmpty()) {
                    if (this.firstCausedByErrorLink != null) {
                        this.firstCausedByErrorLink.setVisible(true);
                        this.firstCausedByErrorLink.setData(this.verdictEvent.getCausedBy());
                    }
                } else if (this.firstCausedByErrorLink != null) {
                    this.firstCausedByErrorLink.setVisible(false);
                }
                this.setStackTraceInput(this.verdictEvent);
            }
        }
        if (!objectIsSet) {
            this.verdictText.setText("");
            this.reasonText.setText("");
            this.verdictText.setEditable(false);
            this.reasonText.setEditable(false);
            if (this.firstCausedByErrorLink != null) {
                this.firstCausedByErrorLink.setVisible(false);
            }
            this.setStackTraceInput(null);
        }
    }

    private void addStackItem(String text, boolean isException) {
        TableItem item = new TableItem(this.stackTrace, 0);
        item.setText(text.trim());
        if (isException) {
            item.setImage(TestUIImages.INSTANCE.getImage("stkfrm_obj.gif"));
        } else {
            item.setImage(TestUIImages.INSTANCE.getImage("exc_catch.gif"));
        }
    }

    private void setStackTraceInput(TPFVerdictEvent event) {
        this.stackTrace.removeAll();
        this.stackGroup.setVisible(false);
        if (event == null) {
            return;
        }
        String trace = event.getText();
        if (trace == null) {
            return;
        }
        int end = trace.indexOf(STACK_FRAME_PATTERN);
        if (end == -1) {
            this.addStackItem(trace, false);
        } else {
            this.addStackItem(trace.substring(0, end), false);
        }
        while (end != -1) {
            int start = end;
            if ((end = trace.indexOf(STACK_FRAME_PATTERN, start + STACK_FRAME_PATTERN.length())) == -1) {
                this.addStackItem(trace.substring(start), true);
                continue;
            }
            this.addStackItem(trace.substring(start, end), true);
        }
        this.stackGroup.setVisible(true);
    }

    public Object getInput() {
        return this.verdictEvent;
    }

    public void linkActivated(Control linkLabel) {
        Object data = linkLabel.getData();
        Object verdictObj = null;
        EList verdictCauses = null;
        if (data instanceof EList) {
            verdictCauses = (EList)data;
            verdictObj = verdictCauses.get(0);
            EditorForm editorForm = this.getEditorForm();
            if (editorForm != null && editorForm instanceof EventForm) {
                ((EventForm)editorForm).revealSelect(verdictObj);
            }
        }
    }

    public void linkEntered(Control linkLabel) {
    }

    public void linkExited(Control linkLabel) {
    }
}

