/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ILayoutExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SectionChangeManager;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ToggleControl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class FormSection
extends AccessibleAdapter
implements IPropertyChangeListener {
    public static final int SELECTION = 1;
    private String headerColorKey = "__default__header__";
    private String headerText;
    protected Control client;
    protected Label header;
    protected Control separator;
    private SectionChangeManager sectionManager;
    private String description;
    private boolean dirty;
    protected Label descriptionLabel;
    protected ToggleControl toggle;
    private boolean readOnly;
    protected boolean addSeparator = true;
    protected boolean descriptionPainted = true;
    protected boolean headerPainted = true;
    protected boolean collapsable = false;
    private boolean collapsed = false;
    private int widthHint = -1;
    private int heightHint = -1;
    private Composite control;

    public FormSection() {
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    public void commitChanges(boolean onSave) {
    }

    public abstract Composite createClient(Composite var1, FormWidgetFactory var2);

    public final Control createControl(Composite parent, final FormWidgetFactory factory) {
        Composite section = factory.createComposite(parent);
        SectionLayout slayout = new SectionLayout();
        section.setLayout((Layout)slayout);
        section.setData((Object)this);
        if (this.headerPainted) {
            Color headerColor = factory.getColor(this.getHeaderColorKey());
            this.header = factory.createHeadingLabel(section, this.getHeaderText(), headerColor, 64);
            if (this.collapsable) {
                this.toggle = new ToggleControl(section, 0);
                this.toggle.setSelection(this.collapsed);
                this.toggle.setBackground(factory.getBackgroundColor());
                this.toggle.setActiveDecorationColor(factory.getHyperlinkColor());
                this.toggle.setDecorationColor(factory.getColor("__compSep"));
                this.toggle.setActiveCursor(factory.getHyperlinkCursor());
                this.toggle.addKeyListener((KeyListener)factory.getKeyboardHandler());
                this.toggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FormSection.this.doToggle();
                    }
                });
                this.header.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        FormSection.this.toggle.setSelection(!FormSection.this.toggle.getSelection());
                        FormSection.this.toggle.redraw();
                        FormSection.this.doToggle();
                    }
                });
                this.header.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent e) {
                        FormSection.this.header.setCursor(factory.getHyperlinkCursor());
                    }

                    public void mouseExit(MouseEvent e) {
                        FormSection.this.header.setCursor(null);
                    }
                });
            }
        }
        if (this.addSeparator) {
            this.separator = factory.createCompositeSeparator(section);
        }
        if (this.descriptionPainted && this.description != null) {
            this.descriptionLabel = factory.createLabel(section, this.description, 64);
        }
        this.client = this.createClient(section, factory);
        this.client.getAccessible().addAccessibleListener((AccessibleListener)this);
        section.setData((Object)this);
        this.control = section;
        return section;
    }

    protected void doToggle() {
        boolean collapsed = this.toggle.getSelection();
        this.reflow();
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setVisible(!collapsed);
        }
        if (this.client != null) {
            this.client.setVisible(!collapsed);
        }
    }

    protected void reflow() {
        this.control.setRedraw(false);
        this.control.getParent().setRedraw(false);
        this.control.layout(true);
        this.control.getParent().layout(true);
        this.control.setRedraw(true);
        this.control.getParent().setRedraw(true);
    }

    protected Text createText(Composite parent, String label, FormWidgetFactory factory) {
        return this.createText(parent, label, factory, 1);
    }

    protected Text createText(Composite parent, String label, FormWidgetFactory factory, int span) {
        factory.createLabel(parent, label);
        Text text = factory.createText(parent, "");
        int hfill = span == 1 ? 768 : 256;
        GridData gd = new GridData(hfill | 4);
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Text createText(Composite parent, String label, FormWidgetFactory factory, int span, int style) {
        Label l = factory.createLabel(parent, label);
        if ((style & 2) != 0) {
            GridData gd = new GridData(2);
            l.setLayoutData((Object)gd);
        }
        Text text = factory.createText(parent, "", style);
        int hfill = span == 1 ? 768 : 256;
        GridData gd = new GridData(hfill | 4);
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Text createText(Composite parent, FormWidgetFactory factory, int span) {
        Text text = factory.createText(parent, "");
        int hfill = span == 1 ? 768 : 256;
        GridData gd = new GridData(hfill | 4);
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    public boolean doGlobalAction(String actionId) {
        return false;
    }

    public void expandTo(Object object) {
    }

    public final void fireChangeNotification(int changeType, Object changeObject) {
        if (this.sectionManager == null) {
            return;
        }
        this.sectionManager.dispatchNotification(this, changeType, changeObject);
    }

    public final void fireSelectionNotification(Object changeObject) {
        this.fireChangeNotification(1, changeObject);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHeaderColorKey() {
        return this.headerColorKey;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public int getHeightHint() {
        return this.heightHint;
    }

    public int getWidthHint() {
        return this.widthHint;
    }

    public void initialize(Object input) {
    }

    public boolean isAddSeparator() {
        return this.addSeparator;
    }

    public boolean isDescriptionPainted() {
        return this.descriptionPainted;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isHeaderPainted() {
        return this.headerPainted;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
    }

    public void setAddSeparator(boolean newAddSeparator) {
        this.addSeparator = newAddSeparator;
    }

    private String trimNewLines(String text) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n') {
                buff.append(' ');
            } else {
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    public void setDescription(String newDescription) {
        this.description = this.trimNewLines(newDescription);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(newDescription);
        }
    }

    public void setDescriptionPainted(boolean newDescriptionPainted) {
        this.descriptionPainted = newDescriptionPainted;
    }

    public void setDirty(boolean newDirty) {
        this.dirty = newDirty;
    }

    public void setFocus() {
        if (this.toggle != null) {
            this.toggle.setFocus();
        }
    }

    public void setHeaderColorKey(String newHeaderColorKey) {
        this.headerColorKey = newHeaderColorKey;
    }

    public void setHeaderPainted(boolean newHeaderPainted) {
        this.headerPainted = newHeaderPainted;
    }

    public void setHeaderText(String newHeaderText) {
        this.headerText = newHeaderText;
        if (this.header != null) {
            this.header.setText(this.headerText);
        }
    }

    public void setHeightHint(int newHeightHint) {
        this.heightHint = newHeightHint;
    }

    void setManager(SectionChangeManager manager) {
        this.sectionManager = manager;
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
    }

    public void setWidthHint(int newWidthHint) {
        this.widthHint = newWidthHint;
    }

    public void update() {
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.control != null && this.header != null) {
            this.header.setFont(JFaceResources.getBannerFont());
            this.control.layout(true);
        }
    }

    public boolean getCollapsable() {
        return this.collapsable;
    }

    public void setCollapsable(boolean collapsable) {
        this.collapsable = collapsable;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
    }

    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    public void getDescription(AccessibleEvent e) {
        e.result = this.getDescription();
    }

    public void getHelp(AccessibleEvent e) {
        e.result = this.getDescription();
    }

    public void getName(AccessibleEvent e) {
        e.result = this.getHeaderText();
    }

    class SectionLayout
    extends Layout
    implements ILayoutExtension {
        int vspacing = 3;
        int sepHeight = 2;

        SectionLayout() {
        }

        public int getMinimumWidth(Composite parent, boolean flush) {
            return 30;
        }

        public int getMaximumWidth(Composite parent, boolean flush) {
            int maxWidth = 0;
            if (FormSection.this.client != null) {
                Point csize = FormSection.this.client.computeSize(-1, -1, flush);
                maxWidth = csize.x;
            }
            if (FormSection.this.headerPainted && FormSection.this.header != null) {
                Point hsize = FormSection.this.header.computeSize(-1, -1, flush);
                maxWidth = Math.max(maxWidth, hsize.x);
            }
            if (FormSection.this.descriptionPainted && FormSection.this.descriptionLabel != null) {
                Point dsize = FormSection.this.descriptionLabel.computeSize(-1, -1, flush);
                maxWidth = Math.max(maxWidth, dsize.x);
            }
            return maxWidth;
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flush) {
            int width = 0;
            int height = 0;
            int cwidth = 0;
            int collapsedHeight = 0;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            cwidth = width;
            if (FormSection.this.client != null) {
                Point csize = FormSection.this.client.computeSize(wHint, -1);
                if (width == 0) {
                    cwidth = width = csize.x;
                }
                if (height == 0) {
                    height = csize.y;
                }
            }
            Point toggleSize = null;
            if (FormSection.this.collapsable && FormSection.this.toggle != null) {
                toggleSize = FormSection.this.toggle.computeSize(-1, -1, flush);
            }
            if (hHint == -1 && FormSection.this.headerPainted && FormSection.this.header != null) {
                int hwidth = cwidth;
                if (toggleSize != null) {
                    hwidth = cwidth - toggleSize.x - 5;
                }
                Point hsize = FormSection.this.header.computeSize(hwidth, -1, flush);
                height += hsize.y;
                collapsedHeight = hsize.y;
                height += this.vspacing;
            }
            if (hHint == -1 && FormSection.this.addSeparator) {
                height += this.sepHeight;
                height += this.vspacing;
                collapsedHeight += this.vspacing + this.sepHeight;
            }
            if (hHint == -1 && FormSection.this.descriptionPainted && FormSection.this.descriptionLabel != null) {
                Point dsize = FormSection.this.descriptionLabel.computeSize(cwidth, -1, flush);
                height += dsize.y;
                height += this.vspacing;
            }
            if (FormSection.this.toggle != null && FormSection.this.toggle.getSelection()) {
                height = collapsedHeight;
            }
            return new Point(width, height);
        }

        protected void layout(Composite parent, boolean flush) {
            int width = parent.getClientArea().width;
            int height = parent.getClientArea().height;
            int y = 0;
            Point toggleSize = null;
            if (FormSection.this.collapsable) {
                toggleSize = FormSection.this.toggle.computeSize(-1, -1, flush);
            }
            if (FormSection.this.headerPainted && FormSection.this.header != null) {
                int availableWidth = width;
                if (toggleSize != null) {
                    availableWidth = width - toggleSize.x - 5;
                }
                Point hsize = FormSection.this.header.computeSize(availableWidth, -1, flush);
                int hx = 0;
                if (FormSection.this.toggle != null) {
                    int ty = y + hsize.y - toggleSize.y;
                    FormSection.this.toggle.setBounds(0, ty, toggleSize.x, toggleSize.y);
                    hx = toggleSize.x;
                }
                FormSection.this.header.setBounds(hx, y, availableWidth, hsize.y);
                y += hsize.y + this.vspacing;
            }
            if (FormSection.this.addSeparator && FormSection.this.separator != null) {
                FormSection.this.separator.setBounds(0, y, width, 2);
                y += this.sepHeight + this.vspacing;
            }
            if (FormSection.this.toggle != null && FormSection.this.toggle.getSelection()) {
                return;
            }
            if (FormSection.this.descriptionPainted && FormSection.this.descriptionLabel != null) {
                Point dsize = FormSection.this.descriptionLabel.computeSize(width, -1, flush);
                FormSection.this.descriptionLabel.setBounds(0, y, width, dsize.y);
                y += dsize.y + this.vspacing;
            }
            if (FormSection.this.client != null) {
                FormSection.this.client.setBounds(0, y, width, height - y);
            }
        }
    }
}

