/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.AbstractSectionForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormEngine;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkHandler;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;

public class FormWidgetFactory {
    private Hashtable<String, Color> colorRegistry = null;
    private Display display = null;
    private Color borderColor = null;
    private Color backgroundColor = null;
    private Color foregroundColor = null;
    private BorderPainter borderPainter = null;
    private HyperlinkHandler hyperlinkHandler = null;
    private KeyListener deleteListener = null;
    private KeyboardHandler keyboardHandler = null;
    public static final int BORDER_STYLE = 0;
    public static final String KEY_DRAW_BORDER = "FormWidgetFactory.drawBorder";
    public static final String TREE_BORDER = "treeBorder";
    public static final String DEFAULT_HEADER_COLOR = "__default__header__";
    public static final String COLOR_BORDER = "__border";
    public static final String COLOR_COMPOSITE_SEPARATOR = "__compSep";

    public FormWidgetFactory() {
        this(Display.getCurrent());
    }

    public FormWidgetFactory(Display display) {
        this.display = display;
        this.colorRegistry = new Hashtable();
        this.initialize();
    }

    public static ScrolledComposite getScrolledComposite(Control c) {
        Composite parent = c.getParent();
        while (parent != null) {
            if (parent instanceof ScrolledComposite) {
                return (ScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static void processKey(int keyCode, Control c) {
        ScrolledComposite scomp = FormWidgetFactory.getScrolledComposite(c);
        if (scomp != null) {
            switch (keyCode) {
                case 0x1000002: {
                    AbstractSectionForm.scrollVertical(scomp, false);
                    break;
                }
                case 0x1000001: {
                    AbstractSectionForm.scrollVertical(scomp, true);
                    break;
                }
                case 0x1000003: {
                    AbstractSectionForm.scrollHorizontal(scomp, true);
                    break;
                }
                case 0x1000004: {
                    AbstractSectionForm.scrollHorizontal(scomp, false);
                    break;
                }
                case 0x1000005: {
                    AbstractSectionForm.scrollPage(scomp, true);
                    break;
                }
                case 0x1000006: {
                    AbstractSectionForm.scrollPage(scomp, false);
                }
            }
        }
    }

    public Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style | 0x800000);
        button.setBackground(this.backgroundColor);
        button.setForeground(this.foregroundColor);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0);
    }

    public Composite createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setBackground(this.backgroundColor);
        composite.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ((Control)e.widget).setFocus();
            }
        });
        composite.setMenu(parent.getMenu());
        return composite;
    }

    public Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getColor(COLOR_COMPOSITE_SEPARATOR));
        return composite;
    }

    public Label createHeadingLabel(Composite parent, String text) {
        return this.createHeadingLabel(parent, text, null, 0);
    }

    public Label createHeadingLabel(Composite parent, String text, int style) {
        return this.createHeadingLabel(parent, text, null, style);
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg) {
        return this.createHeadingLabel(parent, text, bg, 0);
    }

    public Label createHeadingLabel(Composite parent, String text, Color bg, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.bannerfont"));
        return label;
    }

    public Label createHyperlinkLabel(Composite parent, String text, IHyperlinkListener listener) {
        return this.createHyperlinkLabel(parent, text, listener, 0);
    }

    public Label createHyperlinkLabel(Composite parent, String text, IHyperlinkListener listener, int style) {
        Label label = this.createLabel(parent, text, style);
        this.turnIntoHyperlink((Control)label, listener);
        return label;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 0);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        return label;
    }

    public SelectableFormLabel createSelectableLabel(Composite parent, String text) {
        return this.createSelectableLabel(parent, text, 0);
    }

    public SelectableFormLabel createSelectableLabel(Composite parent, String text, int style) {
        SelectableFormLabel label = new SelectableFormLabel(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        label.addKeyListener((KeyListener)this.keyboardHandler);
        return label;
    }

    public FormEngine createFormEngine(Composite parent) {
        FormEngine engine = new FormEngine(parent, 64);
        engine.setBackground(this.backgroundColor);
        engine.setForeground(this.foregroundColor);
        engine.marginWidth = 1;
        engine.marginHeight = 0;
        engine.setHyperlinkSettings(this.getHyperlinkHandler());
        engine.addKeyListener((KeyListener)this.keyboardHandler);
        engine.setMenu(parent.getMenu());
        return engine;
    }

    public Label createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 2 | style);
        label.setBackground(this.backgroundColor);
        label.setForeground(this.borderColor);
        return label;
    }

    public Table createTable(Composite parent, int style) {
        Table table = new Table(parent, style);
        table.setBackground(this.backgroundColor);
        table.setForeground(this.foregroundColor);
        this.hookDeleteListener((Control)table);
        return table;
    }

    public Text createText(Composite parent, String value) {
        return this.createText(parent, value, 4);
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = new Text(parent, style);
        if (value != null) {
            text.setText(value);
        }
        return text;
    }

    public Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, style);
        tree.setBackground(this.backgroundColor);
        tree.setForeground(this.foregroundColor);
        this.hookDeleteListener((Control)tree);
        return tree;
    }

    protected void deleteKeyPressed(Widget widget) {
        if (!(widget instanceof Control)) {
            return;
        }
        Control control = (Control)widget;
        Composite parent = control.getParent();
        while (parent != null) {
            if (parent.getData() instanceof FormSection) {
                FormSection section = (FormSection)((Object)parent.getData());
                section.doGlobalAction(ActionFactory.DELETE.getId());
                break;
            }
            parent = parent.getParent();
        }
    }

    public void dispose() {
        Enumeration<Color> colors = this.colorRegistry.elements();
        while (colors.hasMoreElements()) {
            colors.nextElement().dispose();
        }
        this.hyperlinkHandler.dispose();
        this.colorRegistry = null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Cursor getBusyCursor() {
        return this.hyperlinkHandler.getBusyCursor();
    }

    public Color getColor(String key) {
        return this.colorRegistry.get(key);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public HyperlinkHandler getHyperlinkHandler() {
        return this.hyperlinkHandler;
    }

    public Cursor getHyperlinkCursor() {
        return this.hyperlinkHandler.getHyperlinkCursor();
    }

    public Color getHyperlinkColor() {
        return this.hyperlinkHandler.getForeground();
    }

    public Color getHyperlinkHoverColor() {
        return this.hyperlinkHandler.getActiveForeground();
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkHandler.getHyperlinkUnderlineMode();
    }

    public void hookDeleteListener(Control control) {
        if (this.deleteListener == null) {
            this.deleteListener = new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\u007f' && event.stateMask == 0) {
                        FormWidgetFactory.this.deleteKeyPressed(event.widget);
                    }
                }
            };
        }
        control.addKeyListener(this.deleteListener);
    }

    private void initialize() {
        this.backgroundColor = this.display.getSystemColor(25);
        this.registerColor(COLOR_BORDER, 195, 191, 179);
        this.registerColor(COLOR_COMPOSITE_SEPARATOR, 152, 170, 203);
        this.registerColor(DEFAULT_HEADER_COLOR, 72, 112, 152);
        this.borderColor = this.isWhiteBackground() ? this.getColor(COLOR_BORDER) : this.display.getSystemColor(22);
        this.foregroundColor = this.display.getSystemColor(24);
        this.hyperlinkHandler = new HyperlinkHandler();
        this.hyperlinkHandler.setBackground(this.backgroundColor);
        this.updateHyperlinkColors();
        this.keyboardHandler = new KeyboardHandler();
    }

    public boolean isWhiteBackground() {
        return this.backgroundColor.getRed() == 255 && this.backgroundColor.getGreen() == 255 && this.backgroundColor.getBlue() == 255;
    }

    public KeyboardHandler getKeyboardHandler() {
        return this.keyboardHandler;
    }

    public void updateHyperlinkColors() {
        Color hyperlinkColor = JFaceColors.getHyperlinkText((Display)this.display);
        Color activeHyperlinkColor = JFaceColors.getActiveHyperlinkText((Display)this.display);
        this.hyperlinkHandler.setForeground(hyperlinkColor);
        this.hyperlinkHandler.setActiveForeground(activeHyperlinkColor);
    }

    public void paintBordersFor(Composite parent) {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        parent.addPaintListener((PaintListener)this.borderPainter);
    }

    public Color registerColor(String key, int r, int g, int b) {
        Color c = new Color((Device)this.display, r, g, b);
        this.colorRegistry.put(key, c);
        return c;
    }

    public void setHyperlinkColor(Color color) {
        this.hyperlinkHandler.setForeground(color);
    }

    public void setHyperlinkHoverColor(Color hoverColor) {
        this.hyperlinkHandler.setActiveForeground(hoverColor);
    }

    public void setHyperlinkUnderlineMode(int newHyperlinkUnderlineMode) {
        this.hyperlinkHandler.setHyperlinkUnderlineMode(newHyperlinkUnderlineMode);
    }

    public void turnIntoHyperlink(Control control, IHyperlinkListener listener) {
        this.hyperlinkHandler.registerHyperlink(control, listener);
    }

    protected class BorderPainter
    implements PaintListener {
        public void paintControl(PaintEvent event) {
            Control[] children = ((Composite)event.widget).getChildren();
            int counter = 0;
            while (counter < children.length) {
                block10: {
                    GC gc;
                    Rectangle rectangle;
                    boolean inactiveBorder;
                    Control control;
                    block11: {
                        control = children[counter];
                        if (control instanceof SelectableFormLabel) break block10;
                        inactiveBorder = false;
                        Object flag = control.getData(FormWidgetFactory.KEY_DRAW_BORDER);
                        if (flag == null) break block11;
                        if (flag.equals(Boolean.FALSE)) break block10;
                        if (flag.equals(FormWidgetFactory.TREE_BORDER)) {
                            inactiveBorder = true;
                        }
                    }
                    if (!inactiveBorder && (control instanceof Text || control instanceof Canvas || control instanceof CCombo)) {
                        rectangle = control.getBounds();
                        gc = event.gc;
                        gc.setForeground(control.getBackground());
                        gc.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        gc.setForeground(FormWidgetFactory.this.getForegroundColor());
                        if (control instanceof StyledText) {
                            gc.drawRectangle(rectangle.x - 2, rectangle.y - 2, rectangle.width + 2, rectangle.height + 3);
                        } else {
                            gc.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
                        }
                    } else if (inactiveBorder || control instanceof Table || control instanceof Tree || control instanceof TableTree) {
                        rectangle = control.getBounds();
                        gc = event.gc;
                        gc.setForeground(FormWidgetFactory.this.borderColor);
                        gc.drawRectangle(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                    }
                }
                ++counter;
            }
        }
    }

    class KeyboardHandler
    extends KeyAdapter {
        KeyboardHandler() {
        }

        public void keyPressed(KeyEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                FormWidgetFactory.processKey(e.keyCode, (Control)w);
            }
        }
    }
}

