/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.util.LinkedList;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SharedPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SharedPartWithButtons
extends SharedPart {
    private String[] buttonLabels;
    private Control[] controls;
    private String[] toolTips;
    private Composite buttonContainer;
    private int buttonLength;
    private final int standardButtonLength;
    private LinkedList indexList;

    public SharedPartWithButtons(String[] buttonLabels) {
        this.buttonLabels = new String[buttonLabels.length + 5];
        this.standardButtonLength = this.buttonLength = buttonLabels.length;
        System.arraycopy(buttonLabels, 0, this.buttonLabels, 0, this.buttonLength);
        this.indexList = new LinkedList();
        int i = 0;
        while (i < this.buttonLength) {
            this.indexList.add(new Integer(i));
            ++i;
        }
    }

    public SharedPartWithButtons(String[] buttonLabels, String[] toolTips) {
        this(buttonLabels);
        this.toolTips = new String[this.buttonLength + 5];
        if (toolTips != null) {
            System.arraycopy(toolTips, 0, this.toolTips, 0, this.buttonLength);
        }
    }

    public void setButtonEnabled(int index, boolean enabled) {
        Button b = this.getButton(index);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public String getButtonLabel(int index) {
        int inx = (Integer)this.indexList.get(index);
        if (inx >= 0 && inx < this.buttonLabels.length) {
            return this.buttonLabels[index];
        }
        return null;
    }

    public Menu getButtonMenu(int index) {
        Button button = this.getButton(index);
        if (button == null) {
            return null;
        }
        if (button.getMenu() == null) {
            button.setMenu(new Menu((Control)button));
        }
        return button.getMenu();
    }

    public Button getButton(int index) {
        Control c;
        int inx = (Integer)this.indexList.get(index);
        if (this.controls != null && inx >= 0 && this.controls.length > inx && (c = this.controls[inx]) instanceof Button) {
            return (Button)c;
        }
        return null;
    }

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormWidgetFactory var4);

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormToolkit var4);

    protected abstract void buttonSelected(Button var1, int var2);

    public void createControl(Composite parent, int style, int span, FormWidgetFactory factory) {
        this.createControl(parent, style, span, (Object)factory);
    }

    public void createControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.createControl(parent, style, span, (Object)toolkit);
    }

    private void createControl(Composite parent, int style, int span, Object toolkit) {
        boolean isToolkit = false;
        if (toolkit instanceof FormToolkit) {
            isToolkit = true;
        }
        if (isToolkit) {
            this.createMainLabel(parent, span, (FormToolkit)toolkit);
            this.createMainControl(parent, style, span - 1, (FormToolkit)toolkit);
        } else {
            this.createMainLabel(parent, span, (FormWidgetFactory)toolkit);
            this.createMainControl(parent, style, span - 1, (FormWidgetFactory)toolkit);
        }
        if (this.buttonLabels != null && this.buttonLength > 0) {
            this.buttonContainer = isToolkit ? this.createComposite(parent, (FormToolkit)toolkit) : this.createComposite(parent, (FormWidgetFactory)toolkit);
            GridData gd = new GridData(1040);
            this.buttonContainer.setLayoutData((Object)gd);
            this.buttonContainer.setLayout((Layout)this.createButtonsLayout());
            this.controls = new Control[this.buttonLength];
            SelectionHandler listener = new SelectionHandler();
            Object[] indexListArray = this.indexList.toArray();
            int i = 0;
            while (i < indexListArray.length) {
                int inx = (Integer)indexListArray[i];
                String label = this.buttonLabels[inx];
                if (label != null) {
                    Button button = isToolkit ? this.createButton(this.buttonContainer, label, inx, (FormToolkit)toolkit) : this.createButton(this.buttonContainer, label, inx, (FormWidgetFactory)toolkit);
                    button.addSelectionListener((SelectionListener)listener);
                    if (this.toolTips != null && this.toolTips.length > i) {
                        button.setToolTipText(this.toolTips[inx]);
                    }
                    this.controls[inx] = button;
                } else if (isToolkit) {
                    this.createEmptySpace(this.buttonContainer, 1, (FormToolkit)toolkit);
                } else {
                    this.createEmptySpace(this.buttonContainer, 1, (FormWidgetFactory)toolkit);
                }
                ++i;
            }
        }
    }

    public void addButton(String buttonLabel, String buttonToolTip, int index) {
        boolean isButtonToolTipRequired;
        ++this.buttonLength;
        boolean bl = isButtonToolTipRequired = this.toolTips != null || buttonToolTip != null;
        if (this.buttonLength >= this.buttonLabels.length) {
            String[] newButtonLabels = new String[this.buttonLength + 5];
            System.arraycopy(this.buttonLabels, 0, newButtonLabels, 0, this.buttonLength - 1);
            this.buttonLabels = newButtonLabels;
            if (isButtonToolTipRequired) {
                String[] newButtonToolTips = new String[this.buttonLength + 5];
                if (this.toolTips != null) {
                    System.arraycopy(this.toolTips, 0, newButtonToolTips, 0, this.buttonLength - 1);
                }
                this.toolTips = newButtonToolTips;
            }
        }
        if (isButtonToolTipRequired && this.toolTips == null) {
            this.toolTips = new String[this.buttonLength + 5];
        }
        this.buttonLabels[this.buttonLength - 1] = buttonLabel;
        this.toolTips[this.buttonLength - 1] = buttonToolTip;
        if (index < 0) {
            index = 0;
        }
        if (index > this.indexList.size()) {
            index = this.indexList.size();
        }
        this.indexList.add(index, new Integer(this.buttonLength - 1));
    }

    protected GridLayout createButtonsLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected Button createButton(Composite parent, String label, int index, FormWidgetFactory factory) {
        Button button;
        if (factory != null) {
            button = factory.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.setData((Object)new Integer(index));
        return button;
    }

    protected Button createButton(Composite parent, String label, int index, FormToolkit factory) {
        Button button;
        if (factory != null) {
            button = factory.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.setData((Object)new Integer(index));
        return button;
    }

    protected void updateEnabledState() {
        int i = 0;
        while (i < this.controls.length) {
            Control c = this.controls[i];
            if (c instanceof Button) {
                c.setEnabled(this.isEnabled());
            }
            ++i;
        }
    }

    protected void createMainLabel(Composite parent, int span, FormWidgetFactory factory) {
    }

    protected void createMainLabel(Composite parent, int span, FormToolkit factory) {
    }

    public int getButtonLength() {
        return this.buttonLength;
    }

    public int getStandardButtonLength() {
        return this.standardButtonLength;
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        private void buttonSelected(SelectionEvent e) {
            Integer index = (Integer)e.widget.getData();
            SharedPartWithButtons.this.buttonSelected((Button)e.widget, index);
        }
    }
}

