/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.BulletParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.HyperlinkSettings;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IHyperlinkSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraphSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextModel;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ImageSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Paragraph;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TextModel
implements ITextModel {
    Vector paragraphs;
    IHyperlinkListener urlListener;
    IHyperlinkSegment[] hyperlinks;
    int selectedLinkIndex = -1;
    HyperlinkSettings hyperlinkSettings;

    public TextModel() {
        this.reset();
    }

    public IParagraph[] getParagraphs() {
        if (this.paragraphs == null) {
            return new IParagraph[0];
        }
        return this.paragraphs.toArray(new IParagraph[this.paragraphs.size()]);
    }

    public String getAccessibleText() {
        if (this.paragraphs == null) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < this.paragraphs.size()) {
            IParagraph paragraph = (IParagraph)this.paragraphs.get(i);
            String text = paragraph.getAccessibleText();
            sbuf.append(text);
            ++i;
        }
        return sbuf.toString();
    }

    public void parseTaggedText(String taggedText, boolean expandURLs) throws CoreException {
        if (taggedText == null) {
            this.reset();
            return;
        }
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(taggedText.getBytes("UTF8"));
            this.parseInputStream(stream, expandURLs);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public void parseInputStream(InputStream is, boolean expandURLs) throws CoreException {
        XSDParser parser = new XSDParser();
        this.reset();
        InputSource source = new InputSource(is);
        parser.parse(source);
        this.processDocument(parser.getDocument(), expandURLs);
    }

    private void processDocument(Document doc, boolean expandURLs) {
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            IParagraph p;
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                String text = child.getNodeValue();
                if (text != null && !this.isIgnorableWhiteSpace(text, true)) {
                    p = new Paragraph(true);
                    p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), null);
                    this.paragraphs.add(p);
                }
            } else if (child.getNodeType() == 1) {
                String tag = child.getNodeName().toLowerCase();
                if (tag.equals("p")) {
                    p = this.processParagraph(child, expandURLs);
                    if (p != null) {
                        this.paragraphs.add(p);
                    }
                } else if (tag.equals("li") && (p = this.processListItem(child, expandURLs)) != null) {
                    this.paragraphs.add(p);
                }
            }
            ++i;
        }
    }

    private IParagraph processParagraph(Node paragraph, boolean expandURLs) {
        NodeList children = paragraph.getChildNodes();
        NamedNodeMap atts = paragraph.getAttributes();
        Node addSpaceAtt = atts.getNamedItem("addVerticalSpace");
        boolean addSpace = true;
        if (addSpaceAtt != null) {
            String value = addSpaceAtt.getNodeValue();
            addSpace = value.equalsIgnoreCase("true");
        }
        Paragraph p = new Paragraph(addSpace);
        this.processSegments(p, children, expandURLs);
        return p;
    }

    private IParagraph processListItem(Node listItem, boolean expandURLs) {
        String value;
        NodeList children = listItem.getChildNodes();
        NamedNodeMap atts = listItem.getAttributes();
        Node addSpaceAtt = atts.getNamedItem("addVerticalSpace");
        Node styleAtt = atts.getNamedItem("style");
        Node valueAtt = atts.getNamedItem("value");
        Node indentAtt = atts.getNamedItem("indent");
        int style = 0;
        int indent = -1;
        String text = null;
        boolean addSpace = true;
        if (addSpaceAtt != null) {
            value = addSpaceAtt.getNodeValue();
            addSpace = value.equalsIgnoreCase("true");
        }
        if (styleAtt != null) {
            value = styleAtt.getNodeValue();
            if (value.equalsIgnoreCase("text")) {
                style = 1;
            } else if (value.equalsIgnoreCase("image")) {
                style = 2;
            }
        }
        if (valueAtt != null) {
            text = valueAtt.getNodeValue();
        }
        if (indentAtt != null) {
            value = indentAtt.getNodeValue();
            try {
                indent = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        BulletParagraph p = new BulletParagraph(addSpace);
        p.setIndent(indent);
        p.setBulletStyle(style);
        p.setBulletText(text);
        this.processSegments(p, children, expandURLs);
        return p;
    }

    private void processSegments(Paragraph p, NodeList children, boolean expandURLs) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            IParagraphSegment segment = null;
            if (child.getNodeType() == 3) {
                String value = child.getNodeValue();
                if (value != null && !this.isIgnorableWhiteSpace(value, false)) {
                    p.parseRegularText(value, expandURLs, this.getHyperlinkSettings(), null);
                }
            } else if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                if (name.equalsIgnoreCase("img")) {
                    segment = this.processImageSegment(child);
                } else if (name.equalsIgnoreCase("a")) {
                    segment = this.processHyperlinkSegment(child, this.getHyperlinkSettings());
                } else if (name.equalsIgnoreCase("text")) {
                    this.processTextSegment(p, expandURLs, child);
                } else if (name.equalsIgnoreCase("b")) {
                    String text = this.getNodeText(child).trim();
                    String fontId = "org.eclipse.jface.bannerfont";
                    p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), fontId);
                }
            }
            if (segment != null) {
                p.addSegment(segment);
            }
            ++i;
        }
    }

    private boolean isIgnorableWhiteSpace(String text, boolean ignoreSpaces) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!(ignoreSpaces && c == ' ' || c == '\n' || c == '\r' || c == '\f')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private IParagraphSegment processImageSegment(Node image) {
        String value;
        ImageSegment segment = new ImageSegment();
        NamedNodeMap atts = image.getAttributes();
        Node id = atts.getNamedItem("href");
        Node align = atts.getNamedItem("align");
        if (id != null) {
            value = id.getNodeValue();
            segment.setObjectId(value);
        }
        if (align != null) {
            value = align.getNodeValue().toLowerCase();
            if (value.equals("top")) {
                segment.setVerticalAlignment(1);
            } else if (value.equals("middle")) {
                segment.setVerticalAlignment(2);
            } else if (value.equals("bottom")) {
                segment.setVerticalAlignment(3);
            }
        }
        return segment;
    }

    private String getNodeText(Node node) {
        NodeList children = node.getChildNodes();
        String text = "";
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                text = String.valueOf(text) + child.getNodeValue();
            }
            ++i;
        }
        return text;
    }

    private IParagraphSegment processHyperlinkSegment(Node link, HyperlinkSettings settings) {
        Node arg;
        String text = this.getNodeText(link);
        HyperlinkSegment segment = new HyperlinkSegment(text, settings, null);
        NamedNodeMap atts = link.getAttributes();
        Node href = atts.getNamedItem("href");
        if (href != null) {
            String value = href.getNodeValue();
            segment.setActionId(value);
        }
        if ((arg = atts.getNamedItem("arg")) != null) {
            String value = arg.getNodeValue();
            segment.setArg(value);
        }
        return segment;
    }

    private void processTextSegment(Paragraph p, boolean expandURLs, Node textNode) {
        String text = this.getNodeText(textNode).trim();
        NamedNodeMap atts = textNode.getAttributes();
        Node font = atts.getNamedItem("font");
        String fontId = null;
        if (font != null) {
            fontId = font.getNodeValue();
        }
        p.parseRegularText(text, expandURLs, this.getHyperlinkSettings(), fontId);
    }

    public void parseRegularText(String regularText, boolean convertURLs) throws CoreException {
        this.reset();
        if (regularText == null) {
            return;
        }
        Paragraph p = new Paragraph(true);
        this.paragraphs.add(p);
        int pstart = 0;
        int i = 0;
        while (i < regularText.length()) {
            char c = regularText.charAt(i);
            if (p == null) {
                p = new Paragraph(true);
                this.paragraphs.add(p);
            }
            if (c == '\n') {
                String text = regularText.substring(pstart, i);
                pstart = i + 1;
                p.parseRegularText(text, convertURLs, this.getHyperlinkSettings(), null);
                p = null;
            }
            ++i;
        }
        if (p != null) {
            String text = regularText.substring(pstart);
            p.parseRegularText(text, convertURLs, this.getHyperlinkSettings(), null);
        }
    }

    public HyperlinkSettings getHyperlinkSettings() {
        if (this.hyperlinkSettings == null) {
            this.hyperlinkSettings = new LocalHyperlinkSettings();
        }
        return this.hyperlinkSettings;
    }

    public void setHyperlinkSettings(HyperlinkSettings settings) {
        this.hyperlinkSettings = settings;
    }

    public void setURLListener(IHyperlinkListener urlListener) {
        this.urlListener = urlListener;
    }

    private void reset() {
        if (this.paragraphs == null) {
            this.paragraphs = new Vector();
        }
        this.paragraphs.clear();
        this.selectedLinkIndex = -1;
        this.hyperlinks = null;
    }

    IHyperlinkSegment[] getHyperlinks() {
        if (this.hyperlinks != null || this.paragraphs == null) {
            return this.hyperlinks;
        }
        Vector<IParagraphSegment> result = new Vector<IParagraphSegment>();
        int i = 0;
        while (i < this.paragraphs.size()) {
            IParagraph p = (IParagraph)this.paragraphs.get(i);
            IParagraphSegment[] segments = p.getSegments();
            int j = 0;
            while (j < segments.length) {
                if (segments[j] instanceof IHyperlinkSegment) {
                    result.add(segments[j]);
                }
                ++j;
            }
            ++i;
        }
        this.hyperlinks = result.toArray(new IHyperlinkSegment[result.size()]);
        return this.hyperlinks;
    }

    public IHyperlinkSegment findHyperlinkAt(int x, int y) {
        IHyperlinkSegment[] links = this.getHyperlinks();
        int i = 0;
        while (i < links.length) {
            if (links[i].contains(x, y)) {
                return links[i];
            }
            ++i;
        }
        return null;
    }

    public ITextSegment findSegmentAt(int x, int y) {
        int i = 0;
        while (i < this.paragraphs.size()) {
            IParagraph p = (IParagraph)this.paragraphs.get(i);
            ITextSegment segment = p.findSegmentAt(x, y);
            if (segment != null) {
                return segment;
            }
            ++i;
        }
        return null;
    }

    public IHyperlinkSegment getSelectedLink() {
        if (this.selectedLinkIndex == -1) {
            return null;
        }
        return this.hyperlinks[this.selectedLinkIndex];
    }

    public boolean traverseLinks(boolean next) {
        IHyperlinkSegment[] links = this.getHyperlinks();
        if (links == null) {
            return false;
        }
        int size = links.length;
        this.selectedLinkIndex = next ? ++this.selectedLinkIndex : --this.selectedLinkIndex;
        if (this.selectedLinkIndex < 0 || this.selectedLinkIndex > size - 1) {
            this.selectedLinkIndex = -1;
        }
        return this.selectedLinkIndex != -1;
    }

    public void selectLink(IHyperlinkSegment link) {
        if (link == null) {
            this.selectedLinkIndex = -1;
        } else {
            IHyperlinkSegment[] links = this.getHyperlinks();
            this.selectedLinkIndex = -1;
            if (links == null) {
                return;
            }
            int i = 0;
            while (i < links.length) {
                if (links[i].equals(link)) {
                    this.selectedLinkIndex = i;
                    break;
                }
                ++i;
            }
        }
    }

    public boolean hasFocusSegments() {
        IHyperlinkSegment[] links = this.getHyperlinks();
        return links.length > 0;
    }

    public void dispose() {
        if (this.hyperlinkSettings instanceof LocalHyperlinkSettings) {
            this.hyperlinkSettings.dispose();
        }
    }

    class LocalHyperlinkSettings
    extends HyperlinkSettings {
        LocalHyperlinkSettings() {
        }
    }
}

