/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.TreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.DrillDownAdapter;

public class EObjectTreeSection
extends TreeSection {
    private EStructuralFeature eStructuralFeature;
    protected DrillDownAdapter drillDownAdapter;
    protected CollapseAllAction collapseAllAction;
    protected IAction addAction;
    protected IAction insertAction;
    protected RemoveChildrenAction removeAction;
    protected MoveChildrenUpAction moveUpAction;
    protected MoveChildrenDownAction moveDownAction;
    private Separator workbenchAdditionsGroup;

    public EObjectTreeSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, IAction addAction) {
        super(editorForm);
        this.eStructuralFeature = eStructuralFeature;
        this.addAction = addAction;
        this.workbenchAdditionsGroup = new Separator("additions");
        String name = null;
        if (addAction != null) {
            name = addAction.getText();
        }
        this.adjustButtonLabels(name);
    }

    public void dispose() {
        this.eStructuralFeature = null;
        if (this.drillDownAdapter != null) {
            this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.drillDownAdapter);
            this.drillDownAdapter = null;
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.dispose();
            this.collapseAllAction = null;
        }
        if (this.removeAction != null) {
            this.removeAction.dispose();
            this.removeAction = null;
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.dispose();
            this.moveUpAction = null;
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.dispose();
            this.moveDownAction = null;
        }
        this.workbenchAdditionsGroup.dispose();
        this.addAction = null;
        this.insertAction = null;
        super.dispose();
    }

    protected EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    protected void adjustButtonLabels(String addLabel) {
        this.removeAction = new RemoveChildrenAction(false);
        this.moveUpAction = new MoveChildrenUpAction();
        this.moveDownAction = new MoveChildrenDownAction();
        this.setButtonLabels(new String[]{addLabel, this.removeAction.getText(), this.moveUpAction.getText(), this.moveDownAction.getText()});
    }

    protected void adjustButtonLabels(String addLabel, String insertLabel) {
        this.removeAction = new RemoveChildrenAction(false);
        this.moveUpAction = new MoveChildrenUpAction();
        this.moveDownAction = new MoveChildrenDownAction();
        this.setButtonLabels(new String[]{addLabel, insertLabel, this.removeAction.getText(), this.moveUpAction.getText(), this.moveDownAction.getText()}, new String[]{UiPluginResourceBundle.TOOLTIP_ADD, UiPluginResourceBundle.TOOLTIP_INSERT, UiPluginResourceBundle.TOOLTIP_REMOVE, UiPluginResourceBundle.TOOLTIP_UP, UiPluginResourceBundle.TOOLTIP_DOWN});
    }

    protected void setAddAction(IAction addAction) {
        this.addAction = addAction;
    }

    protected void setInsertAction(IAction insertAction) {
        this.insertAction = insertAction;
    }

    protected void adjustClient(Composite parent) {
        this.getTreeViewer().setContentProvider(this.createContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.getTreeViewer().setAutoExpandLevel(0);
        if (this.addAction != null) {
            this.getTreePart().setButtonEnabled(0, this.addAction.isEnabled());
        }
        if (this.insertAction != null) {
            this.getTreePart().setButtonEnabled(1, this.insertAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
        if (this.removeAction != null) {
            this.removeAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
    }

    protected IContentProvider createContentProvider() {
        return new EObjectContainerContentProvider(this.getEditorForm(), this.getEStructuralFeature());
    }

    protected ILabelProvider createLabelProvider() {
        return new WorkbenchAdapterLabelProvider(TestWorkbenchAdapter.class);
    }

    protected void createActions() {
        this.collapseAllAction = new CollapseAllAction(this.getTreeViewer()).useDefaultDecorators();
        this.drillDownAdapter = new DrillDownAdapter(this.getTreeViewer());
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.drillDownAdapter);
        if (this.removeAction != null) {
            this.removeAction.setEnabled(false);
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveDownAction.setEnabled(false);
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveUpAction.setEnabled(false);
        }
    }

    protected void buttonSelected(int index) {
        if (!this.isReadOnly()) {
            switch (index) {
                case 0: {
                    this.doAdd();
                    break;
                }
                case 1: {
                    this.doRemove();
                    break;
                }
                case 2: {
                    this.doMoveUp();
                    break;
                }
                case 3: {
                    this.doMoveDown();
                }
            }
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    protected void doAdd() {
        if (this.addAction != null) {
            this.addAction.run();
        }
    }

    protected void doInsert() {
        if (this.insertAction != null) {
            this.insertAction.run();
        }
    }

    protected void doRemove() {
        if (this.removeAction != null) {
            this.removeAction.run();
        }
    }

    protected void doMoveUp() {
        if (this.moveUpAction != null) {
            this.moveUpAction.run();
        }
    }

    protected void doMoveDown() {
        if (this.moveDownAction != null) {
            this.moveDownAction.run();
        }
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            if (this.removeAction != null) {
                this.removeAction.run();
            }
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        if (this.removeAction != null) {
            if (this.removeAction.isEnabled()) {
                this.removeAction.setEnabled(!this.isReadOnly());
            }
            menuManager.add((IAction)this.removeAction);
            menuManager.add((IContributionItem)new Separator());
        }
        boolean enableCollapse = false;
        TreeItem[] treeItems = this.getTreeViewer().getTree().getItems();
        int i = 0;
        int maxi = treeItems.length;
        while (i < maxi) {
            if (treeItems[i].getExpanded()) {
                enableCollapse = true;
                break;
            }
            ++i;
        }
        if (enableCollapse) {
            menuManager.add((IAction)this.collapseAllAction);
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IContributionItem)this.workbenchAdditionsGroup);
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
        if (this.addAction != null) {
            if (this.addAction instanceof SelectionListenerAction) {
                ((SelectionListenerAction)this.addAction).selectionChanged(structuredSelection);
            }
            this.getTreePart().setButtonEnabled(0, this.addAction.isEnabled());
        }
        if (this.removeAction != null) {
            this.removeAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(1, this.removeAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(3, this.moveDownAction.isEnabled());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(2, this.moveUpAction.isEnabled());
        }
    }

    public static class EObjectContainerContentProvider
    extends AdapterImpl
    implements ITreeContentProvider {
        private EStructuralFeature eStructuralFeature;
        private EObject container;
        private Viewer viewer;
        private EditorForm editorForm;
        private Map eStructuralFeatureByClass;

        public EObjectContainerContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
            this.eStructuralFeature = eStructuralFeature;
            this.editorForm = editorForm;
        }

        public void dispose() {
            if (this.container != null) {
                this.container.eAdapters().remove((Object)this);
                Object value = this.container.eGet(this.eStructuralFeature);
                this.deregisterInputAdapters(this.container, value);
                this.container = null;
            }
            this.viewer = null;
            this.eStructuralFeature = null;
            this.editorForm = null;
            if (this.eStructuralFeatureByClass != null) {
                this.eStructuralFeatureByClass.clear();
            }
        }

        protected EObject getContainer() {
            return this.container;
        }

        public void registerParent(Class cls, EStructuralFeature eStructuralFeature) {
            if (this.eStructuralFeatureByClass == null) {
                this.eStructuralFeatureByClass = new HashMap();
            }
            this.eStructuralFeatureByClass.put(cls, eStructuralFeature);
        }

        public void deregisterParent(Class cls) {
            if (this.eStructuralFeatureByClass != null) {
                this.eStructuralFeatureByClass.remove(cls);
            }
        }

        protected Object getRegisteredParentChild(Object parent) {
            if (this.eStructuralFeatureByClass != null) {
                for (Map.Entry entry : this.eStructuralFeatureByClass.entrySet()) {
                    if (!((Class)entry.getKey()).isInstance(parent)) continue;
                    if (parent instanceof EObject) {
                        return ((EObject)parent).eGet((EStructuralFeature)entry.getValue());
                    }
                    return null;
                }
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
            if (this.container != null) {
                this.container.eAdapters().remove((Object)this);
                Object value = this.container.eGet(this.eStructuralFeature);
                this.deregisterInputAdapters(this.container, value);
                this.container = null;
            }
            if (newInput instanceof EObject) {
                EObject eObject = (EObject)newInput;
                if (this.eStructuralFeature.eContainer() == eObject.eClass()) {
                    this.container = eObject;
                    this.container.eAdapters().add((Object)this);
                    this.registerInputAdapters(eObject, this.container.eGet(this.eStructuralFeature));
                }
            }
        }

        protected Viewer getViewer() {
            return this.viewer;
        }

        protected void deregisterInputAdapters(EObject oldInput, Object value) {
            if (value instanceof Collection) {
                EMFUtil.removeAdapter(((Collection)value).iterator(), (Adapter)this);
            } else if (value != null) {
                ((Notifier)value).eAdapters().remove((Object)this);
            }
        }

        protected void registerInputAdapters(EObject newInput, Object value) {
            if (value instanceof List) {
                EMFUtil.addAdapter(((List)value).iterator(), (Adapter)this);
            } else if (value != null) {
                ((Notifier)value).eAdapters().add((Object)this);
            }
        }

        public Object getParent(Object element) {
            if (this.container == element) {
                return null;
            }
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (this.container == null) {
                return new Object[0];
            }
            if (this.eStructuralFeature.isMany()) {
                return ((List)this.container.eGet(this.eStructuralFeature)).toArray();
            }
            return new Object[]{this.container.eGet(this.eStructuralFeature)};
        }

        public boolean hasChildren(Object element) {
            if (this.container == null) {
                return false;
            }
            if (!this.eStructuralFeature.isMany()) {
                return false;
            }
            if (this.container == element) {
                List values = (List)this.container.eGet(this.eStructuralFeature);
                return !values.isEmpty();
            }
            Object child = this.getRegisteredParentChild(element);
            return child != null;
        }

        public Object[] getChildren(Object parentElement) {
            Object child = this.getRegisteredParentChild(parentElement);
            if (child != null) {
                if (child instanceof Collection) {
                    return ((Collection)child).toArray();
                }
                return new Object[]{child};
            }
            return new Object[0];
        }

        public void notifyChanged(final Notification msg) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    return;
                }
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    EObjectContainerContentProvider.this.editorForm.getBaseEditorExtension().markDirty();
                    EObjectContainerContentProvider.this.adjustModel(msg);
                    EObjectContainerContentProvider.this.adjustAdapter(msg);
                    EObjectContainerContentProvider.this.updateViewer(msg);
                }
            };
            if (Display.getDefault() == Display.getCurrent()) {
                runnable.run();
            } else {
                Display.getDefault().asyncExec(runnable);
            }
        }

        protected void adjustModel(Notification msg) {
        }

        protected boolean shouldAdjustAdapter(Notification msg) {
            return msg.getNotifier() == this.container && msg.getFeature() == this.eStructuralFeature;
        }

        protected void adjustAdapter(Notification msg) {
            if (this.shouldAdjustAdapter(msg)) {
                switch (msg.getEventType()) {
                    case 3: {
                        ((Notifier)msg.getNewValue()).eAdapters().add((Object)this);
                        break;
                    }
                    case 5: {
                        EMFUtil.addAdapter(((Collection)msg.getNewValue()).iterator(), (Adapter)this);
                        break;
                    }
                    case 4: {
                        ((Notifier)msg.getOldValue()).eAdapters().remove((Object)this);
                        break;
                    }
                    case 6: {
                        EMFUtil.removeAdapter(((Collection)msg.getOldValue()).iterator(), (Adapter)this);
                    }
                }
            }
        }

        protected boolean shouldUpdateViewer(Notification msg) {
            return msg.getFeature() == this.eStructuralFeature;
        }

        protected void updateViewer(Notification msg) {
            if (this.getViewer() == null) {
                return;
            }
            if (!(this.getViewer() instanceof StructuredViewer)) {
                this.getViewer().refresh();
                return;
            }
            if (msg.getNotifier() != this.container) {
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        this.attributeChanged(msg);
                        return;
                    }
                }
            }
            if (!(this.getViewer() instanceof TreeViewer)) {
                this.getViewer().refresh();
                return;
            }
            if (this.shouldUpdateViewer(msg)) {
                Object parent = null;
                switch (msg.getEventType()) {
                    case 3: {
                        parent = this.getParent(msg.getNewValue());
                        if (parent == null) {
                            parent = this.getViewer().getInput();
                        }
                        ((TreeViewer)this.getViewer()).add(parent, msg.getNewValue());
                        this.getViewer().setSelection((ISelection)new StructuredSelection(msg.getNewValue()), true);
                        break;
                    }
                    case 5: {
                        Object[] addedObjects = ((Collection)msg.getNewValue()).toArray();
                        parent = this.getParent(addedObjects[0]);
                        if (parent == null) {
                            parent = this.getViewer().getInput();
                        }
                        ((TreeViewer)this.getViewer()).add(parent, addedObjects);
                        this.getViewer().setSelection((ISelection)new StructuredSelection(addedObjects), true);
                        break;
                    }
                    case 4: {
                        ((TreeViewer)this.getViewer()).remove(msg.getOldValue());
                        Object value = ((EObject)msg.getNotifier()).eGet((EStructuralFeature)msg.getFeature());
                        if (value instanceof List) {
                            List values = (List)value;
                            if (values.isEmpty()) {
                                this.getViewer().getControl().setFocus();
                                break;
                            }
                            int position = msg.getPosition();
                            position = position < values.size() ? position : values.size() - 1;
                            this.getViewer().setSelection((ISelection)new StructuredSelection(values.get(position)), true);
                            break;
                        }
                        this.getViewer().getControl().setFocus();
                        break;
                    }
                    case 6: {
                        ((TreeViewer)this.getViewer()).remove(((Collection)msg.getOldValue()).toArray());
                        this.getViewer().getControl().setFocus();
                        break;
                    }
                    case 7: {
                        this.getViewer().refresh();
                    }
                }
            }
        }

        protected void attributeChanged(Notification msg) {
            ((StructuredViewer)this.getViewer()).update(msg.getNotifier(), null);
        }
    }
}

