/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailsPageProvider;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class EditorEclipseForm
extends FormPage {
    private IEditorExtension formEditor;
    private String editorTitle;

    public EditorEclipseForm(IEditorExtension editor, String editorTitle, String id, String title) {
        super((FormEditor)editor.getHyadesEditorPart(), id, title);
        this.formEditor = editor;
        this.editorTitle = editorTitle;
    }

    protected Composite createColumn(Composite parent) {
        FormToolkit toolKit = ((FormEditor)this.formEditor.getHyadesEditorPart()).getToolkit();
        Composite column = toolKit.createComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        GridData gd = GridDataUtil.createFill();
        column.setLayoutData((Object)gd);
        return column;
    }

    public boolean activated() {
        return false;
    }

    public void updateTitle() {
    }

    protected ITestSuite getCommonTestSuite() {
        return (TPFTestSuite)this.formEditor.getHyadesEditorPart().getEditorObject();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText(this.editorTitle);
        Composite parent = form.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        GridData gd = GridDataUtil.createFill();
        parent.setLayoutData((Object)gd);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        this.createLeftColumnControls(leftColumn);
        this.createRightColumnControls(rightColumn);
    }

    protected abstract void createRightColumnControls(Composite var1);

    protected abstract void createLeftColumnControls(Composite var1);

    public IEditorExtension getFormEditor() {
        return this.formEditor;
    }

    protected void addDetails(DetailsPageProvider detailProvider) {
    }

    public String getEditorTitle() {
        return this.editorTitle;
    }

    protected void markEditorDirty() {
        if (this.formEditor instanceof BaseEditorExtension) {
            ((BaseEditorExtension)this.formEditor).markDirty();
        }
    }

    protected ScrolledForm getForm() {
        if (this.getManagedForm() != null) {
            return this.getManagedForm().getForm();
        }
        return null;
    }
}

