/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.action.GetNextFailAction;
import org.eclipse.hyades.test.ui.internal.action.GetPrevFailAction;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EventLabelProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;

public class EventSection
extends EObjectTreeSection {
    protected GetNextFailAction getNextFailAction;
    protected GetPrevFailAction getPrevFailAction;

    public EventSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, IAction addAction) {
        super(editorForm, eStructuralFeature, addAction);
    }

    protected IContentProvider createContentProvider() {
        return new EventContentProvider(this.getEditorForm(), this.getEStructuralFeature());
    }

    protected void adjustButtonLabels(String addLabel) {
        this.setButtonLabels(new String[]{UiPluginResourceBundle.LBL_PREV_ERROR, UiPluginResourceBundle.LBL_NEXT_ERROR}, new String[]{UiPluginResourceBundle.TOOLTIP_PREV_ERROR, UiPluginResourceBundle.TOOLTIP_NEXT_ERROR});
        this.getNextFailAction = new GetNextFailAction();
        this.getPrevFailAction = new GetPrevFailAction();
    }

    protected void buttonSelected(int index) {
        if (!this.isReadOnly()) {
            switch (index) {
                case 0: {
                    this.doGetPrevFail();
                    break;
                }
                case 1: {
                    this.doGetNextFail();
                }
            }
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    protected void doGetPrevFail() {
        if (this.getPrevFailAction != null) {
            this.getPrevFailAction.run();
        }
    }

    protected void doGetNextFail() {
        if (this.getNextFailAction != null) {
            this.getNextFailAction.run();
        }
    }

    public void dispose() {
        this.getNextFailAction = null;
        this.getPrevFailAction = null;
        super.dispose();
    }

    protected ILabelProvider createLabelProvider() {
        return new EventLabelProvider();
    }

    public void setGetNextFailAction(GetNextFailAction getNextFailAction) {
        this.getNextFailAction = getNextFailAction;
    }

    public void setGetPrevFailAction(GetPrevFailAction getPrevFailAction) {
        this.getPrevFailAction = getPrevFailAction;
    }

    protected void createActions() {
        super.createActions();
        EventContentProvider ecp = new EventContentProvider(this.getEditorForm(), this.getEStructuralFeature());
        if (this.getPrevFailAction != null) {
            this.getPrevFailAction.setEcp(ecp);
            this.getPrevFailAction.setEnabled(false);
        }
        if (this.getNextFailAction != null) {
            this.getNextFailAction.setEcp(ecp);
            this.getNextFailAction.setEnabled(false);
        }
    }

    protected void adjustClient(Composite parent) {
        this.getTreeViewer().setContentProvider(this.createContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.getTreeViewer().setAutoExpandLevel(0);
        if (this.getPrevFailAction != null) {
            // empty if block
        }
        this.getPrevFailAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        if (this.getNextFailAction != null) {
            // empty if block
        }
        this.getNextFailAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
        if (this.getNextFailAction != null) {
            this.getNextFailAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(1, this.getNextFailAction.isEnabled());
        }
        if (this.getPrevFailAction != null) {
            this.getPrevFailAction.selectionChanged(structuredSelection);
            this.getTreePart().setButtonEnabled(0, this.getPrevFailAction.isEnabled());
        }
    }

    protected String getPopupMenuId() {
        return "#events";
    }

    public static class EventContentProvider
    extends EObjectTreeSection.EObjectContainerContentProvider {
        public EventContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
            super(editorForm, eStructuralFeature);
        }

        protected Object getRegisteredParentChild(Object parent) {
            if (parent instanceof TPFExecutionResult) {
                TPFExecutionResult executionResult = (TPFExecutionResult)parent;
                if (executionResult.getExecutionHistory() != null) {
                    return executionResult.getExecutionHistory().getExecutionEvents();
                }
                return null;
            }
            if (parent instanceof TPFExecutionEvent) {
                if (parent instanceof TPFInvocationEvent) {
                    TPFInvocationEvent invocationEvent = (TPFInvocationEvent)parent;
                    return invocationEvent.getInvokedExecutionResult();
                }
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)parent;
                if (executionEvent.getChildren() != null && !executionEvent.getChildren().isEmpty()) {
                    return executionEvent.getChildren();
                }
            }
            return super.getRegisteredParentChild(parent);
        }

        public Object getParent(Object element) {
            if (element instanceof TPFExecutionResult) {
                TPFExecutionResult executionResult = (TPFExecutionResult)element;
                if (executionResult.getInvocationExecutionEvent() != null) {
                    return executionResult.getInvocationExecutionEvent();
                }
            } else if (element instanceof TPFExecutionEvent) {
                TPFExecutionEvent executionEvent = (TPFExecutionEvent)element;
                if (executionEvent.eContainer() instanceof TPFExecutionHistory) {
                    TPFExecutionHistory exhis = (TPFExecutionHistory)executionEvent.eContainer();
                    TPFExecutionResult exres = exhis.getExecutionResult();
                    if (exres.eContainer() == null) {
                        return exhis;
                    }
                    return exhis.getExecutionResult();
                }
                return executionEvent.eContainer();
            }
            return super.getParent(element);
        }
    }
}

