/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPageFactory;
import org.eclipse.hyades.test.ui.editor.form.util.IEventLabelProvider;
import org.eclipse.hyades.test.ui.forms.extensions.IEventAction;
import org.eclipse.hyades.test.ui.forms.extensions.IPropertyLabelProvider;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IVerdictCategoryProvider;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.forms.IDetailsPage;
import org.osgi.framework.Bundle;

public class ExecutionHistoryExtensionsManager {
    public static final String ALL_TEST_TYPES = "allTestTypes";
    protected static final String EXTENSION_ELEMENT_EVENT_EXTENSION = "eventExtension";
    protected static final String EXTENSION_ELEMENT_ACTION_EXTENSION = "actionExtension";
    protected static final String EXTENSION_ELEMENT_ACTION = "action";
    protected static final String EXTENSION_ELEMENT_PROPERTY = "property";
    protected static final String EXTENSION_ELEMENT_VERDICT_PROVIDER = "verdictProvider";
    protected static final String EXTENSION_ATTRIBUTE_TEST_TYPE = "testType";
    protected static final String EXTENSION_ATTRIBUTE_EVENT_TYPE = "eventType";
    protected static final String EXTENSION_ATTRIBUTE_EVENT_LABEL_PROVIDER = "labelProvider";
    protected static final String EXTENSION_ATTRIBUTE_EVENT_DETAILS_PAGE = "detailsPage";
    protected static final String EXTENSION_ATTRIBUTE_ACTION = "action";
    protected static final String EXTENSION_ATTRIBUTE_ACTION_TEXT = "text";
    protected static final String EXTENSION_ATTRIBUTE_ACTION_ICON = "icon";
    protected static final String EXTENSION_ATTRIBUTE_ACTION_ASBUTTON = "asButton";
    protected static final String EXTENSION_ATTRIBUTE_ACTION_ASMENU = "asContextMenu";
    protected static final String EXTENSION_ATTRIBUTE_PROP_NAME = "name";
    protected static final String EXTENSION_ATTRIBUTE_PROP_VISIBLE = "visible";
    protected static final String EXTENSION_ATTRIBUTE_PROP_UNLESS = "unless";
    protected static final String EXTENSION_ATTRIBUTE_PROP_UNIT = "unit";
    protected static final String EXTENSION_ATTRIBUTE_PROVIDER = "provider";
    protected static final String EXTENSION_ATTRIBUTE_PROP_PROVIDER = "propertyProvider";
    protected static final String TEST_TYPE_DELIMINATOR = ";";
    private static ExecutionHistoryExtensionsManager instance;
    private Hashtable testTypeToEventActionsMap;
    private Hashtable eventTypeToEventExtensionMap;
    private Hashtable testTypeToVerdictProviderMap;

    public static ExecutionHistoryExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ExecutionHistoryExtensionsManager();
        }
        return instance;
    }

    private ExecutionHistoryExtensionsManager() {
        this.loadFromRegistry();
    }

    private void loadFromRegistry() {
        this.testTypeToEventActionsMap = new Hashtable();
        this.eventTypeToEventExtensionMap = new Hashtable();
        this.testTypeToVerdictProviderMap = new Hashtable();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".executionHistoryExtension");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                String testType;
                IConfigurationElement element = members[i];
                if (EXTENSION_ELEMENT_EVENT_EXTENSION.equals(element.getName())) {
                    String eventType = element.getAttribute(EXTENSION_ATTRIBUTE_EVENT_TYPE);
                    EventExtension eventExt = (EventExtension)this.eventTypeToEventExtensionMap.get(eventType);
                    if (eventExt == null) {
                        this.eventTypeToEventExtensionMap.put(eventType, new EventExtension(eventType, element));
                    } else {
                        eventExt.addExtension(element);
                    }
                } else if (EXTENSION_ELEMENT_ACTION_EXTENSION.equals(element.getName())) {
                    String testTypes = element.getAttribute(EXTENSION_ATTRIBUTE_TEST_TYPE);
                    EventAction[] extensions = null;
                    if (testTypes != null) {
                        StringTokenizer testType2 = new StringTokenizer(testTypes, TEST_TYPE_DELIMINATOR);
                        while (testType2.hasMoreTokens()) {
                            IConfigurationElement[] childrenElements;
                            String token = testType2.nextToken().trim();
                            extensions = (EventAction[])this.testTypeToEventActionsMap.get(token);
                            if (extensions == null) {
                                extensions = new EventAction[]{};
                            }
                            if ((childrenElements = element.getChildren("action")) != null) {
                                EventAction[] temp = new EventAction[extensions.length + childrenElements.length];
                                int j = 0;
                                while (j < childrenElements.length) {
                                    temp[j] = new EventAction(childrenElements[j]);
                                    ++j;
                                }
                                if (extensions.length > 0) {
                                    System.arraycopy(extensions, 0, temp, childrenElements.length, extensions.length);
                                }
                                extensions = temp;
                            }
                            this.testTypeToEventActionsMap.put(token, extensions);
                        }
                    }
                } else if (EXTENSION_ELEMENT_VERDICT_PROVIDER.equals(element.getName()) && (testType = element.getAttribute(EXTENSION_ATTRIBUTE_TEST_TYPE)) != null && testType.trim().length() > 0) {
                    this.testTypeToVerdictProviderMap.put(testType, element);
                }
                ++i;
            }
        }
    }

    public IEventLabelProvider getEventLabelFactory(String eventType) {
        return this.getEventLabelProvider(eventType);
    }

    public IEventLabelProvider getEventLabelProvider(String eventType) {
        if (eventType == null) {
            return null;
        }
        EventExtension extension = (EventExtension)this.eventTypeToEventExtensionMap.get(eventType);
        return extension == null ? null : extension.getLabelProvider();
    }

    public IDetailsPage getEventDetailsPage(EObject eObject) {
        String eventType = null;
        if (eObject instanceof TPFExecutionEvent) {
            eventType = ((TPFExecutionEvent)eObject).getEventType();
        } else if (eObject instanceof TPFExecutionResult) {
            eventType = ((TPFExecutionResult)eObject).getType();
        }
        if (eventType == null) {
            return null;
        }
        EventExtension extension = (EventExtension)this.eventTypeToEventExtensionMap.get(eventType);
        return extension == null ? null : extension.getDetailsPage(eObject);
    }

    public Property getEventProperty(String eventType, String propName) {
        if (eventType == null || propName == null) {
            return null;
        }
        EventExtension extension = (EventExtension)this.eventTypeToEventExtensionMap.get(eventType);
        if (extension != null) {
            return extension.getProperty(propName);
        }
        return null;
    }

    public EventAction[] getEventActions(String testType) {
        if (testType == null || ALL_TEST_TYPES.equals(testType)) {
            ArrayList<EventAction> actions = new ArrayList<EventAction>();
            Collection values = this.testTypeToEventActionsMap.values();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                actions.addAll(Arrays.asList((EventAction[])it.next()));
            }
            return actions.toArray(new EventAction[actions.size()]);
        }
        return (EventAction[])this.testTypeToEventActionsMap.get(testType);
    }

    public IVerdictCategoryProvider getVerdictProvider(String testType) {
        if (testType != null) {
            Object provider = this.testTypeToVerdictProviderMap.get(testType);
            if (provider instanceof IConfigurationElement) {
                try {
                    Object obj = ((IConfigurationElement)provider).createExecutableExtension(EXTENSION_ATTRIBUTE_PROVIDER);
                    if (obj instanceof IVerdictCategoryProvider) {
                        this.testTypeToVerdictProviderMap.put(testType, obj);
                        return (IVerdictCategoryProvider)obj;
                    }
                }
                catch (Throwable t) {
                    UiPlugin.logError(t);
                }
            } else if (provider instanceof IVerdictCategoryProvider) {
                return (IVerdictCategoryProvider)provider;
            }
        }
        return null;
    }

    public IDetailPageFactory getEventDetailPageFactory(String eventType) {
        return null;
    }

    public IDetailPageFactory getResultDetailPageFactory(String resultType) {
        return null;
    }

    public class EventAction {
        private IConfigurationElement configElement;
        private String actionText = null;
        private ImageDescriptor actionImage = null;
        private IEventAction action = null;

        public EventAction(IConfigurationElement configElement) {
            if (!"action".equals(configElement.getName())) {
                throw new IllegalArgumentException();
            }
            this.configElement = configElement;
        }

        public String getActionText() {
            if (this.actionText == null) {
                this.actionText = this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_ACTION_TEXT);
            }
            return this.actionText;
        }

        public ImageDescriptor getActionImage() {
            String imageKey;
            if (this.actionImage == null && (imageKey = this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_ACTION_ICON)) != null) {
                this.actionImage = UIUtil.getImageDescriptorFromPlugin((Bundle)Platform.getBundle((String)this.configElement.getDeclaringExtension().getNamespace()), (String)imageKey);
                if (this.actionImage != null) {
                    UiPlugin.getInstance().getImageRegistry().put(imageKey, this.actionImage);
                }
            }
            return this.actionImage;
        }

        public boolean isActionButton() {
            return Boolean.valueOf(this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_ACTION_ASBUTTON));
        }

        public boolean isActionContextMenu() {
            return Boolean.valueOf(this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_ACTION_ASMENU));
        }

        public IEventAction getAction() {
            String attr;
            if (this.action == null && (attr = this.configElement.getAttribute("action")) != null && !"".equals(attr)) {
                try {
                    this.action = (IEventAction)this.configElement.createExecutableExtension("action");
                    this.action.setText(this.getActionText());
                }
                catch (Throwable t) {
                    UiPlugin.logError(t);
                }
            }
            return this.action;
        }
    }

    private class EventExtension {
        private List configElements;
        private String eventType;
        private boolean isLableProviderCalculated = false;
        private IEventLabelProvider labelProvider;
        private Hashtable eobjectToPageMap;
        private Hashtable properties;
        private IPropertyLabelProvider propProvider;
        private boolean isPropProviderCalculated = false;

        public EventExtension(String eventType, IConfigurationElement configElement) {
            if (!ExecutionHistoryExtensionsManager.EXTENSION_ELEMENT_EVENT_EXTENSION.equals(configElement.getName()) || !eventType.equals(configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_EVENT_TYPE))) {
                throw new IllegalArgumentException();
            }
            this.eventType = eventType;
            this.configElements = new ArrayList();
            this.configElements.add(configElement);
            this.eobjectToPageMap = new Hashtable();
        }

        public void addExtension(IConfigurationElement configElement) {
            if (!ExecutionHistoryExtensionsManager.EXTENSION_ELEMENT_EVENT_EXTENSION.equals(configElement.getName()) || !this.eventType.equals(configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_EVENT_TYPE))) {
                throw new IllegalArgumentException();
            }
            this.configElements.add(configElement);
        }

        public IEventLabelProvider getLabelProvider() {
            if (!this.isLableProviderCalculated) {
                try {
                    int i = 0;
                    while (i < this.configElements.size()) {
                        IConfigurationElement configElement = (IConfigurationElement)this.configElements.get(i);
                        String provider = configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_EVENT_LABEL_PROVIDER);
                        if (provider != null) {
                            this.labelProvider = (IEventLabelProvider)configElement.createExecutableExtension(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_EVENT_LABEL_PROVIDER);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    UiPlugin.logError(t);
                }
                this.isLableProviderCalculated = true;
            }
            return this.labelProvider;
        }

        public IDetailsPage getDetailsPage(EObject eObject) {
            IDetailsPage page = (IDetailsPage)this.eobjectToPageMap.get(eObject);
            if (page == null) {
                try {
                    int i = 0;
                    while (i < this.configElements.size()) {
                        IConfigurationElement configElement = (IConfigurationElement)this.configElements.get(i);
                        String pageClass = configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_EVENT_DETAILS_PAGE);
                        if (pageClass != null) {
                            page = (IDetailsPage)configElement.createExecutableExtension(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_EVENT_DETAILS_PAGE);
                            this.eobjectToPageMap.put(eObject, page);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    UiPlugin.logError(t);
                }
            }
            return page;
        }

        public Property getProperty(String propertyName) {
            if (propertyName == null) {
                return null;
            }
            if (this.properties == null) {
                this.properties = new Hashtable();
                int j = 0;
                while (j < this.configElements.size()) {
                    IConfigurationElement configElement = (IConfigurationElement)this.configElements.get(j);
                    IConfigurationElement[] children = configElement.getChildren(ExecutionHistoryExtensionsManager.EXTENSION_ELEMENT_PROPERTY);
                    int i = 0;
                    while (i < children.length) {
                        String name = children[i].getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_PROP_NAME);
                        if (name != null) {
                            this.properties.put(name, new Property(children[i], this.getPropertyProvider()));
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            return (Property)this.properties.get(propertyName);
        }

        public IPropertyLabelProvider getPropertyProvider() {
            if (!this.isPropProviderCalculated) {
                try {
                    int i = 0;
                    while (i < this.configElements.size()) {
                        IConfigurationElement configElement = (IConfigurationElement)this.configElements.get(i);
                        String provider = configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_PROP_PROVIDER);
                        if (provider != null) {
                            this.propProvider = (IPropertyLabelProvider)configElement.createExecutableExtension(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_PROP_PROVIDER);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    UiPlugin.logError(t);
                }
                this.isPropProviderCalculated = true;
            }
            return this.propProvider;
        }
    }

    public class Property {
        private IConfigurationElement configElement;
        private String name;
        private String isVisibleUnless;
        private String unit;
        private IPropertyLabelProvider provider;

        public Property(IConfigurationElement element, IPropertyLabelProvider propProvider) {
            if (!ExecutionHistoryExtensionsManager.EXTENSION_ELEMENT_PROPERTY.equals(element.getName())) {
                throw new IllegalArgumentException();
            }
            this.configElement = element;
            this.provider = propProvider;
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_PROP_NAME);
            }
            return this.name;
        }

        public boolean isVisible() {
            return Boolean.valueOf(this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_PROP_VISIBLE));
        }

        public String getVisibleUnless() {
            if (this.isVisibleUnless == null) {
                this.isVisibleUnless = this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_PROP_UNLESS);
            }
            return this.isVisibleUnless;
        }

        public String getUnit() {
            if (this.unit == null) {
                this.unit = this.configElement.getAttribute(ExecutionHistoryExtensionsManager.EXTENSION_ATTRIBUTE_PROP_UNIT);
            }
            return this.unit;
        }

        public IPropertyLabelProvider getProvider() {
            return this.provider;
        }
    }
}

