/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class GeneralInfoSection
extends NamedElementSection {
    private StyledText fileText;
    boolean displayResourceFileInfo = false;
    private boolean editable;

    public GeneralInfoSection(EditorForm editorForm, boolean hasResourceFileInfo) {
        super(editorForm);
        this.displayResourceFileInfo = hasResourceFileInfo;
        this.setHeaderText(UiPluginResourceBundle.EDT_GENERAL_INFO);
        this.setDescription(UiPluginResourceBundle.EDT_GENERAL_DSC);
    }

    public void dispose() {
        super.dispose();
        this.fileText.dispose();
    }

    protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
        if (!this.displayResourceFileInfo) {
            return;
        }
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite detailComposite = widgetFactory.createComposite(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        detailComposite.setLayout((Layout)gridLayout);
        detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(detailComposite, UiPluginResourceBundle.L_FILE);
        this.fileText = widgetFactory.createStyledText(detailComposite, 65540);
        this.fileText.setEnabled(false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
    }

    public void setInput(Object object) {
        IStructuredSelection selection;
        super.setInput(object);
        if (!this.displayResourceFileInfo) {
            return;
        }
        if (object instanceof IStructuredSelection && (selection = (IStructuredSelection)object).size() == 1) {
            String filePath = EMFUtil.getFilePath((EObject)((EObject)selection.getFirstElement()));
            this.getFileText().setText(filePath);
        }
        if (object instanceof EObject) {
            this.getFileText().setText(EMFUtil.getFilePath((EObject)((EObject)object)));
        }
        this.setEditable(this.editable);
    }

    protected StyledText getFileText() {
        return this.fileText;
    }

    public void setEditable(boolean isEditable) {
        this.editable = isEditable;
        if (this.getNameTextField() != null) {
            this.getNameTextField().setEditable(this.editable);
        }
        if (this.getDescriptionTextField() != null) {
            this.getDescriptionTextField().setEditable(this.editable);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }
}

