/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class GeneralStructureViewer {
    protected StructuredViewerPart viewerPart;
    private boolean handleDefaultButton;
    protected IEditorExtension editorPart;

    public GeneralStructureViewer(IEditorExtension editorPart) {
        this.editorPart = editorPart;
    }

    protected void createActions() {
    }

    protected abstract StructuredViewerPart createViewerPart(String[] var1);

    protected StructuredViewerPart createViewerPart(String[] buttonLabels, String[] toolTips) {
        return null;
    }

    protected void createViewerPartControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.viewerPart.createControl(parent, style, span, toolkit);
        this.createActions();
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                GeneralStructureViewer.this.fillContextMenu(menuManager);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Control control = this.viewerPart.getControl();
        Menu menu = popupMenuManager.createContextMenu(control);
        control.setMenu(menu);
    }

    public void dispose() {
        this.viewerPart = null;
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    protected void entryModified(Object entry, String value) {
    }

    protected void fillContextMenu(IMenuManager menuManager) {
    }

    public Object getInput() {
        return this.getViewerPart().getViewer().getInput();
    }

    protected String getPopupMenuId() {
        return null;
    }

    public IStructuredSelection getStructuredSelection() {
        return (IStructuredSelection)this.getViewerPart().getViewer().getSelection();
    }

    protected StructuredViewerPart getViewerPart() {
        return this.viewerPart;
    }

    protected void handleDoubleClick(IStructuredSelection structuredSelection) {
    }

    protected boolean isHandlingDefaultButton() {
        return this.handleDefaultButton;
    }

    protected void selectionChanged(IStructuredSelection structuredSelection) {
    }

    public void selectReveal(ISelection selection) {
        if (UIUtil.areEquals((ISelection)this.getStructuredSelection(), (ISelection)selection)) {
            return;
        }
        this.getViewerPart().getViewer().setSelection(selection, true);
    }

    public void setFocus() {
        this.getViewerPart().getViewer().getControl().setFocus();
    }

    protected void setHandleDefaultButton(boolean handle) {
        this.handleDefaultButton = handle;
    }

    public void setInput(Object object) {
        this.getViewerPart().getViewer().setInput(object);
        if (object != null) {
            this.updateActionsAndButtons((IStructuredSelection)new StructuredSelection(object));
        } else {
            this.updateActionsAndButtons((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected void setButtonLabels(String[] buttonLabels) {
        this.setButtonLabels(buttonLabels, null);
    }

    protected void setButtonLabels(String[] buttonLabels, String[] tooltips) {
        if (this.viewerPart != null) {
            return;
        }
        this.viewerPart = this.createViewerPart(buttonLabels, tooltips);
        this.viewerPart.setMinimumSize(50, 50);
    }

    protected void updateActionsAndButtons(IStructuredSelection structuredSelection) {
    }
}

