/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.model.CMNNamedElementUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class NamedElementLink
implements IHyperlinkListener,
CMNNamedElementUtil.NameChangeObserver,
DisposeListener {
    private IEditorExtension editorExtension;
    private int destinationPage;
    private CMNNamedElementUtil.NameChangeAdapter adapter;
    private SelectableFormLabel hyperlink;
    private String prefix;
    private ILabelProvider labelProvider;
    private Label imageLabel;

    public NamedElementLink(IEditorExtension editorExtension, int destinationPage) {
        this.editorExtension = editorExtension;
        this.destinationPage = destinationPage;
        this.prefix = "";
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.widget == this.hyperlink) {
            CMNNamedElement namedElement = (CMNNamedElement)this.hyperlink.getData();
            namedElement.eAdapters().remove((Object)this.adapter);
            this.adapter.dispose();
            this.adapter = null;
            this.hyperlink.removeDisposeListener(this);
            this.hyperlink.setData(null);
            this.hyperlink = null;
            this.editorExtension = null;
        } else if (e.widget == this.imageLabel) {
            Image image = this.imageLabel.getImage();
            if (image != null) {
                image.dispose();
            }
            this.imageLabel = null;
        }
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setHoverMessagePrefix(String head) {
        this.prefix = head == null ? "" : String.valueOf(head) + " # ";
    }

    public void create(FormWidgetFactory widgetFactory, Composite parent, CMNNamedElement namedElement) {
        if (this.hyperlink != null) {
            return;
        }
        ImageDescriptor imageDescriptor = null;
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)namedElement.getAdapter(IWorkbenchAdapter.class);
        if (workbenchAdapter != null) {
            imageDescriptor = workbenchAdapter.getImageDescriptor((Object)namedElement);
        }
        if (imageDescriptor == null) {
            imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor("unchecked_obj.gif");
        }
        this.imageLabel = widgetFactory.createLabel(parent, "");
        this.imageLabel.setImage(imageDescriptor.createImage());
        this.imageLabel.addDisposeListener((DisposeListener)this);
        String name = namedElement.getName();
        if (name == null) {
            name = "";
        }
        String tooltip = name;
        String label = name;
        if (this.labelProvider != null) {
            label = this.labelProvider.getText((Object)namedElement);
        }
        this.hyperlink = widgetFactory.createSelectableLabel(parent, label);
        widgetFactory.turnIntoHyperlink((Control)this.hyperlink, this);
        this.hyperlink.addDisposeListener(this);
        this.hyperlink.setToolTipText(tooltip);
        this.hyperlink.setData(namedElement);
        this.adapter = new CMNNamedElementUtil.NameChangeAdapter(this);
        namedElement.eAdapters().add((Object)this.adapter);
    }

    public void linkActivated(Control linkLabel) {
        this.editorExtension.getHyadesEditorPart().setActivePage(this.destinationPage);
        this.editorExtension.setSelection((IStructuredSelection)new StructuredSelection(linkLabel.getData()));
    }

    public void linkEntered(Control linkLabel) {
        IActionBars actionBars = this.editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        if (manager != null) {
            manager.setMessage(String.valueOf(this.prefix) + ((SelectableFormLabel)linkLabel).getText());
        }
    }

    public void linkExited(Control linkLabel) {
        IActionBars actionBars = this.editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.setMessage("");
    }

    public void update(CMNNamedElement namedElement, String oldName) {
        String name = namedElement.getName();
        if (name == null) {
            name = "";
        }
        this.hyperlink.setText(name);
        this.hyperlink.setToolTipText(name);
        this.hyperlink.pack();
        this.hyperlink.getParent().pack(true);
    }
}

