/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.forms.extensions.provisional.IRecordRepositoryProvider;

public class TestLogExtensionsManager {
    protected static final String EXTENSION_ELEMENT_PROVIDER = "provider";
    protected static final String EXTENSION_ELEMENT_UNLESS = "unless";
    protected static final String EXTENSION_ATTRIBUTE_TYPE = "type";
    protected static final String EXTENSION_ATTRIBUTE_CLASS = "class";
    protected static final String EXTENSION_ATTRIBUTE_TEST_TYPE = "testType";
    protected static final String EXTENSION_ATTRIBUTE_PROVIDER_TYPE = "providerType";
    private static TestLogExtensionsManager instance;
    private DefectProviderExtension[] defectProviderExtensions;
    private Map unless;

    private TestLogExtensionsManager() {
        this.load();
    }

    public static TestLogExtensionsManager getInstance() {
        if (instance == null) {
            instance = new TestLogExtensionsManager();
        }
        return instance;
    }

    private void load() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testLogRecordRepositoryProvider");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            ArrayList<DefectProviderExtension> providers = new ArrayList<DefectProviderExtension>();
            this.unless = new Hashtable();
            int i = 0;
            while (i < members.length) {
                IConfigurationElement element = members[i];
                if (EXTENSION_ELEMENT_PROVIDER.equals(element.getName())) {
                    providers.add(new DefectProviderExtension(element));
                } else if (EXTENSION_ELEMENT_UNLESS.equals(element.getName())) {
                    String testType = element.getAttribute(EXTENSION_ATTRIBUTE_TEST_TYPE);
                    ArrayList<String> providerTypes = (ArrayList<String>)this.unless.get(testType);
                    if (providerTypes == null) {
                        providerTypes = new ArrayList<String>();
                        this.unless.put(testType, providerTypes);
                    }
                    providerTypes.add(element.getAttribute(EXTENSION_ATTRIBUTE_PROVIDER_TYPE));
                }
                ++i;
            }
            this.defectProviderExtensions = providers.toArray(new DefectProviderExtension[providers.size()]);
        }
    }

    public DefectProviderExtension[] getDefectProviderExtensions() {
        return this.defectProviderExtensions;
    }

    public String[] getDisabledProviders(String testType) {
        List providers = (List)this.unless.get(testType);
        if (providers == null) {
            return new String[0];
        }
        return providers.toArray(new String[providers.size()]);
    }

    public class DefectProviderExtension {
        private IConfigurationElement config;
        private String type;
        private IRecordRepositoryProvider provider;

        public DefectProviderExtension(IConfigurationElement configElement) {
            this.config = configElement;
        }

        public String getType() {
            if (this.type == null) {
                this.type = this.config.getAttribute(TestLogExtensionsManager.EXTENSION_ATTRIBUTE_TYPE);
            }
            return this.type;
        }

        public IRecordRepositoryProvider getProvider(boolean createNew) {
            if (this.provider != null && !createNew) {
                return this.provider;
            }
            try {
                this.provider = (IRecordRepositoryProvider)this.config.createExecutableExtension(TestLogExtensionsManager.EXTENSION_ATTRIBUTE_CLASS);
            }
            catch (Exception e) {
                UiPlugin.logError(e);
            }
            return this.provider;
        }
    }
}

