/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.core.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class DeploymentProvider
extends LabelProvider
implements IStructuredContentProvider,
IElementComparer {
    public TPFDeployment[] getDeployments(Object testElement) {
        if (testElement == null) {
            return new TPFDeployment[0];
        }
        if (testElement instanceof TPFTestSuite || testElement instanceof TPFTestComponent) {
            IDeploymentsProvider provider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(testElement);
            return provider.getDeployments(testElement);
        }
        return new TPFDeployment[0];
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof TPFTestSuite || inputElement instanceof TPFTestComponent) {
            return this.getDeployments(inputElement);
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        return TestUIImages.INSTANCE.getImage("deployment_obj.gif");
    }

    public String getText(Object element) {
        if (element instanceof TPFDeployment) {
            return ((TPFDeployment)element).getName();
        }
        return "<invalid deployment>";
    }

    public boolean equals(Object a, Object b) {
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof TPFDeployment && b instanceof TPFDeployment) {
            TPFDeployment ao = (TPFDeployment)a;
            TPFDeployment bo = (TPFDeployment)b;
            String ai = ao.getId();
            String bi = bo.getId();
            Resource ar = ao.eResource();
            Resource br = bo.eResource();
            if (ar == null && br == null && ai != null && bi != null) {
                return ai.equals(bi);
            }
            return ar != null && br != null && ar.getURI().equals((Object)br.getURI()) && ar.getURIFragment((EObject)ao).equals(br.getURIFragment((EObject)bo));
        }
        return false;
    }

    public int hashCode(Object element) {
        return element.hashCode();
    }
}

