/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.core.launch.extensions.IExecutionResultsLocationFilter;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExecutionHistoryLocationProvider
extends LabelProvider
implements ITreeContentProvider {
    private IExecutionResultsLocationFilter filter;

    public ExecutionHistoryLocationProvider(IExecutionResultsLocationFilter filter) {
        this.filter = filter;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            try {
                IContainer container = (IContainer)parentElement;
                IResource[] members = container.members();
                ArrayList<IContainer> children = new ArrayList<IContainer>(members.length);
                int i = 0;
                while (i < members.length) {
                    IContainer member;
                    if (!(!(members[i] instanceof IContainer) || (member = (IContainer)members[i]) instanceof IProject && !((IProject)member).isOpen() || this.filter != null && this.filter.isFiltered(member) || TestNavigator.getFiltersManager().filter(member))) {
                        children.add(member);
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return new Object[0];
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor;
        IWorkbenchAdapter workbenchAdapter;
        if (element instanceof IContainer && (workbenchAdapter = this.getWorkbenchAdapter(element)) != null && (descriptor = workbenchAdapter.getImageDescriptor(element)) != null) {
            return descriptor.createImage();
        }
        return null;
    }

    public String getText(Object element) {
        IWorkbenchAdapter workbenchAdapter;
        if (element instanceof IContainer && (workbenchAdapter = this.getWorkbenchAdapter(element)) != null) {
            return workbenchAdapter.getLabel(element);
        }
        return null;
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
        if (workbenchAdapter == this) {
            return null;
        }
        return workbenchAdapter;
    }
}

