/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.providers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TestComponentProvider
extends LabelProvider
implements ITreeContentProvider {
    private String mode;
    private String launchConfigurationType;

    public TestComponentProvider(String mode, String launchConfigurationType) {
        this.mode = mode;
        this.launchConfigurationType = launchConfigurationType;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            try {
                IContainer container = (IContainer)parentElement;
                IResource[] members = container.members();
                ArrayList<Object> children = new ArrayList<Object>(members.length);
                int i = 0;
                while (i < members.length) {
                    IFile file;
                    if (members[i] instanceof IContainer) {
                        children.add(members[i]);
                    } else if (members[i] instanceof IFile && "testcomponent".equals((file = (IFile)members[i]).getFileExtension())) {
                        EObject[] objs = EMFUtil.getEObjects(null, (IFile)file);
                        TPFTestComponent testComponent = null;
                        int j = 0;
                        while (j < objs.length) {
                            if (objs[j] != null && objs[j] instanceof TPFTestComponent) {
                                testComponent = (TPFTestComponent)objs[j];
                                break;
                            }
                            ++j;
                        }
                        if (testComponent != null && this.isLaunchable(testComponent)) {
                            children.add(testComponent);
                        }
                    }
                    ++i;
                }
                return children.toArray();
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return new Object[0];
            }
        }
        if (parentElement instanceof TPFTestComponent) {
            return new Object[0];
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof TPFTestComponent) {
            IFile file = EMFUtil.getWorkspaceFile((EObject)((TPFTestComponent)element));
            return file;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        if (element instanceof IContainer) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null && (descriptor = workbenchAdapter.getImageDescriptor(element)) != null) {
                return descriptor.createImage();
            }
        } else if (element instanceof TPFTestComponent) {
            return TestUIImages.INSTANCE.getImage("testcomponent_obj.gif");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IContainer) {
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null) {
                return workbenchAdapter.getLabel(element);
            }
        } else if (element instanceof TPFTestComponent) {
            return ((TPFTestComponent)element).getName();
        }
        return null;
    }

    private boolean isLaunchable(TPFTestComponent testComponent) {
        return LaunchConfigurationExtensionsManager.getInstance().isLaunchableElement((Object)testComponent, this.mode, this.launchConfigurationType);
    }

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
        if (workbenchAdapter == this) {
            return null;
        }
        return workbenchAdapter;
    }
}

