/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.shortcuts;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;

public class LaunchPropertyTester
extends PropertyTester {
    public static final String PROPERTY_IS_LAUNCHABLE = "isLaunchable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (PROPERTY_IS_LAUNCHABLE.equals(property)) {
            String mode;
            if (args.length == 0) {
                mode = "run";
            } else if (args[0] instanceof String) {
                mode = (String)args[0];
            } else {
                UiPlugin.logError("Invalid arg passed to isLaunchable property: " + args[0]);
                return false;
            }
            return new Boolean(LaunchPropertyTester.getRunnableItemFromElement(receiver, mode, false) != null).equals(expectedValue);
        }
        return false;
    }

    public static Object getRunnableItemFromElement(Object element, String mode) {
        return LaunchPropertyTester.getRunnableItemFromElement(element, mode, true);
    }

    public static Object getRunnableItemFromElement(Object element, String mode, boolean forceLoad) {
        Object candidateElement = null;
        if (element instanceof TPFTestSuite || element instanceof TPFTestCase || element instanceof TPFTestComponent) {
            candidateElement = element;
        } else if (element instanceof IFile) {
            EObject[] eobjs;
            IFile file = (IFile)element;
            if ("testsuite".equals(file.getFileExtension())) {
                eobjs = EMFUtil.load(null, (IFile)file);
                int i = 0;
                while (i < eobjs.length) {
                    if (eobjs[i] instanceof TPFTestSuite) {
                        candidateElement = eobjs[i];
                        break;
                    }
                    ++i;
                }
            } else if ("testcomponent".equals(file.getFileExtension())) {
                eobjs = EMFUtil.load(null, (IFile)file);
                int i = 0;
                while (i < eobjs.length) {
                    if (eobjs[i] instanceof TPFTestComponent) {
                        candidateElement = eobjs[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        if (candidateElement != null) {
            if (LaunchConfigurationExtensionsManager.getInstance().isShortcutAvailable(candidateElement, mode)) {
                return candidateElement;
            }
        } else {
            String testID = null;
            if (element instanceof ITestSuiteProxyNode) {
                ITestSuiteProxyNode tsProxy = (ITestSuiteProxyNode)element;
                if (forceLoad) {
                    candidateElement = tsProxy.getTestSuite();
                }
                testID = tsProxy.getType();
            } else if (element instanceof ITestCaseProxyNode) {
                ITestCaseProxyNode tcProxy = (ITestCaseProxyNode)element;
                if (forceLoad) {
                    candidateElement = tcProxy.getTestCase();
                }
                testID = tcProxy.getType();
            }
            if (testID != null && LaunchConfigurationExtensionsManager.getInstance().isShortcutAvailable(testID, mode)) {
                if (forceLoad) {
                    return candidateElement;
                }
                return element;
            }
        }
        return null;
    }
}

