/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.shortcuts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.core.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.configurations.TestComponentLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.core.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.core.launch.extensions.ITestLaunchConfigurationValidator;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.launch.LaunchMessages;
import org.eclipse.hyades.test.ui.internal.launch.shortcuts.LaunchPropertyTester;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        IFileEditorInput finput;
        Object obj;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (obj = LaunchPropertyTester.getRunnableItemFromElement((finput = (IFileEditorInput)input).getFile(), mode)) != null) {
            this.launchElement(obj, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object element : ss) {
                Object launchable = LaunchPropertyTester.getRunnableItemFromElement(element, mode);
                if (launchable == null) continue;
                this.launchElement(launchable, mode);
            }
        }
    }

    private void launchElement(Object launchable, String mode) {
        ILaunchConfiguration lconfig = this.findLaunchConfiguration(launchable, mode);
        try {
            ITestLaunchConfigurationValidator.Diagnostic diag;
            if (lconfig == null) {
                lconfig = this.createLaunchConfiguration(launchable);
            }
            boolean ignoreWarnings = true;
            ITestLaunchConfigurationValidator validator = LaunchConfigurationExtensionsManager.getInstance().getLaunchConfigurationValidator(launchable);
            if (validator != null && (diag = validator.validate(lconfig, (ResourceSet)new ResourceSetImpl())) != null) {
                if (diag.getSeverity() == 0) {
                    this.reportFailure(diag);
                    return;
                }
                if (diag.getSeverity() == 1) {
                    ignoreWarnings = this.reportWarning(diag);
                }
            }
            if (lconfig != null && ignoreWarnings) {
                DebugUITools.launch((ILaunchConfiguration)lconfig, (String)mode);
            }
        }
        catch (Throwable t) {
            this.reportFailure(t);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(Object launchable, String mode) {
        ArrayList<ILaunchConfiguration> candidateConfigs;
        block10: {
            candidateConfigs = Collections.EMPTY_LIST;
            ILaunchConfigurationType configsType = this.getConfigType(launchable);
            if (configsType == null) {
                throw new NullPointerException("Configs type must be non-null");
            }
            ResourceSetImpl shortcutResourceSet = new ResourceSetImpl();
            try {
                ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configsType);
                candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
                int i = 0;
                while (i < configs.length) {
                    TPFTest configLaunchableElement = null;
                    if (launchable instanceof TPFTest) {
                        configLaunchableElement = TestLaunchConfigurationFacade.getTest((ILaunchConfiguration)configs[i], (ResourceSet)shortcutResourceSet);
                    } else if (launchable instanceof TPFTestComponent) {
                        configLaunchableElement = TestComponentLaunchConfigurationFacade.getTestComponent((ILaunchConfiguration)configs[i], (ResourceSet)shortcutResourceSet);
                    }
                    if (launchable instanceof EObject && configLaunchableElement instanceof EObject && EcoreUtil.getURI((EObject)((EObject)launchable)).equals((Object)EcoreUtil.getURI((EObject)((EObject)configLaunchableElement)))) {
                        candidateConfigs.add(configs[i]);
                    }
                    ++i;
                }
                if (candidateConfigs.size() != 0) break block10;
                return null;
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
                return null;
            }
        }
        if (candidateConfigs.size() == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        return this.chooseFromCandidateConfigs(candidateConfigs, mode);
    }

    private ILaunchConfiguration chooseFromCandidateConfigs(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        try {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getActiveShell(), (ILabelProvider)labelProvider);
            dialog.setElements(configList.toArray());
            dialog.setTitle(LaunchMessages.LaunchShortcut_ambiguousLaunchConfigurationTitle);
            if (mode.equals("debug")) {
                dialog.setMessage(LaunchMessages.LaunchShortcut_selectDebugLaunchConfigPrompt);
            } else if (mode.equals("profile")) {
                dialog.setMessage(LaunchMessages.LaunchShortcut_selectProfileLaunchConfigPrompt);
            } else {
                dialog.setMessage(LaunchMessages.LaunchShortcut_selectRunLaunchConfigPrompt);
            }
            dialog.setMultipleSelection(false);
            if (dialog.open() == 0) {
                ILaunchConfiguration iLaunchConfiguration = (ILaunchConfiguration)dialog.getFirstResult();
                return iLaunchConfiguration;
            }
            return null;
        }
        finally {
            labelProvider.dispose();
        }
    }

    private ILaunchConfiguration createLaunchConfiguration(Object launchable) throws CoreException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationType configType = this.getConfigType(launchable);
        String launchName = "";
        launchName = launchable instanceof CMNNamedElement ? this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(((CMNNamedElement)launchable).getName()) : this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(LaunchMessages.LaunchShortcut_uniqueNamePrefix);
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchName);
        if (launchable instanceof TPFTest) {
            TestLaunchConfigurationFacade.setTest((ILaunchConfigurationWorkingCopy)wc, (TPFTest)((TPFTest)launchable));
            TestLaunchConfigurationFacade.setDefaultSourcePathProvider((ILaunchConfigurationWorkingCopy)wc);
        } else if (launchable instanceof TPFTestComponent) {
            TestComponentLaunchConfigurationFacade.setTestComponent((ILaunchConfigurationWorkingCopy)wc, (TPFTestComponent)((TPFTestComponent)launchable));
        }
        IDeploymentsProvider dprovider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider(launchable);
        TPFDeployment depl = null;
        depl = dprovider.getDefaultDeployment(launchable);
        if (depl == null) {
            this.throwException(LaunchMessages._EXC_LaunchShortcut_noDefaultDeployment, null);
        }
        DeploymentLaunchConfigurationFacade.setDeployment((ILaunchConfigurationWorkingCopy)wc, (TPFDeployment)depl);
        String ehName = null;
        IContainer ehLocation = null;
        IExecutionHistoryDefaultsProvider eprovider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(launchable);
        ehName = eprovider.getDefaultName(launchable);
        if (ehName == null) {
            ehName = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultName(launchable);
        }
        if ((ehLocation = eprovider.getDefaultLocation(launchable)) == null) {
            ehLocation = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultLocation(launchable);
        }
        if (ehName == null || ehLocation == null) {
            this.throwException(LaunchMessages._EXC_LaunchShortcut_noDefaultExecHistoryInfo, null);
        }
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName((ILaunchConfigurationWorkingCopy)wc, (String)ehName);
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation((ILaunchConfigurationWorkingCopy)wc, (IContainer)ehLocation);
        config = wc.doSave();
        return config;
    }

    private void reportFailure(Throwable exception) {
        CoreException ce;
        UiPlugin.logError(exception);
        MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
        msgBox.setText(LaunchMessages.LaunchShortcut_errorDialogTitle);
        String message = null;
        if (exception instanceof CoreException && (ce = (CoreException)exception).getStatus() != null && ce.getStatus().getMessage() != null) {
            message = ce.getStatus().getMessage();
        }
        if (message == null) {
            message = LaunchMessages.LaunchShortcut_errorMessage;
        }
        msgBox.setMessage(message);
        msgBox.open();
    }

    private void reportFailure(ITestLaunchConfigurationValidator.Diagnostic diagnostic) {
        MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
        msgBox.setText(LaunchMessages.LaunchShortcut_errorDialogTitle);
        msgBox.setMessage(diagnostic.getMessage());
        msgBox.open();
    }

    private boolean reportWarning(ITestLaunchConfigurationValidator.Diagnostic diagnostic) {
        boolean hideWarningDialog = UiPlugin.getDefault().getPreferenceStore().getBoolean("HideLaunchValidationWarning");
        if (!hideWarningDialog) {
            String message = NLS.bind((String)LaunchMessages.LaunchShortcut_Message, (Object)diagnostic.getMessage());
            MessageDialogWithToggle messageDialog = this.openWarning(LaunchMessages.LaunchShortcut_Dialog_Title, message, false, UiPlugin.getDefault().getPreferenceStore(), "HideLaunchValidationWarning");
            return messageDialog.getReturnCode() == 2;
        }
        return true;
    }

    protected MessageDialogWithToggle openWarning(String title, String message, boolean toggleState, IPreferenceStore store, String key) {
        WarningDialogWithToggle dialog = new WarningDialogWithToggle(title, message, toggleState);
        dialog.setPrefStore(store);
        dialog.setPrefKey(key);
        dialog.open();
        return dialog;
    }

    private void throwException(String localizedMessage, Throwable exception) throws CoreException {
        Status status = new Status(4, UiPlugin.getID(), 0, localizedMessage, exception);
        throw new CoreException((IStatus)status);
    }

    private ILaunchConfigurationType getConfigType(Object launchable) {
        ILaunchConfigurationType configType = null;
        if (launchable instanceof TPFTest) {
            configType = TestLaunchConfigurationFacade.getLaunchConfigurationType();
        } else if (launchable instanceof TPFTestComponent) {
            configType = TestComponentLaunchConfigurationFacade.getLaunchConfigurationType();
        }
        return configType;
    }

    private Shell getActiveShell() {
        IWorkbenchWindow window = UiPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private static class WarningDialogWithToggle
    extends MessageDialogWithToggle {
        public WarningDialogWithToggle(String dialogTitle, String message, boolean toggleState) {
            super(Display.getCurrent().getActiveShell(), dialogTitle, null, message, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, LaunchMessages.LaunchShortcut_Remember_Label, toggleState);
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(buttonId);
            this.close();
            IPreferenceStore prefStore = this.getPrefStore();
            String prefKey = this.getPrefKey();
            if (prefStore != null && prefKey != null) {
                switch (buttonId) {
                    case 2: {
                        prefStore.setValue(prefKey, this.getToggleState());
                        break;
                    }
                    default: {
                        prefStore.setValue(prefKey, false);
                    }
                }
            }
        }
    }
}

