/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.core.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.extensions.IExecutionResultsLocationFilter;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.launch.LaunchMessages;
import org.eclipse.hyades.test.ui.internal.launch.providers.ExecutionHistoryLocationProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.launch.tabGroups.AbstractTabGroup;
import org.eclipse.hyades.ui.util.LocationValidator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class ExecutionHistoryTab
extends AbstractLaunchConfigurationTab {
    private Button useDefaults;
    private Composite valuesComposite;
    private TreeViewer tree;
    private Text nameText;
    private Button overwrite;
    private Button database;
    private Button testLogFile;
    private List valuesCompositeControls = new ArrayList();
    protected boolean disableNotification = false;
    private String launchConfigurationType;
    private AbstractTabGroup tabGroup;

    public ExecutionHistoryTab(String launchConfigurationType, AbstractTabGroup tabGroup) {
        this.launchConfigurationType = launchConfigurationType;
        this.tabGroup = tabGroup;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.useDefaults = new Button(composite, 32);
        this.useDefaults.setText(LaunchMessages.ExecutionHistoryTab_useDefaults);
        this.useDefaults.setToolTipText(LaunchMessages.ExecutionHistoryTab_useDefaultsTooltip);
        this.useDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionHistoryTab.this.setUserActionsPerformed(true);
                ExecutionHistoryTab.this.updateValuesCompositeEnabledState();
                ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createValuesComposite(composite);
        this.setControl((Control)composite);
    }

    private void createValuesComposite(Composite parent) {
        this.valuesCompositeControls.clear();
        this.valuesComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        this.valuesComposite.setLayout((Layout)gl);
        this.valuesComposite.setLayoutData((Object)new GridData(1808));
        this.valuesComposite.setFont(parent.getFont());
        Label lblName = new Label(this.valuesComposite, 0);
        this.valuesCompositeControls.add(lblName);
        GridData gdl = new GridData(32);
        gdl.horizontalSpan = 2;
        lblName.setLayoutData((Object)gdl);
        lblName.setText(LaunchMessages.ExecutionHistoryTab_name);
        this.nameText = new Text(this.valuesComposite, 2048);
        GridData gdt = new GridData(768);
        gdt.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gdt);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ExecutionHistoryTab.this.disableNotification) {
                    ExecutionHistoryTab.this.setUserActionsPerformed(true);
                    ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.valuesCompositeControls.add(this.nameText);
        this.overwrite = new Button(this.valuesComposite, 32);
        this.overwrite.setText(LaunchMessages.ExecutionHistoryTab_override);
        this.overwrite.setToolTipText(LaunchMessages.ExecutionHistoryTab_overrideTooltip);
        this.overwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionHistoryTab.this.disableNotification) {
                    ExecutionHistoryTab.this.setUserActionsPerformed(true);
                    ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        GridData gdl3 = new GridData(32);
        gdl3.horizontalSpan = 2;
        this.overwrite.setLayoutData((Object)gdl3);
        this.valuesCompositeControls.add(this.overwrite);
        if (ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() != 0) {
            this.database = new Button(this.valuesComposite, 32);
            this.database.setText(LaunchMessages.ExecutionHistoryTab_publishToDatabase);
            this.database.setToolTipText(LaunchMessages.ExecutionHistoryTab_publishToDatabaseTooltip);
            this.database.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!ExecutionHistoryTab.this.disableNotification) {
                        ExecutionHistoryTab.this.setUserActionsPerformed(true);
                        ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                    }
                }
            });
            GridData gdl4 = new GridData(32);
            gdl4.horizontalSpan = 2;
            this.database.setLayoutData((Object)gdl4);
            this.valuesCompositeControls.add(this.database);
            this.database.setEnabled(false);
        }
        this.testLogFile = new Button(this.valuesComposite, 32);
        this.testLogFile.setText(LaunchMessages.ExecutionHistoryTab_testLogFile);
        this.testLogFile.setToolTipText(LaunchMessages.ExecutionHistoryTab_testLogFileTooltip);
        this.testLogFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionHistoryTab.this.disableNotification) {
                    ExecutionHistoryTab.this.setUserActionsPerformed(true);
                    ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        GridData gdl5 = new GridData(32);
        gdl5.horizontalSpan = 2;
        this.testLogFile.setLayoutData((Object)gdl5);
        this.valuesCompositeControls.add(this.testLogFile);
        Label lblLocation = new Label(this.valuesComposite, 0);
        GridData gdl2 = new GridData(32);
        gdl2.horizontalSpan = 2;
        lblLocation.setLayoutData((Object)gdl2);
        lblLocation.setText(LaunchMessages.ExecutionHistoryTab_location);
        this.valuesCompositeControls.add(lblLocation);
        this.createLocationSelector(this.valuesComposite);
    }

    private void createLocationSelector(Composite composite) {
        GridData grid = new GridData(1808);
        grid.widthHint = composite.getClientArea().width / 2;
        grid.heightHint = composite.getClientArea().height / 2;
        this.tree = new TreeViewer(composite);
        this.tree.getControl().setLayoutData((Object)grid);
        IExecutionResultsLocationFilter filter = LaunchConfigurationExtensionsManager.getInstance().getExecutionResultsLocationFilter(this.launchConfigurationType);
        ExecutionHistoryLocationProvider provider = new ExecutionHistoryLocationProvider(filter);
        this.tree.setContentProvider((IContentProvider)provider);
        this.tree.setLabelProvider((IBaseLabelProvider)provider);
        this.tree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ExecutionHistoryTab.this.disableNotification) {
                    ExecutionHistoryTab.this.setUserActionsPerformed(true);
                    ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.valuesCompositeControls.add(this.tree.getControl());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ExecutionHistoryLaunchConfigurationFacade.setUseDefaults((ILaunchConfigurationWorkingCopy)configuration, (boolean)true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean useDefs = ExecutionHistoryLaunchConfigurationFacade.isUseDefaults((ILaunchConfiguration)configuration);
            this.useDefaults.setSelection(useDefs);
            this.updateValuesCompositeEnabledState();
            this.applyValuesComposite(configuration);
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
        }
    }

    private void applyValuesComposite(ILaunchConfiguration configuration) throws CoreException {
        this.disableNotification = true;
        try {
            String name = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName((ILaunchConfiguration)configuration);
            if (name == null) {
                this.nameText.setText("");
            } else {
                this.nameText.setText(name);
            }
            boolean overrideState = ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryOverriden((ILaunchConfiguration)configuration);
            this.overwrite.setSelection(overrideState);
            if (ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() != 0) {
                boolean databaseState = ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryDatabase((ILaunchConfiguration)configuration);
                this.database.setSelection(databaseState);
            }
            boolean testLogFileState = ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryTestLogFile((ILaunchConfiguration)configuration);
            this.testLogFile.setSelection(testLogFileState);
            IContainer location = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation((ILaunchConfiguration)configuration);
            if (location == null) {
                this.tree.setSelection((ISelection)new StructuredSelection());
            } else {
                StructuredSelection sel = new StructuredSelection((Object)location);
                this.tree.setSelection((ISelection)sel, true);
            }
        }
        finally {
            this.disableNotification = false;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean useDefs = this.getUseDefaultsState();
        ExecutionHistoryLaunchConfigurationFacade.setUseDefaults((ILaunchConfigurationWorkingCopy)configuration, (boolean)useDefs);
        if (!useDefs) {
            String name = this.getExecutionHistoryName();
            ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName((ILaunchConfigurationWorkingCopy)configuration, (String)name);
            boolean overrideState = this.getOverwriteState();
            ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryOverriden((ILaunchConfigurationWorkingCopy)configuration, (boolean)overrideState);
            if (ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() != 0) {
                boolean databaseState = this.getDatabaseState();
                ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryDatabase((ILaunchConfigurationWorkingCopy)configuration, (boolean)databaseState);
            }
            boolean testLogFileState = this.getTestLogFileState();
            ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryTestLogFile((ILaunchConfigurationWorkingCopy)configuration, (boolean)testLogFileState);
            IContainer location = this.getSelectedLocation();
            ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation((ILaunchConfigurationWorkingCopy)configuration, (IContainer)location);
        } else {
            try {
                this.applyValuesComposite((ILaunchConfiguration)configuration);
            }
            catch (CoreException e) {
                UiPlugin.logError(e);
            }
        }
    }

    public String getName() {
        return LaunchMessages.ExecutionHistoryTab_tabName;
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_execresultstab.gif");
    }

    protected boolean getUseDefaultsState() {
        return this.useDefaults.getSelection();
    }

    protected String getExecutionHistoryName() {
        return this.nameText.getText();
    }

    protected boolean getOverwriteState() {
        return this.overwrite.getSelection();
    }

    protected boolean getDatabaseState() {
        return this.database.getSelection();
    }

    protected boolean getTestLogFileState() {
        return this.testLogFile.getSelection();
    }

    protected IContainer getSelectedLocation() {
        Object obj;
        ISelection selection = this.tree.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IContainer) {
            return (IContainer)obj;
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        IContainer location;
        String name;
        this.setErrorMessage(null);
        try {
            name = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName((ILaunchConfiguration)configuration);
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
            name = null;
        }
        if (name == null || name.equals("")) {
            if (this.getUserActionsPerformed()) {
                this.setErrorMessage(LaunchMessages._ERROR_ExecutionHistoryTab_invalidName);
            }
            return false;
        }
        String invalidChar = LocationValidator.validateOSFileName((String)name);
        if (invalidChar != null) {
            if ("Invalid Path".equals(invalidChar)) {
                this.setErrorMessage(CommonUIMessages.OS_Invalid_Name_ERROR_);
                return false;
            }
            Object[] errors = new String[]{UiPluginResourceBundle.LOGICAL_NAME, invalidChar};
            this.setErrorMessage(NLS.bind((String)UiPluginResourceBundle._ERROR_NAME_SPECIAL_CHAR, (Object[])errors));
            return false;
        }
        try {
            location = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation((ILaunchConfiguration)configuration);
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
            location = null;
        }
        if (location == null) {
            if (this.getUserActionsPerformed()) {
                this.setErrorMessage(LaunchMessages._ERROR_ExecutionHistoryTab_invalidLocation);
            }
            return false;
        }
        String invalidChar2 = LocationValidator.validatePath((IPath)location.getFullPath());
        if (invalidChar2 != null) {
            if ("Invalid Path".equals(invalidChar2)) {
                this.setErrorMessage(CommonUIMessages.OS_Invalid_Location_ERROR_);
            } else {
                Object[] errors = new String[]{CommonUIMessages.LocationPage_PATH, invalidChar2};
                this.setErrorMessage(NLS.bind((String)CommonUIMessages._25, (Object[])errors));
            }
            return false;
        }
        return true;
    }

    protected void updateValuesCompositeEnabledState() {
        boolean enabled = !this.getUseDefaultsState();
        for (Control control : this.valuesCompositeControls) {
            control.setEnabled(enabled);
        }
    }

    private void setUserActionsPerformed(boolean state) {
        if (this.tabGroup != null) {
            this.tabGroup.setUserActionsPerformed(state);
        }
    }

    private boolean getUserActionsPerformed() {
        if (this.tabGroup != null) {
            return this.tabGroup.getUserActionsPerformed();
        }
        return true;
    }
}

