/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.core.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.core.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.core.launch.extensions.IDeploymentsProvider;
import org.eclipse.hyades.test.core.launch.extensions.ITestLaunchConfigurationValidator;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.launch.LaunchMessages;
import org.eclipse.hyades.test.ui.internal.launch.providers.DeploymentProvider;
import org.eclipse.hyades.test.ui.internal.launch.providers.LaunchFilter;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestProvider;
import org.eclipse.hyades.test.ui.launch.tabGroups.AbstractTabGroup;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class TestAndDeploymentTab
extends AbstractLaunchConfigurationTab {
    protected TreeViewer testTreeViewer;
    protected ListViewer deploymentListViewer;
    private String mode;
    private String launchConfigurationType;
    private Resource selectedTestResource;
    ITestLaunchConfigurationValidator.Diagnostic lastValidationDiagnostic;
    private ResourceSet resourceSet = new ResourceSetImpl();
    private TPFTest preservedTest;
    private TPFDeployment preservedDeployment;
    private AbstractTabGroup tabGroup;
    private boolean hasTestChanged;

    public TestAndDeploymentTab(String mode, String launchConfigurationType, AbstractTabGroup tabGroup) {
        this.mode = mode;
        this.launchConfigurationType = launchConfigurationType;
        this.tabGroup = tabGroup;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Composite col1 = new Composite(composite, 0);
        GridLayout col1l = new GridLayout();
        col1l.numColumns = 1;
        col1.setLayoutData((Object)new GridData(1808));
        col1.setLayout((Layout)col1l);
        Label lblTest = new Label(col1, 0);
        lblTest.setText(LaunchMessages.TestAndDeploymentTab_selectTestPrompt);
        this.createTestSelector(col1);
        Composite col2 = new Composite(composite, 0);
        GridLayout col2l = new GridLayout();
        col2l.numColumns = 1;
        col2.setLayoutData((Object)new GridData(1808));
        col2.setLayout((Layout)col2l);
        Label lblDeployment = new Label(col2, 0);
        lblDeployment.setText(LaunchMessages.TestAndDeploymentTab_selectDeploymentPrompt);
        this.createDeploymentSelector(col2);
        this.setControl((Control)composite);
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    LaunchConfigurationExtensionsManager.getInstance().handleLaunchDialogClosed();
                }
            });
        }
    }

    private Control createTestSelector(Composite composite) {
        GridData grid = new GridData(1808);
        grid.widthHint = 250;
        grid.heightHint = 150;
        this.testTreeViewer = new TreeViewer(composite, 2052);
        this.testTreeViewer.getControl().setLayoutData((Object)grid);
        TestProvider provider = new TestProvider(new LaunchFilter(this.mode, this.launchConfigurationType), false);
        this.testTreeViewer.setContentProvider((IContentProvider)provider);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.testTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)provider, decorator));
        this.testTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        provider.addListener(new IProxyNodeListener(){

            public void nodeChanged(Object node) {
                TestAndDeploymentTab.this.testTreeViewer.refresh(node);
            }
        });
        this.testTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TPFDeployment defaultDeployment;
                TPFTestSuite deploymentInput;
                TestAndDeploymentTab.this.hasTestChanged = true;
                TestAndDeploymentTab.this.setUserActionsPerformed(true);
                TPFTest newTest = TestAndDeploymentTab.this.getSelectedTest();
                if (newTest != null) {
                    TestAndDeploymentTab.this.preservedTest = null;
                }
                if ((deploymentInput = TestAndDeploymentTab.this.fillDeploymentsList(newTest)) == null) {
                    defaultDeployment = null;
                } else {
                    IDeploymentsProvider dprovider = LaunchConfigurationExtensionsManager.getInstance().getDeploymentsProvider((Object)deploymentInput);
                    defaultDeployment = dprovider.getDefaultDeployment((Object)deploymentInput);
                }
                TestAndDeploymentTab.this.setSelectedDeployment(defaultDeployment);
                TestAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
        return this.testTreeViewer.getControl();
    }

    private Control createDeploymentSelector(Composite composite) {
        GridData grid = new GridData(1808);
        grid.widthHint = 250;
        grid.heightHint = 150;
        this.deploymentListViewer = new ListViewer(composite, 2820);
        this.deploymentListViewer.getControl().setLayoutData((Object)grid);
        DeploymentProvider provider = new DeploymentProvider();
        this.deploymentListViewer.setContentProvider((IContentProvider)provider);
        this.deploymentListViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.deploymentListViewer.setComparer((IElementComparer)provider);
        this.deploymentListViewer.setInput(null);
        this.deploymentListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestAndDeploymentTab.this.setUserActionsPerformed(true);
                TPFDeployment newDeployment = TestAndDeploymentTab.this.getSelectedDeployment();
                if (newDeployment != null) {
                    TestAndDeploymentTab.this.preservedDeployment = null;
                }
                TestAndDeploymentTab.this.updateLaunchConfigurationDialog();
            }
        });
        return this.deploymentListViewer.getControl();
    }

    protected TPFTestSuite fillDeploymentsList(TPFTest test) {
        TPFTestSuite deploymentInput = null;
        if (test != null) {
            if (test instanceof TPFTestSuite) {
                deploymentInput = (TPFTestSuite)test;
            } else if (test instanceof TPFTestCase) {
                deploymentInput = ((TPFTestCase)test).getTestSuite();
            }
        }
        this.deploymentListViewer.setInput(deploymentInput);
        return deploymentInput;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        TestLaunchConfigurationFacade.setTest((ILaunchConfigurationWorkingCopy)configuration, (TPFTest)TestAndDeploymentTab.getContext(this.resourceSet));
        TestLaunchConfigurationFacade.setDefaultSourcePathProvider((ILaunchConfigurationWorkingCopy)configuration);
    }

    public TPFTest getSelectedTest() {
        TPFTestSuite newSelectedTest = null;
        ISelection selection = this.testTreeViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof ITestSuiteProxyNode) {
                newSelectedTest = ((ITestSuiteProxyNode)obj).getTestSuite();
            } else if (obj instanceof ITestCaseProxyNode) {
                newSelectedTest = ((ITestCaseProxyNode)obj).getTestCase();
            }
        }
        if (newSelectedTest == null || newSelectedTest.eResource() != this.selectedTestResource) {
            this.disposeSelectedTestResource();
        }
        this.selectedTestResource = newSelectedTest == null ? null : newSelectedTest.eResource();
        return newSelectedTest;
    }

    private void disposeSelectedTestResource() {
        if (this.selectedTestResource != null) {
            this.selectedTestResource.unload();
        }
    }

    private void setSelectedTest(TPFTest test) {
        IProxyNode proxyNode = ((TestProvider)this.testTreeViewer.getContentProvider()).getCorrespondingProxy(test);
        if (proxyNode != null) {
            this.testTreeViewer.setSelection((ISelection)new StructuredSelection((Object)proxyNode), true);
        } else {
            this.testTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected TPFDeployment getSelectedDeployment() {
        Object obj;
        ISelection selection = this.deploymentListViewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TPFDeployment) {
            return (TPFDeployment)obj;
        }
        return null;
    }

    private void setSelectedDeployment(TPFDeployment deployment) {
        if (deployment == null) {
            this.deploymentListViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            return;
        }
        List list = this.deploymentListViewer.getList();
        list.deselectAll();
        if (deployment == null) {
            // empty if block
        }
        int n = list.getItemCount();
        IElementComparer comparer = this.deploymentListViewer.getComparer();
        int i = 0;
        while (i < n) {
            if (comparer.equals((Object)deployment, this.deploymentListViewer.getElementAt(i))) {
                list.select(i);
                return;
            }
            ++i;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            TPFTest test = TestLaunchConfigurationFacade.getTest((ILaunchConfiguration)configuration, (ResourceSet)this.resourceSet);
            if (test != null) {
                TPFDeployment depl;
                this.preservedTest = test;
                this.setSelectedTest(test);
                this.fillDeploymentsList(this.getSelectedTest());
                this.preservedDeployment = depl = DeploymentLaunchConfigurationFacade.getDeployment((ILaunchConfiguration)configuration, (ResourceSet)this.resourceSet);
                this.setSelectedDeployment(depl);
            } else {
                this.testTreeViewer.setSelection((ISelection)new StructuredSelection());
                this.deploymentListViewer.setSelection((ISelection)new StructuredSelection());
            }
            this.hasTestChanged = false;
            this.setUserActionsPerformed(false);
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        TPFTest test = this.getSelectedTest();
        if (test == null) {
            test = this.preservedTest;
        }
        TestLaunchConfigurationFacade.setTest((ILaunchConfigurationWorkingCopy)configuration, (TPFTest)test);
        TPFDeployment depl = this.getSelectedDeployment();
        if (depl == null) {
            depl = this.preservedDeployment;
        }
        DeploymentLaunchConfigurationFacade.setDeployment((ILaunchConfigurationWorkingCopy)configuration, (TPFDeployment)depl);
        if (this.hasTestChanged) {
            ExecutionHistoryLaunchConfigurationFacade.setUseDefaults((ILaunchConfigurationWorkingCopy)configuration, (boolean)true);
            this.hasTestChanged = false;
        }
    }

    public String getName() {
        return LaunchMessages.TestAndDeploymentTab_testTabName;
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_testtab.gif");
    }

    public boolean isValid(final ILaunchConfiguration launchConfig) {
        TPFDeployment depl;
        TPFTest test;
        this.setMessage(null);
        this.setErrorMessage(null);
        boolean exceptionCaught = false;
        try {
            test = TestLaunchConfigurationFacade.getTest((ILaunchConfiguration)launchConfig, (ResourceSet)this.resourceSet);
        }
        catch (CoreException e) {
            UiPlugin.logError(e);
            test = null;
            exceptionCaught = true;
        }
        if (test == null) {
            if (!this.getUserActionsPerformed()) {
                this.setMessage(LaunchMessages.TestAndDeploymentTab_selectTestMessage);
            } else if (!exceptionCaught) {
                this.setErrorMessage(LaunchMessages._ERROR_TestAndDeploymentTab_noTestError);
            } else {
                this.setErrorMessage(LaunchMessages._ERROR_TestAndDeploymentTab_noTestException);
            }
            return false;
        }
        if (!LaunchConfigurationExtensionsManager.getInstance().isLaunchableElement((Object)test, this.mode, this.launchConfigurationType)) {
            this.setErrorMessage(LaunchMessages._ERROR_TestAndDeploymentTab_unsupportedMode);
            return false;
        }
        if (this.deploymentListViewer.getList().getItemCount() == 0) {
            this.setErrorMessage(LaunchMessages._ERROR_TestAndDeploymentTab_noDeploymentAvailable);
            return false;
        }
        exceptionCaught = false;
        try {
            depl = DeploymentLaunchConfigurationFacade.getDeployment((ILaunchConfiguration)launchConfig, (ResourceSet)this.resourceSet);
        }
        catch (CoreException e1) {
            UiPlugin.logError(e1);
            depl = null;
            exceptionCaught = true;
        }
        if (depl == null) {
            if (!exceptionCaught) {
                this.setErrorMessage(LaunchMessages._ERROR_TestAndDeploymentTab_noDeploymentError);
            } else {
                this.setErrorMessage(LaunchMessages._ERROR_TestAndDeploymentTab_noDeploymentException);
            }
            return false;
        }
        this.lastValidationDiagnostic = null;
        final ITestLaunchConfigurationValidator validator = LaunchConfigurationExtensionsManager.getInstance().getLaunchConfigurationValidator((Object)test);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                if (validator != null) {
                    TestAndDeploymentTab.this.lastValidationDiagnostic = validator.validate(launchConfig, TestAndDeploymentTab.this.resourceSet);
                }
            }
        });
        if (this.lastValidationDiagnostic != null && this.lastValidationDiagnostic.getSeverity() < 2) {
            this.setErrorMessage(this.lastValidationDiagnostic.getMessage());
            return this.lastValidationDiagnostic.getSeverity() != 0;
        }
        return true;
    }

    public static TPFTest getContext(ResourceSet resourceSet) {
        try {
            IStructuredSelection ss;
            Object obj;
            ISelection selection;
            IWorkbenchPage page = UiPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && (obj = (ss = (IStructuredSelection)selection).getFirstElement()) != null) {
                IFile file;
                if (obj instanceof ITestSuiteProxyNode) {
                    return ((ITestSuiteProxyNode)obj).getTestSuite();
                }
                if (obj instanceof TPFTest) {
                    return (TPFTest)obj;
                }
                if (obj instanceof IFile && "testsuite".equals((file = (IFile)obj).getFileExtension())) {
                    return TestAndDeploymentTab.loadTestSuite(file, resourceSet);
                }
            }
        }
        catch (Throwable t) {
            UiPlugin.logError(t);
        }
        return null;
    }

    private static TPFTestSuite loadTestSuite(IFile resource, ResourceSet resourceSet) {
        EObject[] eobjs = EMFUtil.load((ResourceSet)resourceSet, (IFile)resource);
        int i = 0;
        while (i < eobjs.length) {
            if (eobjs[i] instanceof TPFTestSuite) {
                return (TPFTestSuite)eobjs[i];
            }
            ++i;
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void dispose() {
        this.disposeSelectedTestResource();
        super.dispose();
    }

    private void setUserActionsPerformed(boolean state) {
        if (this.tabGroup != null) {
            this.tabGroup.setUserActionsPerformed(state);
        }
    }

    private boolean getUserActionsPerformed() {
        if (this.tabGroup != null) {
            return this.tabGroup.getUserActionsPerformed();
        }
        return true;
    }
}

