/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.INamedElement;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class CMNNamedElementUtil {

    public static class ElementFactory
    implements IElementFactory {
        public static final String TAG_FILE = "FILE";

        public static void save(IMemento memento, CMNNamedElement namedElement) {
            memento.putString(TAG_FILE, EMFUtil.getFilePath((EObject)namedElement));
        }

        public IAdaptable createElement(IMemento memento) {
            String filePath = memento.getString(TAG_FILE);
            if (filePath == null) {
                return null;
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(filePath);
            if (resource == null || resource.getType() != 1) {
                return null;
            }
            EObject[] eObjects = EMFUtil.load(null, (IFile)((IFile)resource));
            if (eObjects.length > 0 && eObjects[0] instanceof IAdaptable) {
                return (IAdaptable)eObjects[0];
            }
            return null;
        }
    }

    public static class NameChangeAdapter
    extends AdapterImpl
    implements IDisposable {
        private NameChangeObserver observer;

        public NameChangeAdapter(NameChangeObserver observer) {
            this.observer = observer;
        }

        public void dispose() {
            this.observer = null;
        }

        public boolean isAdapterForType(Object type) {
            return CMNNamedElement.class.isInstance(type);
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof CMNNamedElement && 2 == msg.getFeatureID(CMNNamedElement.class)) {
                switch (msg.getEventType()) {
                    case 1: 
                    case 2: {
                        this.observer.update((CMNNamedElement)msg.getNotifier(), msg.getOldStringValue());
                    }
                }
            }
        }
    }

    public static interface NameChangeObserver {
        public void update(CMNNamedElement var1, String var2);
    }

    public static class PersistableElement
    implements IPersistableElement,
    IDisposable {
        private CMNNamedElement namedElement;

        public PersistableElement(CMNNamedElement namedElement) {
            this.namedElement = namedElement;
        }

        public void dispose() {
            this.namedElement = null;
        }

        public String getFactoryId() {
            return ElementFactory.class.getName();
        }

        public void saveState(IMemento memento) {
            ElementFactory.save(memento, this.namedElement);
        }
    }

    public static class UINamedElement
    implements INamedElement,
    IDisposable {
        private CMNNamedElement namedElement;

        public UINamedElement(CMNNamedElement namedElement) {
            this.namedElement = namedElement;
        }

        public void dispose() {
            this.namedElement = null;
        }

        public Object getAdapter(Class adapter) {
            if (INamedElement.class == adapter) {
                return this;
            }
            return this.namedElement.getAdapter(adapter);
        }

        public String getDescription() {
            if (this.namedElement.getDescription() == null) {
                return "";
            }
            return this.namedElement.getDescription();
        }

        public String getName() {
            if (this.namedElement.getName() == null) {
                return this.namedElement.eClass().getName();
            }
            return this.namedElement.getName();
        }

        public void setDescription(String description) {
            this.namedElement.setDescription(description);
        }

        public void setName(String name) {
            this.namedElement.setName(name);
        }
    }

    public static class UIProxyNamedElement
    implements INamedElement,
    IDisposable {
        private CMNNamedElementProxyNode proxy;

        public UIProxyNamedElement(CMNNamedElementProxyNode proxy) {
            this.proxy = proxy;
        }

        public String getDescription() {
            return this.proxy.getDescription();
        }

        public String getName() {
            return this.proxy.getText();
        }

        public void setDescription(String description) {
            throw new UnsupportedOperationException();
        }

        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        public Object getAdapter(Class adapter) {
            if (INamedElement.class == adapter) {
                return this;
            }
            return this.proxy.getAdapter(adapter);
        }

        public void dispose() {
        }
    }
}

