/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.monitor;

import org.eclipse.hyades.test.ui.internal.monitor.DynamicDetailsPage;
import org.eclipse.hyades.test.ui.internal.monitor.OverviewFormPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;

class OverviewDetailsBlock
extends MasterDetailsBlock {
    private IManagedForm managedForm;
    private OverviewFormPart overviewPart;

    OverviewDetailsBlock() {
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        this.managedForm = managedForm;
        this.setHorizontalOrientation();
        this.overviewPart = new OverviewFormPart(parent);
        managedForm.addPart((IFormPart)this.overviewPart);
    }

    protected void registerPages(DetailsPart detailsPart) {
        final DynamicDetailsPage page = new DynamicDetailsPage();
        detailsPart.setPageProvider(new IDetailsPageProvider(){

            public Object getPageKey(Object object) {
                return "";
            }

            public IDetailsPage getPage(Object key) {
                return page;
            }
        });
        detailsPart.selectionChanged((IFormPart)this.overviewPart, (ISelection)new StructuredSelection((Object)""));
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        IToolBarManager toolbarManager = managedForm.getForm().getToolBarManager();
        Action previousDetailsAction = new Action("Previous Details", 1){

            public void run() {
            }
        };
        previousDetailsAction.setDescription("Previous Details");
        previousDetailsAction.setToolTipText("Previous Details");
        Action nextDetailsAction = new Action("Next Details", 1){

            public void run() {
            }
        };
        nextDetailsAction.setDescription("Next Details");
        nextDetailsAction.setToolTipText("Next Details");
        Action horizontalViewAction = new Action("Horizontal View Orientation", 8){

            public void run() {
                OverviewDetailsBlock.this.setHorizontalOrientation();
            }
        };
        horizontalViewAction.setChecked(true);
        horizontalViewAction.setDescription("Horizontal View Orientation");
        horizontalViewAction.setToolTipText("Horizontal View Orientation");
        Action verticalViewAction = new Action("Vertical View Orientation", 8){

            public void run() {
                OverviewDetailsBlock.this.setVerticalOrientation();
            }
        };
        verticalViewAction.setDescription("Vertical View Orientation");
        verticalViewAction.setToolTipText("Vertical View Orientation");
        Action overviewViewOnlyAction = new Action("Overview View Only", 8){

            public void run() {
                OverviewDetailsBlock.this.setMaximizeOverview(true);
            }
        };
        overviewViewOnlyAction.setDescription("Overview View Only");
        overviewViewOnlyAction.setToolTipText("Overview View Only");
        toolbarManager.add((IAction)previousDetailsAction);
        toolbarManager.add((IAction)nextDetailsAction);
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)horizontalViewAction);
        toolbarManager.add((IAction)verticalViewAction);
        toolbarManager.add((IAction)overviewViewOnlyAction);
    }

    private void setMaximizeOverview(boolean maximizeOverview) {
        this.sashForm.setMaximizedControl(maximizeOverview ? this.sashForm.getChildren()[0] : null);
    }

    private void setHorizontalOrientation() {
        this.setMaximizeOverview(false);
        this.sashForm.setOrientation(256);
        this.managedForm.reflow(true);
    }

    private void setVerticalOrientation() {
        this.setMaximizeOverview(false);
        this.sashForm.setOrientation(512);
        this.managedForm.reflow(true);
    }

    void collapseAll() {
        this.overviewPart.collapseSections();
    }

    void expandAll() {
        this.overviewPart.expandSections();
    }
}

