/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IFileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNodeListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public abstract class TestNavigatorContentProvider
implements ITreeContentProvider {
    private static final int MAX_PROXY_NODE_CHILDREN = 100;
    public static final int CONTEXT_LOADING = 0;
    public static final int CONTEXT_INTERACTIVE = 1;
    protected TestNavigator testNavigator;
    private int context;

    public TestNavigatorContentProvider(TestNavigator testNavigator) {
        this.testNavigator = testNavigator;
        this.context = 0;
    }

    protected abstract IGlobalProxyNodeListener getProxyNodeListener();

    protected abstract IFileProxyManager getFileProxyManager();

    public Object getParent(Object element) {
        if (element instanceof IProxyNode) {
            Object parent = ((IProxyNode)element).getParent();
            if (parent instanceof FileProxyManager.IUnboundedParent) {
                return this.getFileProxyManager().getParent((IProxyNode)element);
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        if (parentElement instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)parentElement;
            return proxy.getChildren().length > 0;
        }
        return parentElement instanceof IProxyGroup;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProxyNode) {
            IProxyNode proxy = (IProxyNode)parentElement;
            return this.foldProxyNodes(proxy);
        }
        if (parentElement instanceof IProxyGroup) {
            return ((IProxyGroup)parentElement).getChildren();
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            IProject[] projects = ((IWorkspaceRoot)inputElement).getProjects();
            LinkedList<IProject> visibleProjects = new LinkedList<IProject>();
            int i = 0;
            while (i < projects.length) {
                if (!TestNavigator.getFiltersManager().filter(projects[i])) {
                    visibleProjects.add(projects[i]);
                }
                ++i;
            }
            return visibleProjects.toArray();
        }
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    protected Object[] foldProxyNodes(IProxyNode parent) {
        Object[] children = parent.getChildren();
        int length = children.length;
        if (length <= 100) {
            return children;
        }
        int size = length / 100;
        int remaining = length % 100;
        int totalSize = size + (remaining > 0 ? 1 : 0);
        Object[] groups = new IProxyGroup[totalSize];
        int i = 0;
        while (i < size) {
            groups[i] = new ProxyGroup(parent, i);
            ++i;
        }
        if (remaining > 0) {
            groups[size] = new RemainingProxyGroup(parent);
        }
        return groups;
    }

    public void setContext(int context) {
        this.context = context;
    }

    protected int getContext() {
        return this.context;
    }

    protected int getResponseTime() {
        switch (this.context) {
            case 1: {
                return 800;
            }
            case 0: {
                return 100;
            }
        }
        return 100;
    }

    protected int getJobPriority() {
        switch (this.context) {
            case 1: {
                return 10;
            }
            case 0: {
                return 30;
            }
        }
        return 30;
    }

    public static interface IGlobalProxyNodeListener
    extends IProxyNodeListener {
        public void nodesChanged();
    }

    public static interface IProxyGroup
    extends IProxyNode {
        public int getOrder();
    }

    private static class ProxyGroup
    implements IProxyGroup {
        private IProxyNode parent;
        private int sequence;

        public ProxyGroup(IProxyNode node, int sequence) {
            this.parent = node;
            this.sequence = sequence;
        }

        public IProxyNode[] getChildren() {
            int start = this.sequence * 100;
            IProxyNode[] completeChildren = this.parent.getChildren();
            IProxyNode[] children = new IProxyNode[100];
            System.arraycopy(completeChildren, start, children, 0, 100);
            return children;
        }

        public String getText() {
            int start = this.sequence * 100 + 1;
            int end = (this.sequence + 1) * 100;
            return "[".concat(Integer.toString(start)).concat(" - ").concat(Integer.toString(end)).concat("]");
        }

        public Image getImage() {
            return this.parent.getImage();
        }

        public int getOrder() {
            return this.sequence;
        }

        public Object getParent() {
            return this.parent;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getIdentifier() {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }
    }

    private static class RemainingProxyGroup
    implements IProxyGroup {
        private IProxyNode parent;

        public RemainingProxyGroup(IProxyNode parent) {
            this.parent = parent;
        }

        public IProxyNode[] getChildren() {
            IProxyNode[] completeChildren = this.parent.getChildren();
            int completeLength = completeChildren.length;
            int length = completeLength % 100;
            IProxyNode[] children = new IProxyNode[length];
            System.arraycopy(completeChildren, completeLength - length, children, 0, length);
            return children;
        }

        public String getText() {
            IProxyNode[] completeChildren = this.parent.getChildren();
            int end = completeChildren.length;
            int length = end % 100;
            int start = end - length + 1;
            return "[".concat(Integer.toString(start)).concat(" - ").concat(Integer.toString(end)).concat("]");
        }

        public Image getImage() {
            return this.parent.getImage();
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public Object getParent() {
            return this.parent;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getIdentifier() {
            return null;
        }

        public IResource getUnderlyingResource() {
            return null;
        }
    }
}

