/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.navigator.IHyadesTestNavigatorFilter;

public class TestNavigatorFilterExtensionsManager {
    private List filters = new LinkedList();

    public TestNavigatorFilterExtensionsManager() {
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(UiPlugin.getID()) + ".testNavigatorFilter");
        if (extPoint != null) {
            IConfigurationElement[] members = extPoint.getConfigurationElements();
            int i = 0;
            while (i < members.length) {
                if (members[i].getName() != null) {
                    try {
                        IHyadesTestNavigatorFilter filter = (IHyadesTestNavigatorFilter)members[i].createExecutableExtension("class");
                        this.addFilter(filter);
                    }
                    catch (CoreException e) {
                        UiPlugin.logError(e);
                    }
                }
                ++i;
            }
        }
    }

    public void addFilter(IHyadesTestNavigatorFilter filter) {
        this.filters.add(filter);
    }

    public boolean isVisibleResource(IResource resource) {
        if (resource.getType() != 1) {
            return !this.filter(resource);
        }
        String fileExtension = resource.getFileExtension();
        if (fileExtension != null) {
            return TestNavigator.getFileFactoryManager().isRegistered(fileExtension) && !this.filter(resource);
        }
        return false;
    }

    public boolean filter(Object element) {
        if (element == null) {
            return true;
        }
        for (IHyadesTestNavigatorFilter filter : this.filters) {
            if (!filter.isFiltered(element)) continue;
            return true;
        }
        return false;
    }

    public Object[] filterChildren(Object[] children) {
        if (children == null) {
            return new Object[0];
        }
        LinkedList<Object> res = new LinkedList<Object>();
        int i = 0;
        while (i < children.length) {
            if (!this.filter(children[i])) {
                res.add(children[i]);
            }
            ++i;
        }
        return res.toArray();
    }
}

