/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.UiPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigatorMessages;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TestNavigatorLabelProvider
implements ILabelProvider,
ILabelProviderListener {
    private WorkbenchLabelProvider workbenchProvider = new WorkbenchLabelProvider();
    private List listeners = new LinkedList();

    private IWorkbenchAdapter getWorkbenchAdapter(Object object) {
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(object, IWorkbenchAdapter.class);
        if (workbenchAdapter == this) {
            return null;
        }
        return workbenchAdapter;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IContainer) {
            return this.workbenchProvider.getImage(element);
        }
        if (element instanceof IProxyNode) {
            Image image = ((IProxyNode)element).getImage();
            if (image == null) {
                return this.workbenchProvider.getImage(element);
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof IContainer) {
            IWorkbenchAdapter workbenchAdapter = this.getWorkbenchAdapter(element);
            if (workbenchAdapter != null) {
                return workbenchAdapter.getLabel(element);
            }
        } else if (element instanceof IProxyNode) {
            String text = ((IProxyNode)element).getText();
            if (text != null && text.trim().length() > 0) {
                return text;
            }
            return String.valueOf('<') + TestNavigatorMessages.TEST_NAVIGATOR_UNNAMED_ELEMENT + '>';
        }
        return "";
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.workbenchProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (!this.listeners.remove(listener)) {
            UiPlugin.logInfo("Unable to remove listener '" + listener.toString());
        }
    }
}

